/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.task;

import com.javapro.task.Task;
import com.javapro.task.TaskPersistStrategy;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class TaskScheduler {
    private Timer schedulerThread = new Timer(false);
    private ArrayList taskList;
    private long initTime = System.currentTimeMillis();
    private TaskPersistStrategy persistStrategy = null;
    private static Boolean semaphore = new Boolean(true);
    private static TaskScheduler globalTaskScheduler = null;

    public TaskScheduler() {
        this.taskList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistStrategy(TaskPersistStrategy taskPersistStrategy) {
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            this.persistStrategy = taskPersistStrategy;
        }
    }

    public long getSchedulerStartTime() {
        return this.initTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Task task) throws IllegalStateException, Exception {
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            this.cleanupAll();
            if (this.taskList.contains(task)) {
                throw new IllegalStateException("Task was already scheduled");
            }
            Date date = new Date(task.getScheduledFirstTime());
            RunTask runTask = new RunTask(task);
            if (task.getScheduledInterval() <= 0L) {
                this.schedulerThread.schedule((TimerTask)runTask, date);
            } else {
                this.schedulerThread.scheduleAtFixedRate((TimerTask)runTask, date, task.getScheduledInterval());
            }
            task.scheduler = this;
            this.taskList.add(task);
            this.persist(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(boolean bl) {
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            this.taskList.clear();
            this.schedulerThread.cancel();
            if (bl) {
                this.schedulerThread = new Timer(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] getRunningTasks() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        this.cleanupAll();
        Task[] taskArray = this;
        synchronized (this) {
            int n;
            for (n = 0; n < this.taskList.size(); ++n) {
                Task task = (Task)this.taskList.get(n);
                if (task.isCancelled()) continue;
                arrayList.add(task);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            taskArray = new Task[arrayList.size()];
            for (n = 0; n < taskArray.length; ++n) {
                taskArray[n] = (Task)arrayList.get(n);
            }
            return taskArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task findTaskByID(long l) {
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            for (int i = 0; i < this.taskList.size(); ++i) {
                Task task = (Task)this.taskList.get(i);
                if (task.getID() != l) continue;
                return task;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(Task task) {
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            if (this.taskList.contains(task) && task.isCancelled()) {
                this.taskList.remove(task);
                if (this.persistStrategy != null) {
                    this.persistStrategy.delete(task);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persist(Task task) throws Exception {
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            if (this.persistStrategy != null) {
                this.persistStrategy.write(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAll() {
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            for (int i = 0; i < this.taskList.size(); ++i) {
                Task task = (Task)this.taskList.get(i);
                if (!task.isCancelled()) continue;
                this.taskList.remove(i);
                if (this.persistStrategy != null) {
                    this.persistStrategy.delete(task);
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskScheduler getInstance() {
        Boolean bl = semaphore;
        synchronized (bl) {
            if (globalTaskScheduler == null) {
                globalTaskScheduler = new TaskScheduler();
            }
            return globalTaskScheduler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Boolean bl = semaphore;
        synchronized (bl) {
            TaskScheduler.globalTaskScheduler.schedulerThread.cancel();
        }
    }

    private class RunTask
    extends TimerTask {
        private Task task;

        public RunTask(Task task) {
            this.task = task;
        }

        public void run() {
            if (this.task.isCancelled()) {
                this.cancel();
                return;
            }
            Thread thread = new Thread(this.task);
            thread.start();
            this.task.setLastRunTime(System.currentTimeMillis());
        }
    }
}

