/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import com.jhlabs.awt.Alignment;
import com.jhlabs.awt.ConstraintLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class BasicGridLayout
extends ConstraintLayout {
    protected int hGap;
    protected int vGap;
    protected int rows;
    protected int cols;
    protected int reqRows;
    protected int reqCols;
    protected int[] rowHeights;
    protected int[] colWidths;
    protected int alignment = 8;
    protected int fill = 3;
    protected int colWeight = 0;
    protected int rowWeight = 0;

    public BasicGridLayout() {
        this(0, 1, 2, 2);
    }

    public BasicGridLayout(int n, int n2) {
        this(n, n2, 2, 2);
    }

    public BasicGridLayout(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0);
    }

    public BasicGridLayout(int n, int n2, int n3, int n4, int n5, int n6) {
        this.reqRows = n;
        this.reqCols = n2;
        this.hGap = n3;
        this.vGap = n4;
        this.hMargin = n5;
        this.vMargin = n6;
    }

    public void setColumns(int n) {
        if (n < 1) {
            n = 1;
        }
        this.cols = n;
    }

    public void setRows(int n) {
        if (n < 1) {
            n = 1;
        }
        this.rows = n;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setFill(int n) {
        this.fill = n;
    }

    public int getFill() {
        return this.fill;
    }

    public void setColWeight(int n) {
        this.colWeight = n;
    }

    public int getColWeight() {
        return this.colWeight;
    }

    public void setRowWeight(int n) {
        this.rowWeight = n;
    }

    public int getRowWeight() {
        return this.rowWeight;
    }

    protected int alignmentFor(Component component, int n, int n2) {
        return this.alignment;
    }

    protected int fillFor(Component component, int n, int n2) {
        return this.fill;
    }

    protected int getRowWeight(int n) {
        return this.getRowWeight();
    }

    protected int getColWeight(int n) {
        return this.getColWeight();
    }

    protected int sumArray(int[] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += nArray[i];
        }
        if (n2 > 1) {
            n3 += (n2 - 1) * n;
        }
        return n3;
    }

    protected void calcCellSizes(Container container, int n) {
        int n2;
        int n3;
        int n4;
        Cloneable cloneable;
        Serializable serializable;
        int n5;
        int n6 = container.getComponentCount();
        if (this.reqCols <= 0) {
            this.rows = this.reqRows;
            this.cols = (n6 + this.reqRows - 1) / this.reqRows;
        } else {
            this.rows = (n6 + this.reqCols - 1) / this.reqCols;
            this.cols = this.reqCols;
        }
        this.colWidths = new int[this.cols];
        for (n5 = 0; n5 < this.cols; ++n5) {
            this.colWidths[n5] = 0;
        }
        this.rowHeights = new int[this.rows];
        for (n5 = 0; n5 < this.rows; ++n5) {
            this.rowHeights[n5] = 0;
        }
        int n7 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            serializable = container.getComponent(n5);
            if (!this.includeComponent((Component)serializable)) continue;
            cloneable = this.getComponentSize((Component)serializable, n);
            n4 = n7 / this.cols;
            n3 = n7 % this.cols;
            if (this.colWidths[n3] < ((Dimension)cloneable).width) {
                this.colWidths[n3] = ((Dimension)cloneable).width;
            }
            if (this.rowHeights[n4] < ((Dimension)cloneable).height) {
                this.rowHeights[n4] = ((Dimension)cloneable).height;
            }
            ++n7;
        }
        serializable = container.getSize();
        cloneable = container.getInsets();
        serializable.width -= cloneable.left + cloneable.right + 2 * this.hMargin;
        serializable.height -= cloneable.top + cloneable.bottom + 2 * this.vMargin;
        n3 = 0;
        n4 = 0;
        for (n5 = 0; n5 < this.cols; ++n5) {
            n4 += this.getColWeight(n5);
            n3 += this.colWidths[n5];
            if (n5 == 0) continue;
            n3 += this.hGap;
        }
        if (n4 != 0 && n3 < serializable.width) {
            n2 = serializable.width - n3;
            for (n5 = 0; n5 < this.cols; ++n5) {
                int n8 = n5;
                this.colWidths[n8] = this.colWidths[n8] + n2 * this.getColWeight(n5) / n4;
            }
        }
        n3 = 0;
        n4 = 0;
        for (n5 = 0; n5 < this.rows; ++n5) {
            n4 += this.getRowWeight(n5);
            n3 += this.rowHeights[n5];
            if (n5 == 0) continue;
            n3 += this.vGap;
        }
        if (n4 != 0 && n3 < serializable.height) {
            n2 = serializable.height - n3;
            for (n5 = 0; n5 < this.rows; ++n5) {
                int n9 = n5;
                this.rowHeights[n9] = this.rowHeights[n9] + n2 * this.getRowWeight(n5) / n4;
            }
        }
    }

    public void measureLayout(Container container, Dimension dimension, int n) {
        if (dimension != null) {
            this.calcCellSizes(container, n);
            dimension.width = this.sumArray(this.colWidths, this.hGap, this.cols);
            dimension.height = this.sumArray(this.rowHeights, this.vGap, this.rows);
            this.colWidths = null;
            this.rowHeights = null;
        } else {
            int n2 = container.getComponentCount();
            if (n2 > 0) {
                Insets insets = container.getInsets();
                Dimension dimension2 = container.getSize();
                int n3 = 0;
                this.calcCellSizes(container, n);
                for (int i = 0; i < n2; ++i) {
                    Component component = container.getComponent(i);
                    if (!this.includeComponent(component)) continue;
                    Dimension dimension3 = this.getComponentSize(component, n);
                    Rectangle rectangle = new Rectangle(0, 0, dimension3.width, dimension3.height);
                    int n4 = n3 / this.cols;
                    int n5 = n3 % this.cols;
                    int n6 = insets.left + this.sumArray(this.colWidths, this.hGap, n5) + this.hMargin;
                    int n7 = insets.top + this.sumArray(this.rowHeights, this.vGap, n4) + this.vMargin;
                    if (n5 > 0) {
                        n6 += this.hGap;
                    }
                    if (n4 > 0) {
                        n7 += this.vGap;
                    }
                    Rectangle rectangle2 = new Rectangle(n6, n7, this.colWidths[n5], this.rowHeights[n4]);
                    Alignment.alignInCell(rectangle, rectangle2, this.alignmentFor(component, n4, n5), this.fillFor(component, n4, n5));
                    component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    ++n3;
                }
            }
            this.colWidths = null;
            this.rowHeights = null;
        }
    }
}

