/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;

public class BeanUtils {
    private BeanUtils() {
    }

    private static PropertyDescriptor getPropertyDescriptor(Object object, String string) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            if (!propertyDescriptorArray[i].getName().equals(string)) continue;
            propertyDescriptor = propertyDescriptorArray[i];
            break;
        }
        return propertyDescriptor;
    }

    public static Object getProperty(Object object, String string) throws NoSuchMethodException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        Method method;
        Object object2 = null;
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(object, string);
        if (propertyDescriptor != null) {
            method = propertyDescriptor.getReadMethod();
            if (method == null) {
                throw new NoSuchMethodException("No reader for " + string + " property");
            }
        } else {
            throw new NoSuchMethodException("No " + string + " property");
        }
        object2 = method.invoke(object, new Object[0]);
        return object2;
    }

    public static Map getProperties(Object object) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(propertyDescriptorArray.length);
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            Method method = propertyDescriptorArray[i].getReadMethod();
            if (method == null) continue;
            Object object2 = method.invoke(object, new Object[0]);
            hashMap.put(propertyDescriptorArray[i].getName(), object2);
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        JButton jButton = new JButton("Help");
        System.out.println("----- Testing BeanUtils methods -----");
        try {
            String string = (String)BeanUtils.getProperty(jButton, "text");
            System.out.println("getProperty():");
            System.out.println(" - Button label (text): " + string);
            Map map = BeanUtils.getProperties(jButton);
            Set set = map.entrySet();
            System.out.println("getProperties():");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                System.out.println(" - " + entry.getKey() + ":\t" + entry.getValue());
            }
        }
        catch (Exception exception) {
            System.out.println("*** Failed in property get: " + exception);
            exception.printStackTrace();
        }
    }
}

