/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import com.slackandassociates.FileChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class FileMonitor {
    private static final FileMonitor instance = new FileMonitor();
    private Timer timer = new Timer(true);
    private Hashtable timerEntries = new Hashtable();

    public static FileMonitor getInstance() {
        return instance;
    }

    protected FileMonitor() {
    }

    public void addFileChangeListener(FileChangeListener fileChangeListener, String string, long l) throws FileNotFoundException {
        this.removeFileChangeListener(fileChangeListener, string);
        FileMonitorTask fileMonitorTask = new FileMonitorTask(fileChangeListener, string);
        this.timerEntries.put(string + fileChangeListener.hashCode(), fileMonitorTask);
        this.timer.schedule((TimerTask)fileMonitorTask, l, l);
    }

    public void removeFileChangeListener(FileChangeListener fileChangeListener, String string) {
        FileMonitorTask fileMonitorTask = (FileMonitorTask)this.timerEntries.remove(string + fileChangeListener.hashCode());
        if (fileMonitorTask != null) {
            fileMonitorTask.cancel();
        }
    }

    protected void fireFileChangeEvent(FileChangeListener fileChangeListener, String string) {
        fileChangeListener.fileChanged(string);
    }

    public static class SimpleTest
    implements FileChangeListener {
        private static final String testa = "testa";
        private static final String testb = "testb";
        private static final String testc = "testc";

        public void fileChanged(String string) {
            System.out.println("File Changed: " + string);
        }

        public static void main(String[] stringArray) throws Exception {
            int n;
            File file = new File(testa);
            file.createNewFile();
            File file2 = new File(testb);
            file2.createNewFile();
            File file3 = new File(testc);
            file3.createNewFile();
            SimpleTest simpleTest = new SimpleTest();
            FileMonitor fileMonitor = FileMonitor.getInstance();
            fileMonitor.addFileChangeListener(simpleTest, testa, 3000L);
            fileMonitor.addFileChangeListener(simpleTest, testb, 5000L);
            fileMonitor.addFileChangeListener(simpleTest, testc, 7000L);
            for (n = 0; n < 16; ++n) {
                file.setLastModified(System.currentTimeMillis());
                file2.setLastModified(System.currentTimeMillis());
                file3.setLastModified(System.currentTimeMillis());
                Thread.sleep(1000L);
            }
            System.out.println();
            fileMonitor.removeFileChangeListener(simpleTest, testa);
            for (n = 0; n < 16; ++n) {
                file.setLastModified(System.currentTimeMillis());
                file2.setLastModified(System.currentTimeMillis());
                file3.setLastModified(System.currentTimeMillis());
                Thread.sleep(1000L);
            }
            System.out.println();
            fileMonitor.removeFileChangeListener(simpleTest, testb);
            for (n = 0; n < 16; ++n) {
                file.setLastModified(System.currentTimeMillis());
                file2.setLastModified(System.currentTimeMillis());
                file3.setLastModified(System.currentTimeMillis());
                Thread.sleep(1000L);
            }
            file.delete();
            file2.delete();
            file3.delete();
        }
    }

    class FileMonitorTask
    extends TimerTask {
        FileChangeListener listener;
        String fileName;
        File monitoredFile;
        long lastModified;

        public FileMonitorTask(FileChangeListener fileChangeListener, String string) throws FileNotFoundException {
            this.listener = fileChangeListener;
            this.fileName = string;
            this.lastModified = 0L;
            this.monitoredFile = new File(string);
            if (!this.monitoredFile.exists()) {
                URL uRL = fileChangeListener.getClass().getClassLoader().getResource(string);
                if (uRL != null) {
                    this.monitoredFile = new File(uRL.getFile());
                } else {
                    throw new FileNotFoundException("File Not Found: " + string);
                }
            }
            this.lastModified = this.monitoredFile.lastModified();
        }

        public void run() {
            long l = this.monitoredFile.lastModified();
            if (l != this.lastModified) {
                this.lastModified = l;
                FileMonitor.this.fireFileChangeEvent(this.listener, this.fileName);
            }
        }
    }
}

