/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.InputStream;

public class ImageCanvas
extends Canvas {
    private Image image;

    public ImageCanvas(Image image) {
        this.loadImage(image);
    }

    public ImageCanvas(Class clazz, String string) {
        try {
            InputStream inputStream = clazz.getResourceAsStream(string);
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            this.loadImage(image);
        }
        catch (Exception exception) {
            System.out.println("ImageCanvas() - Cannot load '" + string + "' with class '" + clazz.getName() + "'.");
            exception.printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }

    private void loadImage(Image image) {
        this.image = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Cannot load image");
        }
        this.setSize(image.getWidth(null), image.getHeight(null));
    }

    public void setImage(Image image) {
        if (image != null) {
            this.image = image;
            this.repaint();
        }
    }
}

