/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.test;

import com.slackandassociates.FileChangeListener;
import com.slackandassociates.FileMonitor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FCL_Example
implements FileChangeListener {
    private static final String PROPERTIES_FILE = "fcl_example.properties";
    private boolean useClasspath;
    private long checkPeriod;
    private String emailAddr;
    private int logLevel;

    public FCL_Example(boolean bl) {
        this.useClasspath = bl;
        this.reloadProperties();
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public synchronized void setCheckPeriod(long l) {
        this.log("Setting checkPeriod: " + l);
        this.checkPeriod = l;
        try {
            FileMonitor.getInstance().addFileChangeListener(this, PROPERTIES_FILE, this.checkPeriod);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public String getEmailAddress() {
        return this.emailAddr;
    }

    private synchronized void setEmailAddress(String string) {
        this.log("Setting emailAddress: " + string);
        this.emailAddr = string;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    private synchronized void setLogLevel(int n) {
        this.log("Setting log level: " + n);
        this.logLevel = n;
    }

    private void reloadProperties() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.useClasspath ? this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE) : new FileInputStream(PROPERTIES_FILE);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setCheckPeriod(Long.parseLong(properties.getProperty("checkPeriod")));
        this.setEmailAddress(properties.getProperty("emailAddress"));
        this.setLogLevel(Integer.parseInt(properties.getProperty("logLevel")));
    }

    public void fileChanged(String string) {
        this.reloadProperties();
    }

    private void log(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        try {
            bl = Boolean.valueOf(stringArray[0]);
        }
        catch (Exception exception) {
            System.out.println("Usage: java FCL_Example <true|false>");
            System.exit(1);
        }
        FCL_Example fCL_Example = new FCL_Example(bl);
        Thread.sleep(60000L);
    }
}

