/*
 * Decompiled with CFR 0.152.
 */
import java.util.EventObject;

public class CribBoardEvent
extends EventObject {
    public static final int CBE_NO_EVENT = 0;
    public static final int CBE_CUSTOM_EVENT = 1;
    public static final int CBE_MOVE_STARTED = 2;
    public static final int CBE_MOVE_COMPLETED = 3;
    public static final int CBE_CRIB_BOARD_RESET = 4;
    public static final int CBE_PLAYER_WON = 5;
    private int event = 0;
    private String custom = "";
    private int winner = -1;

    public CribBoardEvent(Object object, int n) {
        super(object);
        if (n >= 1 && n <= 5) {
            this.event = n;
        }
    }

    public CribBoardEvent(Object object, String string) {
        this(object, 1);
        if (string != null) {
            this.custom = string;
        }
    }

    public CribBoardEvent(Object object, boolean bl, int n) {
        this(object, 5);
        if (bl) {
            this.winner = n;
        }
    }

    public int getEvent() {
        return this.event;
    }

    public String getCustomEvent() {
        return this.custom;
    }

    public int getWinningPlayer() {
        return this.winner;
    }

    public String toString() {
        String string = "CribBoardEvent [";
        switch (this.event) {
            case 0: {
                string = string + "No event";
                break;
            }
            case 1: {
                string = string + "Custom event - '" + this.custom + "'";
                break;
            }
            case 2: {
                string = string + "Peg move started";
                break;
            }
            case 3: {
                string = string + "Peg move completed";
                break;
            }
            case 4: {
                string = string + "Cribbage board reset";
                break;
            }
            case 5: {
                string = string + "Player (" + this.winner + ") has won";
                break;
            }
            default: {
                string = string + "Unknown (" + this.event + ")";
            }
        }
        string = string + "]";
        return string;
    }
}

