/*
 * Decompiled with CFR 0.152.
 */
import com.slackandassociates.cards.CardEnum;
import com.slackandassociates.cards.playingcards.PlayingCardEnum;
import java.io.InputStream;
import java.util.Properties;

public class CribbageProps {
    private static final String S_LEAD = "Cribbage.";
    private static final String S_PROPSNAME = "Cribbage.properties";
    private static final String S_IMAGEPATH = "images/";
    private static final String S_SOUNDPATH = "sounds/";
    private static final int I_CARDBACK = 2;
    private static final String S_HELPPATH = "help/";
    private static final String S_COMPNAME = "Computer";
    private static final String S_PLAYNAME = "Player";
    private CardEnum[] cardBacks = new CardEnum[]{PlayingCardEnum.JC_CARDBACK_VAL1, PlayingCardEnum.JC_CARDBACK_VAL2, PlayingCardEnum.JC_CARDBACK_VAL3, PlayingCardEnum.JC_CARDBACK_VAL4, PlayingCardEnum.JC_CARDBACK_VAL5, PlayingCardEnum.JC_CARDBACK_VAL6};
    private Properties props = new Properties();

    public CribbageProps(Object object) {
        try {
            InputStream inputStream = object.getClass().getResourceAsStream(S_PROPSNAME);
            this.props.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Properties failed to load: " + exception);
        }
    }

    public String getVersionInfo() {
        if (this.props != null) {
            return this.props.getProperty("Cribbage.Version");
        }
        return "";
    }

    public String getAuthorEmail() {
        if (this.props != null) {
            return this.props.getProperty("Cribbage.eMail");
        }
        return "";
    }

    public String getImagePath() {
        String string;
        String string2 = S_IMAGEPATH;
        if (this.props != null && (string = this.props.getProperty("Cribbage.ImagePath")) != null && !"".equals(string)) {
            string2 = string;
        }
        return string2;
    }

    public String getSoundPath() {
        String string;
        String string2 = S_SOUNDPATH;
        if (this.props != null && (string = this.props.getProperty("Cribbage.SoundPath")) != null && !"".equals(string)) {
            string2 = string;
        }
        return string2;
    }

    public boolean getGameSoundsOn() {
        String string;
        boolean bl = false;
        if (this.props != null && (string = this.props.getProperty("Cribbage.SoundsOn")) != null && !"".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public PlayingCardEnum getCardBackImage() {
        String string;
        PlayingCardEnum playingCardEnum = (PlayingCardEnum)this.cardBacks[2];
        if (this.props != null && (string = this.props.getProperty("Cribbage.CardBackImage")) != null && !"".equals(string)) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 2;
            }
            if (n < 0 || n >= this.cardBacks.length) {
                n = 2;
            }
            playingCardEnum = (PlayingCardEnum)this.cardBacks[n];
        }
        return playingCardEnum;
    }

    public boolean getAlwaysStart() {
        String string;
        boolean bl = false;
        if (this.props != null && (string = this.props.getProperty("Cribbage.AlwaysStart")) != null && !"".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public String getHelpPath() {
        String string;
        String string2 = S_HELPPATH;
        if (this.props != null && (string = this.props.getProperty("Cribbage.HelpPath")) != null && !"".equals(string)) {
            string2 = string;
        }
        return string2;
    }

    public String getCompName() {
        String string;
        String string2 = S_COMPNAME;
        if (this.props != null && (string = this.props.getProperty("Cribbage.ComputerName")) != null && !"".equals(string)) {
            string2 = string;
        }
        return string2;
    }

    public String getPlayName() {
        String string;
        String string2 = S_PLAYNAME;
        if (this.props != null && (string = this.props.getProperty("Cribbage.PlayerName")) != null && !"".equals(string)) {
            string2 = string;
        }
        return string2;
    }
}

