/*
 * Decompiled with CFR 0.152.
 */
import au.com.virturo.guiutils.Spinner;
import com.slackandassociates.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CribbageScoreDlg
extends JDialog {
    private static final String S_POINTS = "Points";
    private static final String S_CRIBPOINTS = "Crib Points";
    private static final String S_HOWMANY = "How many points do you have?";
    private static final String S_INVALID = "Invalid number entered.";
    private static final String S_TOOMANY = "Too many points for that hand!";
    private static final String S_MSGTIT = "Error";
    private static final int D_DLG_WIDTH = 200;
    private static final int D_DLG_HEIGHT = 130;
    private JPanel dPnl1 = new JPanel();
    private JPanel dPnl2 = new JPanel();
    private JPanel dPnl3 = new JPanel();
    private JLabel dL1 = new JLabel("How many points do you have?", 0);
    private JTextField textFld = new JTextField("0", 3);
    private Spinner spinEdit = new Spinner(this.textFld);
    private JButton dB1 = new JButton("OK");
    private ImageIcon mbStopImg = null;
    private int maxPoints = 0;
    public int retPoints = 0;

    public CribbageScoreDlg(JFrame jFrame, boolean bl, int n, ImageIcon imageIcon) {
        super(jFrame, S_POINTS, true);
        if (bl) {
            this.setTitle(S_CRIBPOINTS);
        }
        this.maxPoints = n;
        this.mbStopImg = imageIcon;
        this.setupDialog();
        Utilities.centerDialog(jFrame, this);
    }

    private void setupDialog() {
        Container container = this.getContentPane();
        ((Component)this).setSize(200, 130);
        container.setLayout(new BorderLayout());
        this.dPnl1.setLayout(new GridLayout(2, 1));
        this.dL1.setFont(new Font("Helvetica", 0, 12));
        this.dPnl1.add(this.dL1);
        this.spinEdit.addSpinListener(new IntSpinListener(0, 100));
        this.dPnl2.add(this.spinEdit);
        this.dPnl1.add(this.dPnl2);
        container.add((Component)this.dPnl1, "Center");
        this.dB1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                int n = 0;
                String string = "";
                try {
                    String string2 = CribbageScoreDlg.this.textFld.getText().trim();
                    n = "".equals(string2) ? 0 : Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    string = CribbageScoreDlg.S_INVALID;
                }
                if (bl) {
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > CribbageScoreDlg.this.maxPoints) {
                        bl = false;
                        string = CribbageScoreDlg.S_TOOMANY;
                    } else {
                        CribbageScoreDlg.this.retPoints = n;
                    }
                }
                if (bl) {
                    CribbageScoreDlg.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(null, string, CribbageScoreDlg.S_MSGTIT, 0, CribbageScoreDlg.this.mbStopImg);
                }
            }
        });
        this.dPnl3.add(this.dB1);
        container.add((Component)this.dPnl3, "South");
    }

    public int getPoints() {
        return this.retPoints;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = Utilities.createTestFrame("Cribbage Score Test", 200, 130);
        CribbageException cribbageException = new CribbageException();
        Image image = Utilities.loadImage(cribbageException, jFrame.getToolkit(), "images/", "hand.gif");
        ImageIcon imageIcon = new ImageIcon(image);
        int n = (int)(Math.random() * 20.0) + 5;
        boolean bl = false;
        if (stringArray.length > 0) {
            if (stringArray[0].equalsIgnoreCase("crib")) {
                bl = true;
            } else if (stringArray[0].equalsIgnoreCase("random")) {
                bl = (int)(Math.random() * 10.0) > 6;
            }
        }
        CribbageScoreDlg cribbageScoreDlg = new CribbageScoreDlg(jFrame, bl, n, imageIcon);
        cribbageScoreDlg.show();
        System.out.println("Crib score: " + bl + ", max points = " + n);
        System.out.println(" Entered points = " + cribbageScoreDlg.getPoints());
    }
}

