/*
 * Decompiled with CFR 0.152.
 */
package au.com.virturo.guiutils;

import au.com.virturo.guiutils.SpinEvent;
import au.com.virturo.guiutils.SpinListener;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class Spinner
extends JPanel {
    private String ac = null;
    private JComponent component;
    private JScrollBar scroller;

    public Spinner(JComponent jComponent) {
        this.component = jComponent;
        this.scroller = new JScrollBar(1, 1, 0, 0, 2);
        this.scroller.setPreferredSize(new Dimension(this.scroller.getPreferredSize().width, jComponent.getPreferredSize().height));
        this.add(jComponent);
        this.add(this.scroller);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.scroller, gridBagConstraints);
        this.setLayout(gridBagLayout);
    }

    public void addSpinListener(SpinListener spinListener) {
        final SpinListener spinListener2 = spinListener;
        this.scroller.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                switch (adjustmentEvent.getValue()) {
                    case 0: {
                        spinListener2.spinnerSpunUp(new SpinEvent(Spinner.this.scroller, Spinner.this.ac, Spinner.this.component));
                        break;
                    }
                    case 2: {
                        spinListener2.spinnerSpunDown(new SpinEvent(Spinner.this.scroller, Spinner.this.ac, Spinner.this.component));
                    }
                }
                adjustmentEvent.getAdjustable().setValue(1);
            }
        });
    }

    public void setToolTipText(String string) {
        this.component.setToolTipText(string);
        this.scroller.setToolTipText(string);
    }

    public void setActionCommand(String string) {
        this.ac = string;
    }

    public JComponent getComponent() {
        return this.component;
    }
}

