/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.cards;

import com.slackandassociates.cards.BlankCard;
import com.slackandassociates.cards.Card;
import com.slackandassociates.cards.CardEnum;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CardDeck
implements Serializable {
    public static final int JC_ONE_DECK = 1;
    public static final int JC_TWO_DECK = 2;
    public static final int JC_THREE_DECK = 3;
    public static final int JC_FOUR_DECK = 4;
    public static final int JC_FIVE_DECK = 5;
    public static final int JC_SIX_DECK = 6;
    public static final int JC_SEVEN_DECK = 7;
    private int nextCard;
    private int lastCard;
    private int numDecks;
    private CardEnum[] cards;
    private boolean shuffled;
    private Class cardCls;
    private transient Constructor cardCons = null;
    static /* synthetic */ Class class$com$slackandassociates$cards$CardEnum;

    public CardDeck(CardEnum[] cardEnumArray, Class clazz) {
        this(1, cardEnumArray, clazz);
    }

    public CardDeck(int n, CardEnum[] cardEnumArray, Class clazz) {
        this(n, cardEnumArray, clazz, null);
    }

    public CardDeck(int n, CardEnum[] cardEnumArray, Class clazz, CardEnum[] cardEnumArray2) {
        int n2;
        int n3 = 0;
        this.cardCls = clazz;
        this.numDecks = n;
        if (this.numDecks < 1 || this.numDecks > 7) {
            this.numDecks = 1;
        }
        this.lastCard = cardEnumArray.length * this.numDecks;
        if (cardEnumArray2 != null) {
            this.lastCard += cardEnumArray2.length;
        }
        this.nextCard = 0;
        this.shuffled = false;
        this.cards = new CardEnum[this.lastCard];
        for (n2 = 0; n2 < this.numDecks; ++n2) {
            for (int i = 0; i < cardEnumArray.length; ++i) {
                this.cards[n3++] = cardEnumArray[i];
            }
        }
        if (cardEnumArray2 != null) {
            for (n2 = 0; n2 < cardEnumArray2.length; ++n2) {
                this.cards[n3++] = cardEnumArray2[n2];
            }
        }
    }

    private Card createNewCard(CardEnum cardEnum) {
        try {
            Object[] objectArray;
            if (this.cardCons == null) {
                objectArray = new Class[]{class$com$slackandassociates$cards$CardEnum == null ? (class$com$slackandassociates$cards$CardEnum = CardDeck.class$("com.slackandassociates.cards.CardEnum")) : class$com$slackandassociates$cards$CardEnum};
                this.cardCons = this.cardCls.getConstructor((Class<?>[])objectArray);
            }
            objectArray = new Object[]{cardEnum};
            return (Card)this.cardCons.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("CardDeck: not a valid card class (missing constructor(CardEnum)).  " + noSuchMethodException);
            return new BlankCard();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("CardDeck: could not create card requested.  " + instantiationException);
            return new BlankCard();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("CardDeck: do not have permission to create new card.  " + illegalAccessException);
            return new BlankCard();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("CardDeck: could not create new card.  " + invocationTargetException);
            return new BlankCard();
        }
    }

    public void shuffle() {
        this.nextCard = 0;
        this.shuffled = true;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < this.lastCard; ++j) {
                int n = (int)Math.floor(Math.random() * (double)this.lastCard);
                CardEnum cardEnum = this.cards[j];
                this.cards[j] = this.cards[n];
                this.cards[n] = cardEnum;
            }
        }
    }

    public boolean isShuffled() {
        return this.shuffled;
    }

    public Card getNextCard(boolean bl) {
        if (this.hasMoreCards()) {
            CardEnum cardEnum = this.cards[this.nextCard];
            if (!bl) {
                ++this.nextCard;
            }
            return this.createNewCard(cardEnum);
        }
        return null;
    }

    public Card getNextCard() {
        return this.getNextCard(false);
    }

    public boolean hasMoreCards() {
        return this.nextCard < this.lastCard;
    }

    public int getNumberOfDecks() {
        return this.numDecks;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int currentCard = 0;

            public boolean hasNext() {
                return this.currentCard < CardDeck.this.lastCard;
            }

            public Object next() {
                if (this.hasNext()) {
                    return CardDeck.this.createNewCard(CardDeck.this.cards[this.currentCard++]);
                }
                throw new NoSuchElementException("No more cards in deck.");
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return "CardDeck: (Decks-" + this.numDecks + ", Number of Cards-" + this.lastCard + ", CurrentCard-" + this.nextCard + ")";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

