/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.cards;

import com.slackandassociates.cards.BlankCard;
import com.slackandassociates.cards.BlankCardEnum;
import com.slackandassociates.cards.Card;
import com.slackandassociates.cards.CardEnum;
import java.io.Serializable;

public class CardHand
implements Serializable {
    public static final int CH_DEF_NUM_CARDS = 5;
    public static final int CH_MIN_NUM_CARDS = 1;
    public static final Card EMPTY_CARD = new BlankCard();
    private Card[] cards;
    private int maxCards = 0;
    private int numCards;
    private boolean handSorted;
    private int compMode = 1;

    public CardHand() {
        this(5);
    }

    public CardHand(int n) {
        this(n, true);
    }

    public CardHand(boolean bl) {
        this(5, bl);
    }

    public CardHand(int n, boolean bl) {
        this.maxCards = n < 1 ? 1 : n;
        this.handSorted = bl;
        this.cards = new Card[this.maxCards];
        this.removeAll();
    }

    private void sortHand() {
        if (this.numCards > 1) {
            for (int i = 0; i < this.maxCards - 1; ++i) {
                for (int j = i + 1; j < this.maxCards; ++j) {
                    CardEnum cardEnum = this.cards[i].getCardValue();
                    if (this.cards[i].compareTo(this.cards[j]) >= 0 && cardEnum != BlankCardEnum.NO_CARD) continue;
                    Card card = this.cards[i];
                    this.cards[i] = this.cards[j];
                    this.cards[j] = card;
                }
            }
        }
    }

    public boolean add(Card card) {
        boolean bl = false;
        if (this.numCards != this.maxCards && card != null) {
            for (int i = 0; i < this.maxCards; ++i) {
                if (this.cards[i] != EMPTY_CARD) continue;
                ++this.numCards;
                this.cards[i] = card;
                if (this.handSorted) {
                    this.cards[i].setCompMode(this.compMode);
                }
                bl = true;
                break;
            }
        }
        if (bl && this.handSorted) {
            this.sortHand();
        }
        return bl;
    }

    public Card remove(int n) {
        if (n < 0 || n >= this.maxCards) {
            return null;
        }
        Card card = this.cards[n];
        this.cards[n] = EMPTY_CARD;
        --this.numCards;
        return card;
    }

    public void removeAll() {
        this.numCards = 0;
        for (int i = 0; i < this.maxCards; ++i) {
            this.cards[i] = EMPTY_CARD;
        }
    }

    public void compressHand() {
        int n;
        Card[] cardArray = new Card[this.maxCards];
        int n2 = 0;
        for (n = 0; n < this.maxCards; ++n) {
            cardArray[n] = EMPTY_CARD;
        }
        for (n = 0; n < this.maxCards; ++n) {
            if (this.cards[n] == EMPTY_CARD) continue;
            cardArray[n2++] = this.cards[n];
        }
        for (n = 0; n < this.maxCards; ++n) {
            this.cards[n] = cardArray[n];
        }
    }

    public Card cardAt(int n) {
        if (n < 0 || n >= this.maxCards) {
            return null;
        }
        return this.cards[n];
    }

    public Card replace(Card card, int n) {
        Card card2 = this.remove(n);
        if (card == null) {
            card2 = null;
        }
        if (card2 != null) {
            if (this.handSorted) {
                this.add(card);
            } else {
                this.cards[n] = card;
            }
        }
        return card2;
    }

    public boolean contains(Card card) {
        boolean bl = false;
        if (card != null) {
            for (int i = 0; !(i >= this.maxCards || this.cards[i] != EMPTY_CARD && (bl = ((Object)this.cards[i]).equals(card))); ++i) {
            }
        }
        return bl;
    }

    public int getCardCount() {
        return this.numCards;
    }

    public Card getFirstAvailableCard() {
        Card card = null;
        if (this.numCards > 0) {
            for (int i = 0; i < this.maxCards; ++i) {
                if (this.cards[i] == EMPTY_CARD) continue;
                card = this.remove(i);
                break;
            }
        }
        return card;
    }

    public int getMaximumCardCount() {
        return this.maxCards;
    }

    public boolean isSorted() {
        return this.handSorted;
    }

    public int getCompMode() {
        return this.compMode;
    }

    public void setCompMode(int n) {
        this.compMode = n;
        if (this.handSorted) {
            for (int i = 0; i < this.maxCards; ++i) {
                if (this.cards[i] == EMPTY_CARD) continue;
                this.cards[i].setCompMode(this.compMode);
            }
            this.sortHand();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("CardHand: [");
        for (int i = 0; i < this.maxCards; ++i) {
            stringBuffer.append("(" + i);
            stringBuffer.append(") ");
            if (this.cards[i] != EMPTY_CARD) {
                stringBuffer.append(((Object)this.cards[i]).toString());
            } else {
                stringBuffer.append("Empty");
            }
            if (i >= this.maxCards - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

