/**
 * Event class that is tossed by the cribbage game to itself to indicate
 * that it's either the players move or the computers move or for them to
 * score their hands. <br><br>
 * <b>Changes:</b>
 * <ul>
 * <li> 2001-09-19 - Initial Release.
 * </ul>
 * @author Michael G. Slack
 * @author slack@attglobal.net
 * @created 2001-09-19
 * @version 2001-09-19 Version 1.00
*/
public class CribPlayEvent
    extends java.util.EventObject
{
    // public statics
    /** No event constant. */
    public static final int CPE_NO_EVENT = 0;

    /** It is now time for the player to play. */
    public static final int CPE_PLAYERS_PLAY = 1;

    /** It is now time for the computer to play. */
    public static final int CPE_COMPUTERS_PLAY = 2;

    /** The hand is over, score the hands and the crib. */
    public static final int CPE_SCORE_HAND = 3;

    // private references
    /** Holder for event type. */
    private int event = CPE_NO_EVENT;

    // ---------------------- Constructors --------------------------------

    /** Constructor to create an cribbage game play event.
     * @param source Object that initiated the event.
     * @param event An int representing the event that occured.
    */
    public CribPlayEvent(Object source, int event)
    {
        super(source);

        // check validity of event...
        if ((event >= CPE_PLAYERS_PLAY) && (event <= CPE_SCORE_HAND))
            this.event = event; // otherwise, leave as no event
    }

    // ------------------------- Public Methods ----------------------------

    /** Method used to return the event generated.
     * @return A int representing the event generated.
    */
    public int getEvent()
    {
        return event;
    }

    /** Method to return the value of the event as a string to the caller.
     * @return A string representation of the event.
    */
    public String toString()
    {
        String sRet = "CribPlayEvent [";

        switch (event) {
            case CPE_NO_EVENT:
                sRet += "No event";
                break;
            case CPE_PLAYERS_PLAY:
                sRet += "Players play";
                break;
            case CPE_COMPUTERS_PLAY:
                sRet += "Computers play";
                break;
            case CPE_SCORE_HAND: 
                sRet += "Score hand";
                break;
            default:
                sRet += "Unknown (" + event + ")";
                break;
        }

        sRet += "]";

        return sRet;
    }
}
