/*
 * Decompiled with CFR 0.152.
 */
package org.escoba;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.escoba.Card;
import org.escoba.Game;
import org.escoba.Play;
import org.escoba.Player;
import org.escoba.ui.Util;

public class BotPlayer
extends Player {
    private Game game;

    public BotPlayer(Game game) {
        super("Computadora", false);
        this.game = game;
    }

    private Game getGame() {
        return this.game;
    }

    public void doAI() {
        final BotPlayer botPlayer = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (BotPlayer.this.game.isGameStarted()) {
                    Play play;
                    Thread.yield();
                    if (BotPlayer.this.game.isDropedCard() && (play = botPlayer.pickUpCards(BotPlayer.this.game.getDropedCard())) != null) {
                        BotPlayer.this.doPickUpCards(play);
                    }
                    if ((play = botPlayer.generarJugadas()) == null) {
                        botPlayer.dropCard();
                    } else {
                        botPlayer.doPlay(play);
                    }
                }
            }
        }).start();
    }

    private Play pickUpCards(Card card) {
        ArrayList<Card> arrayList = new ArrayList<Card>(this.game.getTable().getCards());
        Collections.sort(arrayList);
        arrayList.remove(card);
        ArrayList<Play> arrayList2 = new ArrayList<Play>();
        Play play = new Play();
        play.add(card);
        int n = card.getNumber();
        this.searchGames(arrayList, 0, n, play, arrayList2);
        return this.choosePlay(arrayList2);
    }

    private void doPickUpCards(Play play) {
        for (int i = 0; i < play.size(); ++i) {
            this.getGame().getTable().setSelected((Card)play.get(i), true);
            Util.playClick();
            this.sleep();
        }
        this.game.pickUpCards();
    }

    private void doPlay(Play play) {
        this.getHand().setSelected((Card)play.get(0), true);
        Util.playClick();
        this.sleep();
        for (int i = 1; i < play.size(); ++i) {
            this.getGame().getTable().setSelected((Card)play.get(i), true);
            Util.playClick();
            this.sleep();
        }
        this.game.takeCards();
    }

    private void dropCard() {
        int n = 0;
        int n2 = 999;
        for (int i = 0; i < 3; ++i) {
            Card card = this.getHand().getCard(i);
            if (card == null || card.getNumber() >= n2) continue;
            n = i;
            n2 = card.getNumber();
        }
        this.getHand().setSelected(n, true);
        Util.playClick();
        this.sleep();
        this.getGame().dropCard();
    }

    private void sleep() {
        this.game.notifyObservers();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void dealtCard(Card card) {
        card.setReverse(true);
        super.dealtCard(card);
    }

    private Play generarJugadas() {
        ArrayList<Card> arrayList = new ArrayList<Card>(this.game.getTable().getCards());
        Collections.sort(arrayList);
        ArrayList<Play> arrayList2 = new ArrayList<Play>();
        for (Card card : this.getHand()) {
            Play play = new Play();
            play.add(card);
            int n = card.getNumber();
            this.searchGames(arrayList, 0, n, play, arrayList2);
        }
        return this.choosePlay(arrayList2);
    }

    private Play choosePlay(List<Play> list) {
        Play play = null;
        int n = -1;
        for (Play play2 : list) {
            int n2 = play2.revalue();
            if (n2 <= n) continue;
            n = n2;
            play = play2;
        }
        return play;
    }

    private void searchGames(List<Card> list, int n, int n2, Play play, List<Play> list2) {
        if (n < list.size()) {
            if (n2 + list.get(n).getNumber() == 15) {
                while (n < list.size() && n2 + list.get(n).getNumber() == 15) {
                    Play play2 = new Play();
                    play2.addAll(play);
                    play2.add(list.get(n));
                    if (list.size() == play2.size() - 1) {
                        play2.setEscoba(true);
                    }
                    list2.add(play2);
                    ++n;
                }
            } else if (n2 + list.get(n).getNumber() < 15) {
                play.add(list.get(n));
                this.searchGames(list, n + 1, n2 + list.get(n).getNumber(), play, list2);
                play.remove(play.size() - 1);
                this.searchGames(list, n + 1, n2, play, list2);
            }
        }
    }
}

