/*
 * Decompiled with CFR 0.152.
 */
package org.escoba;

import java.text.MessageFormat;

public class Card
implements Comparable<Card> {
    private int palo;
    private int number;
    private boolean selected;
    private boolean reverse;
    public static final int PALO_BASTO = 0;
    public static final int PALO_COPA = 1;
    public static final int PALO_ESPADA = 2;
    public static final int PALO_ORO = 3;
    public static final String[] PALOS = new String[]{"Basto", "Copa", "Espada", "Oro"};
    public static final int[] VALUES = new int[]{1, 2, 3, 4, 5, 6, 7, 10, 11, 12};

    public Card(int n, int n2) {
        this.palo = n;
        this.number = n2;
        this.selected = false;
        this.reverse = false;
    }

    public int getPalo() {
        return this.palo;
    }

    public void setPalo(int n) {
        this.palo = n;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public boolean isGold() {
        return this.getPalo() == 3;
    }

    public String toString() {
        return MessageFormat.format("{1}-{0}", PALOS[this.palo], VALUES[this.number - 1]);
    }

    @Override
    public int compareTo(Card card) {
        if (this.getNumber() < card.getNumber()) {
            return -1;
        }
        if (this.getNumber() > card.getNumber()) {
            return 1;
        }
        if (this.getPalo() < card.getPalo()) {
            return -1;
        }
        if (this.getPalo() > card.getPalo()) {
            return 1;
        }
        return 0;
    }

    public int getValue() {
        int n = 1;
        if (this.isSeven()) {
            n += 7;
        }
        if (this.isGold()) {
            n += 5;
        }
        if (this.getNumber() == 6) {
            n += 3;
        }
        if (this.getNumber() == 1) {
            n += 2;
        }
        if (this.isSeven() && this.isGold()) {
            n += 30;
        }
        return n;
    }

    public boolean isSeven() {
        return this.getNumber() == 7;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Card)) {
            return false;
        }
        return this.getPalo() == ((Card)object).getPalo() && this.getNumber() == ((Card)object).getNumber();
    }
}

