/*
 * Decompiled with CFR 0.152.
 */
package org.escoba;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.escoba.Card;
import org.escoba.Play;

public class CardList
implements Iterable<Card> {
    private int maxSize;
    private Play cards;
    private Random r = new Random();

    public CardList(int n) {
        this.maxSize = n;
        this.cards = new Play();
    }

    protected Play getCards() {
        return this.cards;
    }

    public Card getCard(int n) {
        if (n < 0 || n >= this.getCards().size()) {
            return null;
        }
        return (Card)this.getCards().get(n);
    }

    public void add(Card card) {
        this.getCards().add(card);
    }

    public void addAll(List<Card> list) {
        this.getCards().addAll(list);
    }

    public Card remove(int n) {
        return (Card)this.getCards().remove(n);
    }

    public void removeAllCards() {
        this.getCards().clear();
    }

    public void removeSelectedCards() {
        Iterator<Card> iterator = this.iterator();
        while (iterator.hasNext()) {
            Card card = iterator.next();
            if (!card.isSelected()) continue;
            card.setSelected(false);
            iterator.remove();
        }
    }

    public Card randomRemove() {
        return this.remove(this.r.nextInt(this.size()));
    }

    public boolean isEmpty() {
        return this.getCards().isEmpty();
    }

    public int size() {
        return this.getCards().size();
    }

    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public Iterator<Card> iterator() {
        return this.getCards().iterator();
    }

    public void reset() {
        this.getCards().clear();
    }

    public Play selectedCards() {
        Play play = new Play();
        for (Card card : this.getCards()) {
            if (!card.isSelected()) continue;
            play.add(card);
        }
        return play;
    }

    public int selectedCount() {
        int n = 0;
        for (Card card : this.getCards()) {
            if (!card.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public void setSelected(int n, boolean bl) {
        Card card = this.getCard(n);
        if (card != null) {
            card.setSelected(bl);
            card.setReverse(false);
        }
    }

    public boolean isSelected(int n) {
        Card card = this.getCard(n);
        if (card != null) {
            return card.isSelected();
        }
        return false;
    }

    public boolean isReverse(int n) {
        Card card = this.getCard(n);
        if (card != null) {
            return card.isReverse();
        }
        return false;
    }

    public void unselectCards() {
        for (Card card : this.getCards()) {
            if (!card.isSelected()) continue;
            card.setSelected(false);
        }
    }

    public void setSelected(Card card, boolean bl) {
        for (int i = 0; i < this.cards.size(); ++i) {
            if (this.cards.get(i) != card) continue;
            this.setSelected(i, bl);
            break;
        }
    }
}

