/*
 * Decompiled with CFR 0.152.
 */
package org.escoba;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.escoba.BotPlayer;
import org.escoba.Card;
import org.escoba.CardList;
import org.escoba.HumanPlayer;
import org.escoba.Observable;
import org.escoba.Play;
import org.escoba.Player;
import org.escoba.Spanish40Deck;
import org.escoba.ui.Util;

public class Game
extends Observable {
    private CardList deck;
    private CardList table;
    private Player[] players;
    private int currentPlayer;
    private int lastPlayerTaken = 0;
    private Card dropedCard;
    private boolean handTurn = true;
    private boolean gameStarted = false;
    private int baraja = 0;
    private List<String> messages;
    private Random random = new Random();

    public Game() {
        this.messages = new ArrayList<String>();
        this.players = new Player[2];
        this.currentPlayer = this.random.nextInt(this.players.length);
        this.deck = new Spanish40Deck();
        this.table = new CardList(40);
        this.players[0] = new HumanPlayer();
        this.players[1] = new BotPlayer(this);
        this.dropedCard = null;
        this.handTurn = true;
        this.baraja = 0;
    }

    public Player getCurrentPlayer() {
        return this.players[this.currentPlayer];
    }

    public Player getLastTakenPlayer() {
        return this.players[this.lastPlayerTaken];
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public CardList getDeck() {
        return this.deck;
    }

    public CardList getTable() {
        return this.table;
    }

    public Player[] getPlayers() {
        return this.players;
    }

    public Card getDropedCard() {
        return this.dropedCard;
    }

    public boolean isDropedCard() {
        return this.dropedCard != null;
    }

    private void passPlayer() {
        ++this.currentPlayer;
        this.currentPlayer %= this.players.length;
    }

    public void startGame() {
        this.passPlayer();
        this.dropedCard = null;
        this.deck.reset();
        this.table.reset();
        for (Player player : this.players) {
            player.reset();
        }
        this.notifyObservers();
        this.table.add(this.deck.randomRemove());
        this.notifyObservers();
        this.table.add(this.deck.randomRemove());
        this.notifyObservers();
        this.table.add(this.deck.randomRemove());
        this.notifyObservers();
        this.table.add(this.deck.randomRemove());
        this.notifyObservers();
        this.addMessage("<b>Comienza el juego</b>", new Object[0]);
        this.dealtCards();
        this.showTurn();
        this.checkEscobaReal();
        this.gameStarted = true;
        this.notifyObservers();
        if (!this.getCurrentPlayer().isHuman()) {
            ((BotPlayer)this.getCurrentPlayer()).doAI();
        }
    }

    private void checkEscobaReal() {
        Player player = this.getCurrentPlayer();
        if (this.table.getCards().sumCards() == 15) {
            Play play = new Play();
            play.addAll(this.table.getCards());
            for (Card card : play) {
                card.setSelected(true);
            }
            this.addMessage("{0} hizo Escoba Real con <i>{1}</i>", this.getCurrentPlayer().toHtmlString(), play.toString());
            Util.playSwish();
            this.table.removeSelectedCards();
            player.getGameStats().incEscobasCount();
            player.getGameStats().incEscobasCount();
            player.takeCards(play);
        }
        this.notifyObservers();
    }

    private void dealtCards() {
        for (Player player : this.players) {
            for (int i = 0; i < 3; ++i) {
                player.dealtCard(this.deck.randomRemove());
                this.notifyObservers();
            }
        }
        if (this.deck.size() == 0) {
            this.addMessage("<i>no quedan cartas en el mazo</i>", new Object[0]);
        } else {
            this.addMessage("<i>quedan {0} cartas en el mazo</i>", this.deck.size());
        }
        this.notifyObservers();
    }

    public boolean isReadyToTake() {
        if (!this.isGameStarted()) {
            return false;
        }
        Player player = this.getCurrentPlayer();
        Card card = player.getHand().getSelectedCard();
        if (card == null) {
            return false;
        }
        Play play = this.table.selectedCards();
        play.add(card);
        return play.sumCards() == 15;
    }

    public void takeCards() {
        if (!this.isGameStarted()) {
            return;
        }
        Player player = this.getCurrentPlayer();
        Card card = player.getHand().getSelectedCard();
        if (card == null) {
            return;
        }
        Play play = this.table.selectedCards();
        play.add(card);
        if (play.sumCards() == 15) {
            this.addMessage("{0} levant\u00f3 <i>{1}</i>", this.getCurrentPlayer().toHtmlString(), play.toString());
            player.getHand().removeSelectedCards();
            this.table.removeSelectedCards();
            if (this.table.isEmpty()) {
                play.setEscoba(true);
                this.addMessage(" <b>\u00a1haciendo escoba!</b>", new Object[0]);
            }
            player.takeCards(play);
        }
        this.lastPlayerTaken = this.currentPlayer;
        this.nextTurn();
        this.notifyObservers();
    }

    public void pickUpCards() {
        if (!this.isGameStarted()) {
            return;
        }
        Player player = this.getCurrentPlayer();
        Play play = this.table.selectedCards();
        if (play.sumCards() == 15) {
            this.addMessage("<b>{0} sopl\u00f3 las cartas <i>{1}</i></b>", this.getCurrentPlayer().toHtmlString(), play.toString());
            Util.playSwish();
            this.table.removeSelectedCards();
            player.takeCards(play);
        }
        this.notifyObservers();
    }

    public void dropCard() {
        if (!this.isGameStarted()) {
            return;
        }
        Player player = this.getCurrentPlayer();
        Card card = player.getHand().getSelectedCard();
        if (card == null) {
            return;
        }
        player.getHand().removeSelectedCards();
        this.table.unselectCards();
        this.table.add(card);
        this.addMessage("{0} tir\u00f3 <i>{1}</i><br>", this.getCurrentPlayer().toHtmlString(), card.toString());
        this.nextTurn(card);
        this.notifyObservers();
    }

    private void nextTurn() {
        this.nextTurn(null);
    }

    private void nextTurn(Card card) {
        this.dropedCard = card;
        if (!this.isGameStarted()) {
            return;
        }
        this.passPlayer();
        if (this.getCurrentPlayer().getHand().isEmpty()) {
            if (this.getDeck().isEmpty()) {
                this.endGame();
                return;
            }
            if (!this.isHandTurn()) {
                this.passPlayer();
            }
            this.dealtCards();
        }
        this.showTurn();
        if (!this.getCurrentPlayer().isHuman()) {
            ((BotPlayer)this.getCurrentPlayer()).doAI();
        }
        Util.playPop();
        this.notifyObservers();
    }

    private void showTurn() {
        this.addMessage("Es el turno de {0}<br>", this.getCurrentPlayer().toHtmlString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(String string, Object ... objectArray) {
        List<String> list = this.messages;
        synchronized (list) {
            this.messages.add(MessageFormat.format(string, objectArray));
        }
    }

    public boolean hasMessages() {
        return this.messages.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMessages() {
        String[] stringArray;
        List<String> list = this.messages;
        synchronized (list) {
            stringArray = this.messages.toArray(new String[0]);
            this.messages.clear();
        }
        return stringArray;
    }

    private void takeRemaingCards() {
        if (this.table.getCards().size() > 0) {
            this.addMessage("Las cartas sobrantes (<i>{0}</i>) son para {1}<br>", this.table.getCards().toString(), this.getLastTakenPlayer().toHtmlString());
            Player player = this.getLastTakenPlayer();
            player.takeCards(this.table.getCards());
            this.table.removeAllCards();
        }
    }

    private void endGame() {
        this.takeRemaingCards();
        this.check70s();
        this.gameStarted = false;
        this.addMessage("<b>Fin del juego.</b>", new Object[0]);
        this.updateStats();
        this.showStats();
        this.players[0].notifyObservers();
        this.players[1].notifyObservers();
        Util.playGong();
        this.notifyObservers();
    }

    private void check70s() {
        int n = this.players[0].calculate70s();
        int n2 = this.players[1].calculate70s();
        if (n > -1 && n > n2) {
            this.players[0].getGameStats().setSetentas(true);
        } else if (n2 > -1 && n2 > n) {
            this.players[1].getGameStats().setSetentas(true);
        }
    }

    private void updateStats() {
        if (this.players[0].getGameStats().getCardsCount() > this.players[1].getGameStats().getCardsCount()) {
            this.players[0].getGameStats().incTotalPoints(1);
            this.players[0].getGameStats().setCards(true);
        }
        if (this.players[1].getGameStats().getCardsCount() > this.players[0].getGameStats().getCardsCount()) {
            this.players[1].getGameStats().incTotalPoints(1);
            this.players[1].getGameStats().setCards(true);
        }
        if (this.players[0].getGameStats().getGoldsCount() > this.players[1].getGameStats().getGoldsCount()) {
            this.players[0].getGameStats().incTotalPoints(1);
            this.players[0].getGameStats().setGolds(true);
        }
        if (this.players[1].getGameStats().getGoldsCount() > this.players[0].getGameStats().getGoldsCount()) {
            this.players[1].getGameStats().incTotalPoints(1);
            this.players[1].getGameStats().setGolds(true);
        }
        if (this.players[0].getGameStats().isGold7()) {
            this.players[0].getGameStats().incTotalPoints(1);
        }
        if (this.players[1].getGameStats().isGold7()) {
            this.players[1].getGameStats().incTotalPoints(1);
        }
        if (this.players[0].getGameStats().isSetentas()) {
            this.players[0].getGameStats().incTotalPoints(1);
        }
        if (this.players[1].getGameStats().isSetentas()) {
            this.players[1].getGameStats().incTotalPoints(1);
        }
        this.players[0].incPuntos(this.players[0].getGameStats().getTotalPoints());
        this.players[1].incPuntos(this.players[1].getGameStats().getTotalPoints());
        this.players[0].incPuntos(this.players[0].getGameStats().getEscobasCount());
        this.players[1].incPuntos(this.players[1].getGameStats().getEscobasCount());
    }

    private void showStats() {
        this.showStats(this.players[0]);
        this.showStats(this.players[1]);
    }

    private void showStats(Player player) {
        if (player.getGameStats().isCards()) {
            this.addMessage("{0} gana el punto de <i>cartas</i><br>", player.toHtmlString());
        }
        if (player.getGameStats().isGolds()) {
            this.addMessage("{0} gana el punto de <i>oros</i><br>", player.toHtmlString());
        }
        if (player.getGameStats().isGold7()) {
            this.addMessage("{0} gana el punto del <i>7 de velos</i><br>", player.toHtmlString());
        }
        if (player.getGameStats().isSetentas()) {
            this.addMessage("{0} gana el punto de las <i>setentas</i><br>", player.toHtmlString());
        }
        if (player.getGameStats().getEscobasCount() > 0) {
            this.addMessage("{0} suma {1} <i>escobas</i><br>", player.toHtmlString(), player.getGameStats().getEscobasCount());
        }
        this.addMessage("<b>{0} suma {1} puntos en esta mano y acumula {2} puntos</b><br>", player.toHtmlString(), player.getGameStats().getTotalPoints() + player.getGameStats().getEscobasCount(), player.getPoints());
    }

    public boolean isHandTurn() {
        return this.handTurn;
    }

    public void setHandTurn(boolean bl) {
        this.handTurn = bl;
    }

    public int getBaraja() {
        return this.baraja;
    }

    public void setBaraja(int n) {
        this.baraja = n;
    }
}

