/*
 * Decompiled with CFR 0.152.
 */
package org.escoba;

import java.text.MessageFormat;
import org.escoba.Card;
import org.escoba.CardList;
import org.escoba.Hand;
import org.escoba.Observable;
import org.escoba.Play;
import org.escoba.Stats;
import org.escoba.ui.Util;

public abstract class Player
extends Observable {
    private String name;
    private Hand hand;
    private CardList takedCards;
    private boolean human;
    private Stats gameStats;
    private Stats totalStats;
    private int points;
    private static final int[] SETENTA_VALUES = new int[]{16, 6, 9, 12, 15, 18, 21, 0, 0, 0};

    public Player(String string, boolean bl) {
        this.name = string;
        this.hand = new Hand(3);
        this.takedCards = new CardList(40);
        this.human = bl;
        this.gameStats = new Stats();
        this.points = 0;
    }

    public Hand getHand() {
        return this.hand;
    }

    public CardList getTakedCards() {
        return this.takedCards;
    }

    public void setName(String string) {
        this.name = string;
        this.notifyObservers();
    }

    public String getName() {
        return this.name;
    }

    public boolean isHuman() {
        return this.human;
    }

    public void dealtCard(Card card) {
        this.hand.add(card);
        this.notifyObservers();
    }

    public void takeCards(Play play) {
        for (Card card : play) {
            this.getTakedCards().add(card);
            this.updateStats(card);
        }
        if (play.isEscoba()) {
            this.gameStats.incEscobasCount();
            Util.playWood();
        }
        this.notifyObservers();
    }

    private void updateStats(Card card) {
        this.gameStats.incCardsCount();
        if (card.isGold()) {
            this.gameStats.incGoldsCount();
        }
        if (card.isGold() && card.isSeven()) {
            this.gameStats.setGold7(true);
        }
    }

    public void reset() {
        this.hand.reset();
        this.takedCards.reset();
        this.gameStats.reset();
        this.notifyObservers();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isEmpty() {
        return this.getHand().size() == 0;
    }

    public Stats getGameStats() {
        return this.gameStats;
    }

    public Stats getTotalStats() {
        return this.totalStats;
    }

    public int calculate70s() {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = -1;
        }
        for (Card card : this.takedCards) {
            if (nArray[card.getPalo()] >= SETENTA_VALUES[card.getNumber() - 1]) continue;
            nArray[card.getPalo()] = SETENTA_VALUES[card.getNumber() - 1];
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (nArray[i] == -1) {
                return -1;
            }
            n += nArray[i];
        }
        return n;
    }

    public void incPuntos(int n) {
        this.points += n;
    }

    public int getPoints() {
        return this.points;
    }

    public Object toHtmlString() {
        return MessageFormat.format("<span style=\"color:{1}\"><b>{0}</b></span>", this.getName(), this.isHuman() ? "#0000ff" : "#ff0000");
    }
}

