/*
 * Decompiled with CFR 0.152.
 */
package org.escoba.ui;

import com.jhlabs.image.OpacityFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.escoba.Card;
import org.escoba.CardList;
import org.escoba.Game;
import org.escoba.ui.Util;

public class CardComponent
extends JComponent {
    private static final long serialVersionUID = -7476806880037837683L;
    private static final int WIDTH = 72;
    private static final int HEIGHT = 96;
    private static Image[] cardsImage = null;
    private static Image reverseImage = null;
    private static Image shadowImage = null;
    private static OpacityFilter opacityFilter = new OpacityFilter(70);
    private Game game;
    private CardList deck;
    private int index;
    private boolean hasFocus = false;

    public CardComponent(Game game, CardList cardList, int n) {
        this.game = game;
        this.deck = cardList;
        this.index = n;
        this.setPreferredSize(new Dimension(74, 100));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CardComponent.this.hasFocus = true;
                CardComponent.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CardComponent.this.hasFocus = false;
                CardComponent.this.repaint();
            }
        });
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Card card = this.deck.getCard(this.index);
        if (card == null) {
            return;
        }
        Insets insets = this.getInsets();
        int n = (card.getNumber() - 1) * 72;
        int n2 = card.getPalo() * 96;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.isReverse()) {
            graphics2D.drawImage(this.getReverseImage(), insets.left, insets.top, 72, 96, 0, 0, 72, 96, null);
        } else {
            if (this.hasFocus && this.game.isGameStarted() && this.game.getCurrentPlayer().isHuman()) {
                graphics2D.drawImage(shadowImage, insets.left + 2, insets.top + 2, 76, 100, 0, 0, 74, 98, null);
                graphics2D.drawImage(this.getCardsImage(), insets.left, insets.top, 72, 96, n, n2, n + 72, n2 + 96, null);
            } else {
                graphics2D.drawImage(this.getCardsImage(), insets.left + 2, insets.top + 2, 74, 98, n, n2, n + 72, n2 + 96, null);
            }
            if (this.isSelected()) {
                graphics2D.setColor(Color.RED);
                graphics2D.setStroke(new BasicStroke(5.0f));
                graphics2D.drawRect(0, 0, 71, 95);
            }
        }
        graphics2D.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage makeShadow() {
        BufferedImage bufferedImage = new BufferedImage(74, 98, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRoundRect(0, 0, 74, 98, 20, 20);
        }
        finally {
            graphics2D.dispose();
        }
        return opacityFilter.filter(bufferedImage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image getCardsImage() {
        if (cardsImage != null) return cardsImage[this.game.getBaraja()];
        Class<CardComponent> clazz = CardComponent.class;
        synchronized (CardComponent.class) {
            if (cardsImage != null) return cardsImage[this.game.getBaraja()];
            cardsImage = new Image[2];
            CardComponent.cardsImage[0] = Util.loadImage("/img/naipes.png");
            CardComponent.cardsImage[1] = Util.loadImage("/img/naipes2.png");
            shadowImage = this.makeShadow();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cardsImage[this.game.getBaraja()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image getReverseImage() {
        if (reverseImage != null) return reverseImage;
        Class<CardComponent> clazz = CardComponent.class;
        synchronized (CardComponent.class) {
            if (reverseImage != null) return reverseImage;
            reverseImage = Util.loadImage("/img/reverso.png");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return reverseImage;
        }
    }

    public boolean isSelected() {
        return this.deck.isSelected(this.index);
    }

    public boolean isReverse() {
        return this.deck.isReverse(this.index);
    }
}

