/*
 * Decompiled with CFR 0.152.
 */
package org.escoba.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.escoba.Game;
import org.escoba.Observable;
import org.escoba.Observer;
import org.escoba.ui.CardComponent;
import org.escoba.ui.OptionsDialog;
import org.escoba.ui.PatternBox;
import org.escoba.ui.PatternPanel;
import org.escoba.ui.PlayerComponent;
import org.escoba.ui.Util;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int WIN_WIDTH = 700;
    private static final int WIN_HEIGHT = 470;
    private Game game;
    private JPanel jContentPane = null;
    private JLabel infoLabel = null;
    private JTextPane notifyArea = null;
    private PatternPanel buttonPanel = null;
    private JButton newGameButton = null;
    private JButton settingsButton = null;
    private JButton helpButton = null;
    private JButton infoButton = null;
    private JButton exitButton = null;
    private OptionsDialog optionsDialog = null;
    private final HTMLEditorKit htmlEditorKit = new HTMLEditorKit();

    public MainFrame(final Game game) {
        this.game = game;
        this.game.addObserver(new Observer(){

            @Override
            public void eventNotify(Observable observable) {
                MainFrame.this.getInfoLabel().setText(MessageFormat.format("Mazo: {0}", game.getDeck().size()));
                MainFrame.this.settingsButton.setEnabled(!game.isGameStarted());
                HTMLDocument hTMLDocument = (HTMLDocument)MainFrame.this.getNotifyArea().getStyledDocument();
                for (String string : game.getMessages()) {
                    try {
                        MainFrame.this.htmlEditorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
                        MainFrame.this.getNotifyArea().setCaretPosition(hTMLDocument.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                MainFrame.this.invalidate();
                MainFrame.this.repaint();
            }
        });
        this.initialize();
    }

    private Game getGame() {
        return this.game;
    }

    private void initialize() {
        this.setSize(700, 470);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Escoba de 15");
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setIconImage(Util.loadImage("/img/icono.png"));
        this.bindJavaHelp();
    }

    private void bindJavaHelp() {
        try {
            HelpSet helpSet = new HelpSet(this.getClass().getClassLoader(), ClassLoader.getSystemResource("jhelpset.hs"));
            HelpBroker helpBroker = helpSet.createHelpBroker();
            helpBroker.enableHelpOnButton(this.getHelpButton(), "index", helpSet);
        }
        catch (HelpSetException helpSetException) {
            helpSetException.printStackTrace();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setName("main");
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "North");
            JScrollPane jScrollPane = new JScrollPane(this.getNotifyArea());
            jScrollPane.setPreferredSize(new Dimension(700, 100));
            this.jContentPane.add((Component)jScrollPane, "South");
            PlayerComponent playerComponent = new PlayerComponent(this.getGame(), this.getGame().getPlayers()[0]);
            PlayerComponent playerComponent2 = new PlayerComponent(this.getGame(), this.getGame().getPlayers()[1]);
            PatternPanel patternPanel = new PatternPanel(330, 1200, "/img/patron.jpg");
            for (int i = 0; i < 40; ++i) {
                patternPanel.add(this.createCardComponent(i, playerComponent));
            }
            this.jContentPane.add((Component)new JScrollPane(patternPanel), "Center");
            PatternBox patternBox = new PatternBox(1, "/img/wood2.png");
            patternBox.setPreferredSize(new Dimension(300, 350));
            patternBox.add(playerComponent);
            patternBox.add(playerComponent2);
            this.jContentPane.add((Component)patternBox, "East");
        }
        return this.jContentPane;
    }

    private CardComponent createCardComponent(int n, final PlayerComponent playerComponent) {
        final CardComponent cardComponent = new CardComponent(this.game, this.game.getTable(), n);
        cardComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!MainFrame.this.game.isGameStarted() || !MainFrame.this.game.getCurrentPlayer().isHuman() || mouseEvent.getButton() != 1) {
                    return;
                }
                Util.playTick();
                final MouseEvent mouseEvent2 = mouseEvent;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = cardComponent.getIndex();
                        if (mouseEvent2.getButton() == 1) {
                            MainFrame.this.getGame().getTable().setSelected(n, !MainFrame.this.getGame().getTable().isSelected(n));
                            if (MainFrame.this.getGame().isReadyToTake()) {
                                MainFrame.this.getGame().takeCards();
                                playerComponent.disableButtons();
                            }
                            MainFrame.this.getRootPane().repaint();
                        }
                    }
                });
            }
        });
        return cardComponent;
    }

    private PatternPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new PatternPanel("/img/wood.jpg");
            this.buttonPanel.setLayout(new FlowLayout(0, 20, 2));
            this.buttonPanel.add(this.getNewGameButton());
            this.buttonPanel.add(this.getSettingsButton());
            this.buttonPanel.add(this.getHelpButton());
            this.buttonPanel.add(this.getInfoButton());
            this.buttonPanel.add(this.getExitButton());
        }
        return this.buttonPanel;
    }

    private JButton getNewGameButton() {
        if (this.newGameButton == null) {
            this.newGameButton = Util.createButton("Nuevo", 78, "/img/play.png", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Util.playTick();
                            MainFrame.this.getNotifyArea().setText("");
                            Util.playShuffle();
                            Util.sleep(1000);
                            MainFrame.this.game.startGame();
                            MainFrame.this.repaint();
                        }
                    });
                }
            });
        }
        return this.newGameButton;
    }

    private JButton getSettingsButton() {
        if (this.settingsButton == null) {
            this.settingsButton = Util.createButton("Opciones", 79, "/img/configure.png", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Util.playTick();
                            MainFrame.this.getOptionsDialog().open();
                        }
                    });
                }
            });
        }
        return this.settingsButton;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = Util.createButton("Ayuda", 112, "/img/help-contents.png", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Util.playTick();
                        }
                    });
                }
            });
        }
        return this.helpButton;
    }

    private JButton getInfoButton() {
        if (this.infoButton == null) {
            this.infoButton = Util.createButton("Info", 121, "/img/info.png", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){
                        JDialog dialog = null;

                        private JDialog getDialog() {
                            if (this.dialog == null) {
                                JOptionPane jOptionPane = new JOptionPane();
                                jOptionPane.setMessage(MainFrame.this.getInfoText());
                                jOptionPane.setMessageType(1);
                                JButton jButton = new JButton("Cerrar");
                                jButton.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        dialog.setVisible(false);
                                    }
                                });
                                jOptionPane.setOptions(new Object[]{jButton});
                                this.dialog = jOptionPane.createDialog(null, "Info");
                            }
                            return this.dialog;
                        }

                        @Override
                        public void run() {
                            Util.playTick();
                            this.getDialog().setVisible(true);
                        }
                    });
                }
            });
        }
        return this.infoButton;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = Util.createButton("Salir", 81, "/img/exit.png", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Util.playTick();
                            System.exit(0);
                        }
                    });
                }
            });
        }
        return this.exitButton;
    }

    private JTextPane getNotifyArea() {
        if (this.notifyArea == null) {
            this.notifyArea = new JTextPane();
            this.notifyArea.setEditable(false);
            this.notifyArea.setContentType("text/html");
            this.notifyArea.setBackground(new Color(255, 255, 224));
        }
        return this.notifyArea;
    }

    private JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel();
            this.infoLabel.setFont(this.getContentPane().getFont().deriveFont(1, 12.0f));
            this.infoLabel.setForeground(Color.LIGHT_GRAY);
        }
        return this.infoLabel;
    }

    private String getInfoText() {
        return MessageFormat.format("Escoba de 15\n(C) 2009 Pablo F. Lillia\nVersion: {0}, 21 de septiembre de 2009\nUn juego cl\u00e1sico de naipes espa\u00f1oles, publicado bajo licencia AGPL3.\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU Affero General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU Affero General Public License for more details.\n\nYou should have received a copy of the GNU Affero General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.\n\nhttp://entrellaves.blogspot.com\nemail:gorlok@users.sourceforge.net", this.getVersionInfo());
    }

    private String getVersionInfo() {
        if (MainFrame.class.getPackage().getImplementationVersion() == null) {
            return "ALPHA1";
        }
        return MainFrame.class.getPackage().getImplementationVersion();
    }

    private OptionsDialog getOptionsDialog() {
        if (this.optionsDialog == null) {
            this.optionsDialog = new OptionsDialog(this.game, this);
        }
        return this.optionsDialog;
    }
}

