/*
 * Decompiled with CFR 0.152.
 */
package org.escoba.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.escoba.Game;

public class OptionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel cp = null;
    private JRadioButton handRadio;
    private JRadioButton alternateRadio;
    private JComboBox barajaCombo;
    private JButton acceptButton;
    private Game game;

    public OptionsDialog(Game game, Frame frame) {
        super(frame);
        this.game = game;
        this.initialize();
    }

    public void open() {
        if (this.game.isHandTurn()) {
            this.handRadio.setSelected(true);
        } else {
            this.alternateRadio.setEnabled(true);
        }
        this.barajaCombo.setSelectedIndex(this.game.getBaraja());
        this.setVisible(true);
    }

    private void initialize() {
        this.setSize(250, 150);
        this.setTitle("Opciones");
        this.setContentPane(this.getJContentPane());
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.setResizable(false);
    }

    private JPanel getJContentPane() {
        if (this.cp == null) {
            this.cp = new JPanel();
            this.cp.setLayout(new BorderLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.handRadio = this.createRadio("de mano");
            buttonGroup.add(this.handRadio);
            this.alternateRadio = this.createRadio("alternado");
            buttonGroup.add(this.alternateRadio);
            JPanel jPanel = new JPanel();
            jPanel.add(this.createLabel("Turno: "));
            jPanel.add(this.handRadio);
            jPanel.add(this.alternateRadio);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.createLabel("Usar baraja: "));
            this.barajaCombo = new JComboBox();
            this.barajaCombo.setPreferredSize(new Dimension(100, this.barajaCombo.getPreferredSize().height));
            this.barajaCombo.addItem("Normal");
            this.barajaCombo.addItem("Cl\u00e1sica");
            this.barajaCombo.setEditable(false);
            jPanel2.add(this.barajaCombo);
            JPanel jPanel3 = new JPanel();
            AbstractAction abstractAction = new AbstractAction("Aceptar"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.game.setBaraja(OptionsDialog.this.barajaCombo.getSelectedIndex());
                    OptionsDialog.this.game.setHandTurn(OptionsDialog.this.handRadio.isSelected());
                    OptionsDialog.this.setVisible(false);
                }
            };
            this.acceptButton = new JButton(abstractAction);
            jPanel3.add(this.acceptButton);
            this.getRootPane().setDefaultButton(this.acceptButton);
            AbstractAction abstractAction2 = new AbstractAction("Cancelar"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.setVisible(false);
                }
            };
            jPanel3.add(new JButton(abstractAction2));
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
            this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", abstractAction2);
            Box box = new Box(1);
            box.add(jPanel);
            box.add(jPanel2);
            this.cp.add((Component)box, "Center");
            this.cp.add((Component)jPanel3, "South");
        }
        return this.cp;
    }

    private JRadioButton createRadio(String string) {
        return new JRadioButton(string, false);
    }

    private JLabel createLabel(String string) {
        return new JLabel(string);
    }
}

