/*
 * Decompiled with CFR 0.152.
 */
package org.escoba.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.escoba.Game;
import org.escoba.Observable;
import org.escoba.Observer;
import org.escoba.Player;
import org.escoba.ui.CardComponent;
import org.escoba.ui.Util;

public class PlayerComponent
extends Box
implements Observer {
    private static final long serialVersionUID = -3959269004162585448L;
    private Game game;
    private Player player;
    private JLabel playerName;
    private JLabel infoLabel;
    private JButton dropButton = null;

    public PlayerComponent(Game game, Player player) {
        super(1);
        this.game = game;
        this.player = player;
        this.player.addObserver(this);
        this.initialize();
    }

    private void initialize() {
        this.setBorder(this.createBorder(Color.WHITE));
        this.setOpaque(false);
        this.playerName = new JLabel();
        this.playerName.setFont(this.playerName.getFont().deriveFont(1, 14.0f));
        this.playerName.setForeground(Color.WHITE);
        this.playerName.setText(this.player.getName());
        this.add(this.playerName);
        this.infoLabel = new JLabel();
        this.infoLabel.setFont(this.playerName.getFont().deriveFont(1, 11.0f));
        this.infoLabel.setForeground(Color.WHITE);
        this.add(this.infoLabel);
        Box box = Box.createHorizontalBox();
        if (this.player.isHuman()) {
            box.add(this.getDropButton());
        }
        for (int i = 0; i < this.getPlayer().getHand().maxSize(); ++i) {
            final CardComponent cardComponent = new CardComponent(this.game, this.getPlayer().getHand(), i);
            cardComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    final MouseEvent mouseEvent2 = mouseEvent;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = cardComponent.getIndex();
                            if (!PlayerComponent.this.game.isGameStarted() || !PlayerComponent.this.game.getCurrentPlayer().isHuman()) {
                                return;
                            }
                            Util.playTick();
                            if (mouseEvent2.getButton() == 1) {
                                PlayerComponent.this.getPlayer().getHand().setSelected(n, !PlayerComponent.this.getPlayer().getHand().isSelected(n));
                                PlayerComponent.this.dropButton.setEnabled(PlayerComponent.this.getPlayer().getHand().isSelected(n));
                                if (PlayerComponent.this.getGame().isReadyToTake()) {
                                    PlayerComponent.this.getGame().takeCards();
                                    PlayerComponent.this.dropButton.setEnabled(false);
                                    PlayerComponent.this.getRootPane().repaint();
                                }
                                PlayerComponent.this.getRootPane().repaint();
                            } else if (mouseEvent2.getButton() == 3) {
                                PlayerComponent.this.getPlayer().getHand().setSelected(n, true);
                                PlayerComponent.this.getGame().dropCard();
                                PlayerComponent.this.dropButton.setEnabled(false);
                                PlayerComponent.this.getRootPane().repaint();
                            }
                        }
                    });
                }
            });
            box.add(cardComponent);
        }
        this.add(box);
    }

    private JButton getDropButton() {
        if (this.dropButton == null) {
            Insets insets = new Insets(0, 0, 0, 0);
            this.dropButton = Util.createButton(null, 10, "/img/left.png", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlayerComponent.this.game.dropCard();
                            PlayerComponent.this.dropButton.setEnabled(false);
                            Util.playTick();
                            PlayerComponent.this.getRootPane().repaint();
                        }
                    });
                }
            });
            this.dropButton.setMargin(insets);
            this.dropButton.setEnabled(false);
        }
        return this.dropButton;
    }

    private Border createBorder(Color color) {
        return new CompoundBorder(new EmptyBorder(2, 5, 2, 5), new CompoundBorder(BorderFactory.createLineBorder(color, 2), new EmptyBorder(2, 5, 2, 5)));
    }

    private Player getPlayer() {
        return this.player;
    }

    private Game getGame() {
        return this.game;
    }

    @Override
    public void eventNotify(Observable observable) {
        this.infoLabel.setText(MessageFormat.format("Levante: {0} Oros: {1} Escobas: {2} 7-Velos: {3}", this.player.getGameStats().getCardsCount(), this.player.getGameStats().getGoldsCount(), this.player.getGameStats().getEscobasCount(), this.player.getGameStats().isGold7() ? "Si" : "No"));
        this.playerName.setText(MessageFormat.format("{0} ({1} puntos)", this.player.getName(), this.player.getPoints()));
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        Color color2 = color = this.game.getCurrentPlayer() == this.player ? Color.YELLOW : Color.WHITE;
        if (this.playerName.getForeground() != color) {
            this.playerName.setForeground(color);
            this.infoLabel.setForeground(color);
            this.setBorder(this.createBorder(color));
        }
        super.paint(graphics);
    }

    public void disableButtons() {
        if (this.dropButton != null) {
            this.dropButton.setEnabled(false);
        }
    }
}

