/*
 * Decompiled with CFR 0.152.
 */
package org.escoba.ui;

import com.jhlabs.image.GlowFilter;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class Util {
    private static GlowFilter glow = new GlowFilter();
    private static AudioClip tickSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/tick.wav"));
    private static AudioClip popSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/pop.wav"));
    private static AudioClip shuffleSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/shuffle.wav"));
    private static AudioClip dotSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/dot.wav"));
    private static AudioClip gongSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/gong.wav"));
    private static AudioClip swishSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/swish.wav"));
    private static AudioClip clickSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/click.wav"));
    private static AudioClip woodSound = Applet.newAudioClip(ClassLoader.getSystemResource("wav/wood.wav"));

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JButton createButton(String string, int n, String string2, ActionListener actionListener) {
        ImageIcon imageIcon = Util.loadImageIcon(string2);
        JButton jButton = new JButton(string, imageIcon);
        jButton.setOpaque(false);
        jButton.setMnemonic(n);
        jButton.setContentAreaFilled(false);
        jButton.setForeground(Color.WHITE);
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        jButton.setRolloverIcon(new ImageIcon(glow.filter(bufferedImage, null)));
        jButton.setFocusable(false);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static void playTick() {
        Util.play(tickSound);
    }

    public static void playClick() {
        Util.play(clickSound);
    }

    public static void playPop() {
        Util.play(popSound);
    }

    public static void playShuffle() {
        Util.play(shuffleSound);
    }

    public static void playDot() {
        Util.play(dotSound);
    }

    public static void playGong() {
        Util.play(gongSound);
    }

    public static void playSwish() {
        Util.play(swishSound);
    }

    public static void playWood() {
        Util.play(woodSound);
    }

    private static void play(AudioClip audioClip) {
        if (audioClip != null) {
            audioClip.play();
        }
    }

    public static Image loadImage(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return new ImageIcon(ClassLoader.getSystemResource(string)).getImage();
    }

    public static ImageIcon loadImageIcon(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return new ImageIcon(ClassLoader.getSystemResource(string));
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

