/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.solitaire;

import com.fbergeron.card.Card;
import com.fbergeron.card.ClassicCard;
import com.fbergeron.card.ClassicDeck;
import com.fbergeron.card.Stack;
import com.fbergeron.solitaire.FrameCongratulations;
import com.fbergeron.solitaire.FrameRules;
import com.fbergeron.solitaire.GameInfo;
import com.fbergeron.solitaire.GameState;
import com.fbergeron.solitaire.SequentialStack;
import com.fbergeron.solitaire.SolitaireStack;
import com.fbergeron.util.DialogMsg;
import com.fbergeron.util.FrameAbout;
import com.fbergeron.util.WindowManager;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;

public class Solitaire
extends Frame {
    public static final int SEQ_STACK_CNT = 4;
    public static final int SOL_STACK_CNT = 7;
    public static final int FREED_CARDS_CNT = 3;
    public static final Point DECK_POS = new Point(5, 5);
    public static final Point REVEALED_CARDS_POS = new Point(Solitaire.DECK_POS.x + ClassicCard.DEFAULT_WIDTH + 5, 5);
    public static final Point SEQ_STACK_POS = new Point(Solitaire.REVEALED_CARDS_POS.x + ClassicCard.DEFAULT_WIDTH + 92, Solitaire.DECK_POS.y);
    public static final Point SOL_STACK_POS = new Point(Solitaire.DECK_POS.x, Solitaire.SEQ_STACK_POS.y + ClassicCard.DEFAULT_HEIGHT + 5);
    public static final Color TABLE_COLOR = new Color(0, 150, 0);
    protected Stack currStack;
    protected ClassicDeck deck;
    protected Stack revealedCards;
    protected SolitaireStack[] solStack;
    protected SequentialStack[] seqStack;
    protected Table table;
    protected ArrayList<GameState> gameStates = new ArrayList();
    protected ArrayList<GameState> legalGs = new ArrayList();
    protected int[] easyGames;
    protected int[] normalGames;
    protected int[] hardGames;
    protected int[] trickyGames;
    protected GameInfo gameInfo = new GameInfo();
    protected static ResourceBundle resBundle;
    private MenuBar menubar;
    private Menu menuOptions;
    private Menu menuHelp;
    private MenuItem menuItemNewGame;
    private MenuItem menuItemRestart;
    private MenuItem menuItemUndo;
    private CheckboxMenuItem menuItemLevelRandom;
    private CheckboxMenuItem menuItemLevelEasy;
    private CheckboxMenuItem menuItemLevelNormal;
    private CheckboxMenuItem menuItemLevelHard;
    private CheckboxMenuItem menuItemLevelTricky;
    private MenuItem menuItemRules;
    private MenuItem menuItemAbout;
    private MenuItem menuItemLicense;
    private CheckboxMenuItem menuItemHint;
    private CheckboxMenuItem menuItemEnglish;
    private CheckboxMenuItem menuItemFrench;
    private FrameAbout frameAbout;
    private FrameRules frameRules;

    public Solitaire(boolean isApplet) {
        this.setLayout(new BorderLayout(0, 0));
        this.setResizable(false);
        this.menubar = new MenuBar();
        this.setMenuBar(this.menubar);
        this.menuOptions = new Menu("Options");
        this.menubar.add(this.menuOptions);
        this.menuItemNewGame = new MenuItem("NewGame");
        this.menuItemNewGame.addActionListener(new NewGameListener());
        this.menuItemNewGame.setShortcut(new MenuShortcut(78, false));
        this.menuOptions.add(this.menuItemNewGame);
        this.menuItemRestart = new MenuItem("Restart");
        this.menuItemRestart.addActionListener(new RestartListener());
        this.menuItemRestart.setShortcut(new MenuShortcut(83, false));
        this.menuOptions.add(this.menuItemRestart);
        this.menuItemUndo = new MenuItem("Undo");
        this.menuItemUndo.addActionListener(new UndoListener());
        this.menuItemUndo.setShortcut(new MenuShortcut(85, false));
        this.menuItemUndo.setEnabled(false);
        this.menuItemLevelRandom = new CheckboxMenuItem("Random");
        class LevelListener
        implements ItemListener {
            String level;

            public LevelListener(String level) {
                this.level = level;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Solitaire.this.setGameType(this.level);
                Solitaire.this.newGame();
            }
        }
        this.menuItemLevelRandom.addItemListener(new LevelListener("Random"));
        this.menuItemLevelEasy = new CheckboxMenuItem("Easy");
        this.menuItemLevelEasy.addItemListener(new LevelListener("Winnable-Easy"));
        this.menuItemLevelNormal = new CheckboxMenuItem("Normal");
        this.menuItemLevelNormal.addItemListener(new LevelListener("Winnable-Normal"));
        this.menuItemLevelHard = new CheckboxMenuItem("Hard");
        this.menuItemLevelHard.addItemListener(new LevelListener("Winnable-Hard"));
        this.menuItemLevelTricky = new CheckboxMenuItem("Tricky");
        this.menuItemLevelTricky.addItemListener(new LevelListener("Winnable-Tricky"));
        this.setGameType("Random");
        this.menuOptions.add(this.menuItemUndo);
        this.menuOptions.add(new MenuItem("-"));
        this.menuOptions.add(this.menuItemLevelRandom);
        this.menuOptions.add(this.menuItemLevelEasy);
        this.menuOptions.add(this.menuItemLevelNormal);
        this.menuOptions.add(this.menuItemLevelHard);
        this.menuOptions.add(this.menuItemLevelTricky);
        this.menuHelp = new Menu("Help");
        this.menubar.add(this.menuHelp);
        this.menuItemRules = new MenuItem("Rules");
        this.menuItemRules.addActionListener(new RulesListener());
        this.menuItemAbout = new MenuItem("About");
        this.menuItemAbout.addActionListener(new AboutListener());
        this.menuItemLicense = new MenuItem();
        class LicenseListener
        implements ActionListener {
            LicenseListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = resBundle.getString("License");
                String msg = resBundle.getString("LicenseText");
                DialogMsg licenseWindow = new DialogMsg((Frame)Solitaire.this, title, true, msg);
                licenseWindow.setLocation(20, 20);
                licenseWindow.setSize(500, 300);
                licenseWindow.setFont(new Font("Arial", 0, 14));
                licenseWindow.setResizable(true);
                licenseWindow.setVisible(true);
            }
        }
        this.menuItemLicense.addActionListener(new LicenseListener());
        this.menuHelp.add(this.menuItemRules);
        this.menuHelp.add(new MenuItem("-"));
        this.menuHelp.add(this.menuItemAbout);
        this.menuHelp.add(this.menuItemLicense);
        this.menuHelp.add(new MenuItem("-"));
        this.menuItemHint = new CheckboxMenuItem("Hint");
        this.menuItemHint.setShortcut(new MenuShortcut(72, false));
        class HintListener
        implements ItemListener {
            HintListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Solitaire.this.table != null) {
                    Solitaire.this.table.repaint();
                }
            }
        }
        this.menuItemHint.addItemListener(new HintListener());
        this.menuHelp.add(this.menuItemHint);
        this.menuHelp.add(new MenuItem("-"));
        this.menuItemEnglish = new CheckboxMenuItem("English");
        class LocaleListener
        implements ItemListener {
            Locale locale;

            public LocaleListener(Locale locale) {
                this.locale = locale;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Solitaire.this.setLocale(this.locale);
            }
        }
        this.menuItemEnglish.addItemListener(new LocaleListener(Locale.ENGLISH));
        this.menuItemFrench = new CheckboxMenuItem("French");
        this.menuItemFrench.addItemListener(new LocaleListener(Locale.FRENCH));
        this.menuHelp.add(this.menuItemEnglish);
        this.menuHelp.add(this.menuItemFrench);
        this.table = new Table();
        this.add("Center", this.table);
        MouseManager mouseManager = new MouseManager();
        this.table.addMouseListener(mouseManager);
        this.table.addMouseMotionListener(mouseManager);
        this.setSize((ClassicCard.DEFAULT_WIDTH + 5) * 7 + 10 + this.getInsets().left + this.getInsets().right + 3, 560);
        this.addWindowListener(new SolitaireWindowManager(this, isApplet ? 0 : 2));
        this.setupWinnable();
        this.newGame();
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        Dimension scrSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        if (b) {
            this.setLocation((scrSize.width - size.width) / 2, (scrSize.height - size.height) / 2);
        }
        super.setVisible(b);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        resBundle = ResourceBundle.getBundle(Solitaire.class.getName() + "Ress", locale);
        this.menuOptions.setLabel(resBundle.getString("Options"));
        this.menuItemNewGame.setLabel(resBundle.getString("NewGame"));
        this.menuHelp.setLabel(resBundle.getString("Help"));
        this.menuItemRules.setLabel(resBundle.getString("Rules"));
        this.menuItemAbout.setLabel(resBundle.getString("About"));
        this.menuItemLicense.setLabel(resBundle.getString("License"));
        this.menuItemEnglish.setLabel(resBundle.getString("English"));
        this.menuItemFrench.setLabel(resBundle.getString("French"));
        this.menuItemHint.setLabel(resBundle.getString("Hint"));
        this.menuItemRestart.setLabel(resBundle.getString("Restart"));
        this.menuItemUndo.setLabel(resBundle.getString("Undo"));
        this.menuItemLevelRandom.setLabel(resBundle.getString("LevelRandom"));
        this.menuItemLevelEasy.setLabel(resBundle.getString("LevelEasy"));
        this.menuItemLevelNormal.setLabel(resBundle.getString("LevelNormal"));
        this.menuItemLevelHard.setLabel(resBundle.getString("LevelHard"));
        this.menuItemLevelTricky.setLabel(resBundle.getString("LevelTricky"));
        this.menuItemEnglish.setState(Locale.ENGLISH.equals(locale));
        this.menuItemFrench.setState(Locale.FRENCH.equals(locale));
        this.setTitle(resBundle.getString("Solitaire"));
        if (this.frameAbout != null) {
            this.frameAbout.setLocale(locale);
        }
        if (this.frameRules != null) {
            this.frameRules.setLocale(locale);
        }
        if (this.table != null) {
            this.table.repaint();
        }
    }

    public void setGameType(String gameType) {
        this.gameInfo.setType(gameType);
        this.menuItemLevelRandom.setState("Random".equals(gameType));
        this.menuItemLevelEasy.setState("Winnable-Easy".equals(gameType));
        this.menuItemLevelNormal.setState("Winnable-Normal".equals(gameType));
        this.menuItemLevelHard.setState("Winnable-Hard".equals(gameType));
        this.menuItemLevelTricky.setState("Winnable-Tricky".equals(gameType));
    }

    private void pushGameState(GameState state) {
        this.gameStates.add(state);
        this.menuItemUndo.setEnabled(this.gameStates.size() > 1);
    }

    private void popGameState() {
        this.gameStates.remove(this.gameStates.size() - 1);
        this.menuItemUndo.setEnabled(this.gameStates.size() > 1);
    }

    public static void main(String[] args) {
        Locale loc = null;
        if (args.length == 0) {
            loc = Locale.ENGLISH;
        } else if (args.length == 1) {
            Locale locale = loc = args[0].equals("fr") ? Locale.FRENCH : Locale.ENGLISH;
        }
        if (loc == null) {
            System.out.println("Usage : java com.fbergeron.solitaire.Solitaire [locale]\n\nlocale may be fr (for french) or en (for english).\n");
        } else {
            Solitaire sol = new Solitaire(false);
            sol.setLocale(loc);
        }
    }

    public void newGame() {
        int i;
        this.gameInfo.setSeed(-1);
        Random aRandom = new Random();
        if (this.gameInfo.getType().equals("Winnable-Easy")) {
            this.gameInfo.setSeed(this.easyGames[aRandom.nextInt(this.easyGames.length)]);
        }
        if (this.gameInfo.getType().equals("Winnable-Normal")) {
            this.gameInfo.setSeed(this.normalGames[aRandom.nextInt(this.normalGames.length)]);
        }
        if (this.gameInfo.getType().equals("Winnable-Hard")) {
            this.gameInfo.setSeed(this.hardGames[aRandom.nextInt(this.hardGames.length)]);
        }
        if (this.gameInfo.getType().equals("Winnable-Tricky")) {
            this.gameInfo.setSeed(this.trickyGames[aRandom.nextInt(this.trickyGames.length)]);
        }
        if (this.gameInfo.getSeed() == -1) {
            this.gameInfo.setSeed(aRandom.nextInt(1000000));
        }
        this.deck = new ClassicDeck(this.table);
        this.deck.shuffle(this.gameInfo.getSeed());
        this.deck.setLocation(Solitaire.DECK_POS.x, Solitaire.DECK_POS.y);
        this.revealedCards = new Stack();
        this.revealedCards.setLocation(Solitaire.REVEALED_CARDS_POS.x, Solitaire.REVEALED_CARDS_POS.y);
        this.seqStack = new SequentialStack[4];
        for (i = 0; i < 4; ++i) {
            this.seqStack[i] = new SequentialStack();
            this.seqStack[i].setLocation(Solitaire.SEQ_STACK_POS.x + i * (ClassicCard.DEFAULT_WIDTH + 5), Solitaire.SEQ_STACK_POS.y);
        }
        this.solStack = new SolitaireStack[7];
        for (i = 0; i < 7; ++i) {
            this.solStack[i] = new SolitaireStack();
            this.solStack[i].setSpreadingDirection(3);
            this.solStack[i].setSpreadingDelta(20);
            this.solStack[i].setLocation(Solitaire.SOL_STACK_POS.x + i * (ClassicCard.DEFAULT_WIDTH + 5), Solitaire.SOL_STACK_POS.y);
        }
        this.currStack = new Stack();
        this.currStack.setSpreadingDirection(3);
        this.currStack.setSpreadingDelta(20);
        this.distributeCards();
        if (this.table != null) {
            this.table.repaint();
        }
    }

    public void getNewCards() {
        if (this.deck.isEmpty()) {
            while (!this.revealedCards.isEmpty()) {
                ClassicCard c = (ClassicCard)this.revealedCards.pop();
                c.turnFaceDown();
                this.deck.push(c);
            }
        }
        for (int i = 0; !this.deck.isEmpty() && i < 3; ++i) {
            ClassicCard c = (ClassicCard)this.deck.pop();
            c.turnFaceUp();
            this.revealedCards.push(c);
        }
        this.pushGameState(new GameState(this.gameInfo, this.deck, this.revealedCards, this.solStack, this.seqStack, null, null, null));
        GameState gs = new GameState(this.gameInfo, this.deck, this.revealedCards, this.solStack, this.seqStack);
        this.legalGs = gs.legalMoves(false);
        if (this.table != null) {
            this.table.repaint();
        }
    }

    public void play(Stack curr, Stack src, Stack dst) {
        if (curr != null) {
            curr.reverse();
        }
        if (dst != null && dst.isValid(curr)) {
            while (!curr.isEmpty()) {
                dst.push(curr.pop());
            }
            if (!src.isEmpty() && src.top().isFaceDown()) {
                ClassicCard topCard = (ClassicCard)src.top();
                topCard.turnFaceUp();
            }
            this.pushGameState(new GameState(this.gameInfo, this.deck, this.revealedCards, this.solStack, this.seqStack, null, null, null));
            GameState gs = new GameState(this.gameInfo, this.deck, this.revealedCards, this.solStack, this.seqStack);
            this.legalGs = gs.legalMoves(false);
            if (this.isGameWon()) {
                this.congratulate();
            }
        } else {
            while (!curr.isEmpty()) {
                src.push(curr.pop());
            }
        }
        if (this.table != null) {
            this.table.repaint();
        }
    }

    private void distributeCards() {
        for (int i = 0; i < 7; ++i) {
            ClassicCard c = (ClassicCard)this.deck.pop();
            c.turnFaceUp();
            this.solStack[i].push(c);
            for (int j = i + 1; j < 7; ++j) {
                this.solStack[j].push(this.deck.pop());
            }
        }
        this.pushGameState(new GameState(this.gameInfo, this.deck, this.revealedCards, this.solStack, this.seqStack, null, null, null));
        GameState gs = new GameState(this.gameInfo, this.deck, this.revealedCards, this.solStack, this.seqStack);
        this.legalGs = gs.legalMoves(false);
    }

    private boolean isGameWon() {
        boolean gameWon;
        boolean bl = gameWon = this.deck.isEmpty() && this.revealedCards.isEmpty();
        if (gameWon) {
            for (int i = 0; i < 7 && gameWon; ++i) {
                gameWon = gameWon && this.solStack[i].isEmpty();
            }
        }
        return gameWon;
    }

    private void congratulate() {
        FrameCongratulations f = new FrameCongratulations();
        f.setVisible(true);
    }

    private void setupWinnable() {
        this.easyGames = new int[]{6, 17, 18, 37, 52, 79, 142, 202, 225, 300, 442, 450, 462, 494, 558, 629, 634, 642, 657, 664, 685, 766, 781, 822, 860, 870, 873, 888, 913, 920, 930, 987, 1027, 1056, 1063, 1099, 1148, 1164, 1228, 1229, 1251, 1254, 1255, 1334, 1353, 1360, 1378, 1390, 1464, 1502, 1563, 1587, 1627, 1639, 1649, 1735, 1742, 1755, 1780, 1855, 1891, 1920, 1960, 1989, 1993, 2004, 2040, 2090, 2094, 2119, 2180, 2250, 2253, 2272, 2284, 2358, 2364, 2385, 2403, 2409, 2414, 2420, 2463, 2481, 2500, 2511, 2513, 2530, 2533, 2678, 2686, 2689, 2753, 2759, 2789, 2809, 2885, 2914, 2985, 2997};
        this.normalGames = new int[]{0, 39, 47, 99, 186, 195, 207, 211, 259, 319, 382, 437, 536, 568, 662, 692, 734, 737, 738, 759, 773, 836, 839, 866, 899, 906, 1005, 1014, 1043, 1116, 1196, 1223, 1306, 1321, 1331, 1338, 1409, 1412, 1431, 1453, 1467, 1483, 1486, 1528, 1559, 1601, 1643, 1648, 1670, 1703, 1712, 1713, 1716, 1752, 1785, 1885, 1900, 1935, 1936, 1941, 2018, 2033, 2074, 2075, 2087, 2104, 2112, 2149, 2167, 2174, 2182, 2212, 2227, 2234, 2260, 2287, 2295, 2305, 2311, 2313, 2341, 2354, 2395, 2451, 2482, 2504, 2553, 2603, 2622, 2623, 2625, 2656, 2657, 2675, 2710, 2765, 2812, 2858, 2927, 2946, 2974};
        this.hardGames = new int[]{23, 58, 86, 106, 126, 134, 140, 169, 236, 260, 290, 320, 452, 458, 501, 502, 534, 561, 636, 676, 696, 729, 762, 806, 815, 861, 862, 869, 880, 932, 958, 1037, 1093, 1098, 1129, 1135, 1142, 1155, 1200, 1224, 1236, 1344, 1364, 1396, 1405, 1455, 1476, 1489, 1497, 1541, 1589, 1614, 1650, 1665, 1676, 1696, 1710, 1719, 1744, 1779, 1838, 1850, 1868, 1906, 1930, 1967, 1994, 1998, 2047, 2057, 2076, 2077, 2144, 2146, 2150, 2193, 2220, 2256, 2322, 2331, 2398, 2399, 2413, 2416, 2422, 2434, 2435, 2488, 2490, 2506, 2520, 2569, 2709, 2743, 2820, 2861, 2886, 2893, 2961, 2983};
        this.trickyGames = new int[]{1, 7, 14, 40, 50, 65, 67, 123, 157, 184, 185, 194, 328, 372, 408, 447, 484, 498, 509, 548, 559, 571, 581, 613, 660, 661, 680, 782, 852, 855, 903, 910, 915, 961, 965, 1090, 1108, 1131, 1153, 1179, 1188, 1193, 1212, 1214, 1217, 1318, 1325, 1333, 1388, 1403, 1425, 1437, 1473, 1475, 1487, 1507, 1516, 1619, 1624, 1631, 1640, 1654, 1673, 1679, 1688, 1761, 1783, 1853, 1875, 1948, 2011, 2032, 2041, 2043, 2053, 2108, 2139, 2277, 2301, 2400, 2417, 2428, 2474, 2478, 2627, 2646, 2684, 2724, 2760, 2770, 2790, 2848, 2859, 2868, 2884, 2909, 2925, 2934, 2941, 2962};
    }

    class SolitaireWindowManager
    extends WindowManager {
        SolitaireWindowManager(Window window, int action) {
            super(window, action);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (Solitaire.this.frameAbout != null) {
                Solitaire.this.frameAbout.dispose();
                Solitaire.this.frameAbout = null;
            }
            if (Solitaire.this.frameRules != null) {
                Solitaire.this.frameRules.dispose();
                Solitaire.this.frameRules = null;
            }
            super.windowClosing(e);
        }
    }

    class Table
    extends Canvas {
        private Image offscreen;
        private Graphics2D offscreenGr;

        Table() {
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            Dimension dim = this.getSize();
            if (this.offscreen == null) {
                this.offscreen = this.createImage(dim.width, dim.height);
                this.offscreenGr = (Graphics2D)this.offscreen.getGraphics();
            }
            this.offscreenGr.setColor(TABLE_COLOR);
            this.offscreenGr.fillRect(0, 0, dim.width, dim.height);
            if (Solitaire.this.deck != null) {
                if (Solitaire.this.deck.isEmpty()) {
                    Point loc = Solitaire.this.deck.getLocation();
                    this.offscreenGr.setColor(Color.darkGray);
                    this.offscreenGr.fillRect(loc.x, loc.y, ClassicCard.DEFAULT_WIDTH, ClassicCard.DEFAULT_HEIGHT);
                    this.offscreenGr.setColor(Color.black);
                    this.offscreenGr.drawRect(loc.x, loc.y, ClassicCard.DEFAULT_WIDTH, ClassicCard.DEFAULT_HEIGHT);
                } else {
                    boolean xx = Solitaire.this.menuItemHint.getState();
                    Solitaire.this.deck.top().paint(this.offscreenGr, Solitaire.this.menuItemHint.getState());
                }
            }
            if (Solitaire.this.revealedCards != null && !Solitaire.this.revealedCards.isEmpty()) {
                Solitaire.this.revealedCards.top().paint(this.offscreenGr, Solitaire.this.menuItemHint.getState());
            }
            if (Solitaire.this.seqStack != null) {
                for (int i = 0; i < 4; ++i) {
                    Solitaire.this.seqStack[i].paint(this.offscreenGr, Solitaire.this.menuItemHint.getState());
                }
            }
            if (Solitaire.this.solStack != null) {
                for (int i = 0; i < 7; ++i) {
                    Solitaire.this.solStack[i].paint(this.offscreenGr, Solitaire.this.menuItemHint.getState());
                }
            }
            if (Solitaire.this.currStack != null && !Solitaire.this.currStack.isEmpty()) {
                Solitaire.this.currStack.paint(this.offscreenGr, Solitaire.this.menuItemHint.getState());
            }
            if (Solitaire.this.gameInfo != null && Solitaire.this.gameInfo.getType() != null && Solitaire.this.gameInfo.getSeed() != -1 && resBundle != null) {
                String isRandomStr = null;
                String levelStr = null;
                String gameInfoStr = null;
                if ("Random".equals(Solitaire.this.gameInfo.getType())) {
                    isRandomStr = "Random ";
                    if (Arrays.asList(new int[][]{Solitaire.this.easyGames}).contains(Solitaire.this.gameInfo.getSeed())) {
                        levelStr = "Easy";
                    } else if (Arrays.asList(new int[][]{Solitaire.this.normalGames}).contains(Solitaire.this.gameInfo.getSeed())) {
                        levelStr = "Normal";
                    } else if (Arrays.asList(new int[][]{Solitaire.this.hardGames}).contains(Solitaire.this.gameInfo.getSeed())) {
                        levelStr = "Hard";
                    } else if (Arrays.asList(new int[][]{Solitaire.this.trickyGames}).contains(Solitaire.this.gameInfo.getSeed())) {
                        levelStr = "Tricky";
                    }
                    gameInfoStr = MessageFormat.format(resBundle.getString("GameInfoRandom"), Solitaire.this.gameInfo.getSeed());
                } else {
                    isRandomStr = "";
                    if (Solitaire.this.gameInfo.getType().equals("Winnable-Easy")) {
                        levelStr = "Easy";
                    } else if (Solitaire.this.gameInfo.getType().equals("Winnable-Normal")) {
                        levelStr = "Normal";
                    }
                    if (Solitaire.this.gameInfo.getType().equals("Winnable-Hard")) {
                        levelStr = "Hard";
                    }
                    if (Solitaire.this.gameInfo.getType().equals("Winnable-Tricky")) {
                        levelStr = "Tricky";
                    }
                    gameInfoStr = MessageFormat.format(resBundle.getString("GameInfoWinnable"), resBundle.getString("Level" + levelStr), Solitaire.this.gameInfo.getSeed());
                }
                Font gameInfoFont = new Font("Arial", 0, 14);
                FontMetrics gameInfoFontMetrics = this.offscreenGr.getFontMetrics(gameInfoFont);
                this.offscreenGr.setFont(gameInfoFont);
                int x = 10;
                int y = dim.height - gameInfoFontMetrics.getHeight();
                this.offscreenGr.setColor(Color.black);
                this.offscreenGr.drawString(gameInfoStr, x + 1, y + 1);
                this.offscreenGr.setColor(Color.white);
                this.offscreenGr.drawString(gameInfoStr, x, y);
            }
            g.drawImage(this.offscreen, 0, 0, this);
        }

        public void destroy() {
            this.offscreenGr.dispose();
        }
    }

    class MouseManager
    extends MouseAdapter
    implements MouseMotionListener {
        private Stack curr;
        private Stack src;
        private Stack dst;
        private Point translation;

        MouseManager() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (Solitaire.this.currStack != null && this.translation != null) {
                Point p = e.getPoint();
                Solitaire.this.currStack.setLocation(p.x - this.translation.x, p.y - this.translation.y);
                Solitaire.this.table.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!(e.isMetaDown() || e.isControlDown() || e.isShiftDown())) {
                Card c = null;
                Point p = e.getPoint();
                if (Solitaire.this.deck.contains(p)) {
                    Solitaire.this.getNewCards();
                } else {
                    if (!Solitaire.this.revealedCards.isEmpty() && Solitaire.this.revealedCards.top().contains(p)) {
                        this.src = Solitaire.this.revealedCards;
                        c = (ClassicCard)this.src.top();
                    } else {
                        int i;
                        for (i = 0; i < 7 && this.src == null; ++i) {
                            if (Solitaire.this.solStack[i].isEmpty() || !Solitaire.this.solStack[i].contains(p)) continue;
                            this.src = Solitaire.this.solStack[i];
                            c = (ClassicCard)this.src.getClickedCard(p);
                        }
                        for (i = 0; i < 4 && this.src == null; ++i) {
                            if (Solitaire.this.seqStack[i].isEmpty() || !Solitaire.this.seqStack[i].contains(p)) continue;
                            this.src = Solitaire.this.seqStack[i];
                            c = (ClassicCard)this.src.top();
                        }
                    }
                    if (c != null && c.isFaceDown()) {
                        this.src = null;
                        c = null;
                    }
                    if (this.src != null && c != null) {
                        Point loc = c.getLocation();
                        this.translation = new Point(p.x - loc.x, p.y - loc.y);
                        Solitaire.this.currStack = this.src.pop(c);
                        Solitaire.this.currStack.reverse();
                        this.curr = Solitaire.this.currStack;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int i;
            Point p = e.getPoint();
            for (i = 0; i < 7 && this.dst == null; ++i) {
                if (!Solitaire.this.solStack[i].contains(p)) continue;
                this.dst = Solitaire.this.solStack[i];
            }
            for (i = 0; i < 4 && this.dst == null; ++i) {
                if (!Solitaire.this.seqStack[i].contains(p)) continue;
                this.dst = Solitaire.this.seqStack[i];
            }
            if (this.curr != null && this.src != null) {
                Solitaire.this.play(this.curr, this.src, this.dst);
            }
            this.dst = null;
            this.src = null;
            this.curr = null;
        }
    }

    class RulesListener
    implements ActionListener {
        RulesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Solitaire.this.frameRules == null) {
                Solitaire.this.frameRules = new FrameRules();
            }
            Solitaire.this.frameRules.setLocale(Solitaire.this.getLocale());
            Solitaire.this.frameRules.setVisible(true);
        }
    }

    class UndoListener
    implements ActionListener {
        UndoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Solitaire.this.gameStates.size() - 2 >= 0) {
                Solitaire.this.gameStates.get(Solitaire.this.gameStates.size() - 2).restoreGameState(Solitaire.this.gameInfo, Solitaire.this.deck, Solitaire.this.revealedCards, Solitaire.this.solStack, Solitaire.this.seqStack, null);
                Solitaire.this.popGameState();
            }
            GameState gs = new GameState(Solitaire.this.gameInfo, Solitaire.this.deck, Solitaire.this.revealedCards, Solitaire.this.solStack, Solitaire.this.seqStack);
            Solitaire.this.legalGs = gs.legalMoves(false);
            Solitaire.this.table.repaint();
        }
    }

    class RestartListener
    implements ActionListener {
        RestartListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Solitaire.this.gameStates.get(0).restoreGameState(Solitaire.this.gameInfo, Solitaire.this.deck, Solitaire.this.revealedCards, Solitaire.this.solStack, Solitaire.this.seqStack, null);
            Solitaire.this.gameStates = new ArrayList();
            Solitaire.this.pushGameState(new GameState(Solitaire.this.gameInfo, Solitaire.this.deck, Solitaire.this.revealedCards, Solitaire.this.solStack, Solitaire.this.seqStack, null, null, null));
            GameState gs = new GameState(Solitaire.this.gameInfo, Solitaire.this.deck, Solitaire.this.revealedCards, Solitaire.this.solStack, Solitaire.this.seqStack);
            Solitaire.this.legalGs = gs.legalMoves(false);
            Solitaire.this.table.repaint();
        }
    }

    class NewGameListener
    implements ActionListener {
        NewGameListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Solitaire.this.newGame();
        }
    }

    class AboutListener
    implements ActionListener {
        AboutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Solitaire.this.frameAbout == null) {
                Solitaire.this.frameAbout = new FrameAbout();
            }
            Solitaire.this.frameAbout.setLocale(Solitaire.this.getLocale());
            Solitaire.this.frameAbout.setVisible(true);
        }
    }
}

