/*
 * Decompiled with CFR 0.152.
 */
package com.fbergeron.util;

import com.fbergeron.util.ImagePanel;
import com.fbergeron.util.Util;
import com.fbergeron.util.WindowManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;

public class FrameAbout
extends Frame {
    private CardLayout cardLayout;
    private Panel panelAbout;
    private Panel panelCredits;
    private Label labelVersion;
    private ImagePanel panelPicture;
    private Panel panelBottom;
    private Button buttonShowCredits;
    private Label labelCredits;
    private TextArea textAreaCredits;
    private Button buttonHideCredits;
    private Panel panelButtons;
    private Panel panelAuthor;
    private Label labelDate;
    private Label labelAuthor;
    private Label labelEmail;
    private Label labelWebSite;
    private ResourceBundle resBundle;
    private static final String CARD_ABOUT = "About";
    private static final String CARD_CREDITS = "Credits";

    public FrameAbout() {
        this.setLayout(new CardLayout());
        this.panelAbout = new Panel(new BorderLayout());
        this.panelAbout.setBackground(Color.white);
        Image imgLogo = Util.getImageResourceFile("logo.jpg", this.getClass());
        Util.loadImages(new Image[]{imgLogo}, this);
        this.panelPicture = new ImagePanel(imgLogo);
        this.panelBottom = new Panel(new BorderLayout());
        this.panelButtons = new Panel(new BorderLayout());
        this.buttonShowCredits = new Button();
        this.buttonShowCredits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameAbout.this.showCredits();
            }
        });
        this.panelButtons.add((Component)this.buttonShowCredits, "South");
        this.panelAuthor = new Panel(new GridLayout(0, 1));
        this.labelVersion = new Label("", 2);
        this.labelAuthor = new Label("", 2);
        this.labelEmail = new Label("", 2);
        this.labelWebSite = new Label("", 2);
        this.labelDate = new Label("", 2);
        this.panelAuthor.add(this.labelVersion);
        this.panelAuthor.add(this.labelAuthor);
        this.panelAuthor.add(this.labelEmail);
        this.panelAuthor.add(this.labelWebSite);
        this.panelAuthor.add(this.labelDate);
        this.panelBottom.add((Component)this.panelButtons, "West");
        this.panelBottom.add((Component)this.panelAuthor, "East");
        this.panelAbout.add((Component)this.panelPicture, "Center");
        this.panelAbout.add((Component)this.panelBottom, "South");
        this.panelCredits = new Panel(new BorderLayout(5, 5));
        this.panelCredits.setBackground(Color.white);
        this.labelCredits = new Label();
        this.textAreaCredits = new TextArea();
        this.buttonHideCredits = new Button();
        this.buttonHideCredits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameAbout.this.hideCredits();
            }
        });
        this.panelCredits.add((Component)this.labelCredits, "North");
        this.panelCredits.add((Component)this.textAreaCredits, "Center");
        this.panelCredits.add((Component)this.buttonHideCredits, "South");
        this.add((Component)this.panelAbout, CARD_ABOUT);
        this.add((Component)this.panelCredits, CARD_CREDITS);
        this.hideCredits();
        this.addWindowListener(new WindowManager(this, 0));
        this.pack();
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        int top = insets.top + 10;
        int right = insets.right + 10;
        int bottom = insets.bottom + 10;
        int left = insets.left + 10;
        return new Insets(top, right, bottom, left);
    }

    @Override
    public void setVisible(boolean b) {
        Dimension scrSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        if (b) {
            this.setLocation((scrSize.width - size.width) / 2, (scrSize.height - size.height) / 2);
        }
        this.hideCredits();
        super.setVisible(b);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.resBundle = ResourceBundle.getBundle(this.getClass().getName() + "Ress", locale);
        this.buttonShowCredits.setLabel(this.resBundle.getString("ShowCredits"));
        this.buttonHideCredits.setLabel(this.resBundle.getString("HideCredits"));
        this.labelCredits.setText(this.resBundle.getString("CreditsTitle"));
        this.textAreaCredits.setText(this.resBundle.getString(CARD_CREDITS));
        this.labelVersion.setText(this.resBundle.getString("Version") + " " + this.resBundle.getString("VersionNumber"));
        this.labelAuthor.setText(this.resBundle.getString("By") + " : " + this.resBundle.getString("Author"));
        this.labelDate.setText(this.resBundle.getString("Copyright"));
        this.labelEmail.setText(this.resBundle.getString("Email"));
        this.labelWebSite.setText(this.resBundle.getString("WebSite"));
        this.setTitle(this.resBundle.getString(CARD_ABOUT) + " " + this.resBundle.getString("Solitaire"));
    }

    private void showCredits() {
        ((CardLayout)this.getLayout()).show(this, CARD_CREDITS);
    }

    private void hideCredits() {
        ((CardLayout)this.getLayout()).show(this, CARD_ABOUT);
    }
}

