/*
 * Decompiled with CFR 0.152.
 */
package scopa;

import it.kkorp.scopa.cpp.Campo;
import it.kkorp.scopa.cpp.Carta;
import it.kkorp.scopa.cpp.HumanInterface;
import it.kkorp.scopa.cpp.Ia2Interface;
import it.kkorp.scopa.cpp.IaInterface;
import it.kkorp.scopa.cpp.Mazzo;
import it.kkorp.scopa.cpp.PlayerInterface;
import it.kkorp.scopa.cpp.Prese;
import it.kkorp.scopa.cpp.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import scopa.ScopaAboutBox;
import scopa.ScopaApp;
import scopa.SpoglioDialog;

public class ScopaView
extends FrameView {
    private int crea_mazzo = 0;
    private int mischio = this.crea_mazzo + 1;
    private int attiva_human = this.mischio + 1;
    private int aspetto_human = this.attiva_human + 1;
    private int aspetto_cpu = this.aspetto_human + 1;
    private int metti_terra = 59;
    private int dai_carte = 60;
    private int testacroce = 90;
    private int spoglio = 100;
    private int reset = 110;
    private int finish = 500;
    private int pausa = 999;
    private int end = 9999;
    protected int hum;
    protected boolean stato_human;
    protected boolean inizia_human;
    protected boolean last_human;
    protected int stato;
    protected int iterazione;
    protected Mazzo mz;
    protected Campo terra = new Campo();
    protected Campo terra_last;
    protected int tot_h;
    protected int tot_c;
    protected PlayerInterface pP1;
    protected PlayerInterface pP2;
    protected Prese[] prese;
    protected int nPrese;
    protected int currPresa;
    protected Carta lanciataP1;
    protected Carta lanciataP2;
    protected Carta[] lastScopeP1 = new Carta[6];
    protected Carta[] lastScopeP2 = new Carta[6];
    protected int scopeP1 = 0;
    protected int scopeP2 = 0;
    protected int mano = 0;
    protected int cancello = 2;
    private JButton jButtonNext;
    private JButton jButtonOk;
    private JButton jButtonPrev;
    private JLabel jC01;
    private JLabel jC02;
    private JLabel jC03;
    private JLabel jC04;
    private JLabel jC05;
    private JLabel jC06;
    private JLabel jC07;
    private JLabel jC08;
    private JLabel jC09;
    private JLabel jC10;
    private JLabel jC11;
    private JLabel jC12;
    private JPanel jCampo;
    private JPanel jCampoTransparente;
    private JRadioButtonMenuItem jDiffAlta;
    private JRadioButtonMenuItem jDiffBassa;
    private JRadioButtonMenuItem jDiffMandrake;
    private JRadioButtonMenuItem jDiffMedia;
    private JLabel jF01;
    private JLabel jF02;
    private JLabel jF03;
    private JLabel jF04;
    private JLabel jF05;
    private JLabel jF06;
    private JLabel jF07;
    private JLabel jF08;
    private JLabel jF09;
    private JLabel jF10;
    private JLabel jF11;
    private JLabel jF12;
    private JLabel jLabelMano;
    private JLabel jLabelScopa;
    private JLabel jMazzoP1;
    private JLabel jMazzoP2;
    private JMenu jMenu1;
    private JPanel jP1Panel;
    private JLabel jP1_1;
    private JLabel jP1_2;
    private JLabel jP1_3;
    private JPanel jP2Panel;
    private JLabel jP2_1;
    private JLabel jP2_2;
    private JLabel jP2_3;
    private JCheckBoxMenuItem jPausa;
    private JLabel jScopaP1_1;
    private JLabel jScopaP1_2;
    private JLabel jScopaP1_3;
    private JLabel jScopaP1_4;
    private JLabel jScopaP1_5;
    private JLabel jScopaP1_6;
    private JLabel jScopaP2_1;
    private JLabel jScopaP2_2;
    private JLabel jScopaP2_3;
    private JLabel jScopaP2_4;
    private JLabel jScopaP2_5;
    private JLabel jScopaP2_6;
    private JLabel jScopeP1;
    private JLabel jScopeP2;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JMenuItem nuovaPartita;
    private JMenu opzioniMenu;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private ButtonGroup groupDiff = new ButtonGroup();
    private JLabel[] p1;
    private JLabel[] p2;
    private JLabel[] campo;
    private JLabel[] frecce;
    private JLabel[] labelScopeP1;
    private JLabel[] labelScopeP2;
    private final Timer pausaTimer;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    protected int iaDelay = 900;

    public ScopaView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.getFrame().setResizable(false);
        this.CreateVariables();
        this.getFrame().setTitle("Scopa");
        this.p1 = new JLabel[3];
        this.p2 = new JLabel[3];
        this.campo = new JLabel[12];
        this.frecce = new JLabel[12];
        this.p1[0] = this.jP1_1;
        this.p1[1] = this.jP1_2;
        this.p1[2] = this.jP1_3;
        this.p2[0] = this.jP2_1;
        this.p2[1] = this.jP2_2;
        this.p2[2] = this.jP2_3;
        this.campo[0] = this.jC01;
        this.campo[1] = this.jC07;
        this.campo[2] = this.jC02;
        this.campo[3] = this.jC08;
        this.campo[4] = this.jC03;
        this.campo[5] = this.jC09;
        this.campo[6] = this.jC04;
        this.campo[7] = this.jC10;
        this.campo[8] = this.jC05;
        this.campo[9] = this.jC11;
        this.campo[10] = this.jC06;
        this.campo[11] = this.jC12;
        this.frecce[0] = this.jF01;
        this.frecce[1] = this.jF07;
        this.frecce[2] = this.jF02;
        this.frecce[3] = this.jF08;
        this.frecce[4] = this.jF03;
        this.frecce[5] = this.jF09;
        this.frecce[6] = this.jF04;
        this.frecce[7] = this.jF10;
        this.frecce[8] = this.jF05;
        this.frecce[9] = this.jF11;
        this.frecce[10] = this.jF06;
        this.frecce[11] = this.jF12;
        this.labelScopeP1 = new JLabel[6];
        this.labelScopeP1[0] = this.jScopaP1_1;
        this.labelScopeP1[1] = this.jScopaP1_2;
        this.labelScopeP1[2] = this.jScopaP1_3;
        this.labelScopeP1[3] = this.jScopaP1_4;
        this.labelScopeP1[4] = this.jScopaP1_5;
        this.labelScopeP1[5] = this.jScopaP1_6;
        this.labelScopeP2 = new JLabel[6];
        this.labelScopeP2[0] = this.jScopaP2_1;
        this.labelScopeP2[1] = this.jScopaP2_2;
        this.labelScopeP2[2] = this.jScopaP2_3;
        this.labelScopeP2[3] = this.jScopaP2_4;
        this.labelScopeP2[4] = this.jScopaP2_5;
        this.labelScopeP2[5] = this.jScopaP2_6;
        this.jButtonNext.setVisible(false);
        this.jButtonOk.setVisible(false);
        this.jButtonPrev.setVisible(false);
        this.pausaTimer = new Timer(this.iaDelay, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ScopaView.this.lanciataP2 == null) {
                    return;
                }
                ScopaView.this.prendo(ScopaView.this.pP2, ScopaView.this.lanciataP2, ScopaView.this.aspetto_human, 2);
            }
        });
        this.pausaTimer.setRepeats(false);
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScopaView.this.statusMessageLabel.setText("");
                ScopaView.this.jLabelScopa.setVisible(false);
                System.gc();
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScopaView.this.busyIconIndex = (ScopaView.this.busyIconIndex + 1) % ScopaView.this.busyIcons.length;
                ScopaView.this.statusAnimationLabel.setIcon(ScopaView.this.busyIcons[ScopaView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!ScopaView.this.busyIconTimer.isRunning()) {
                        ScopaView.this.statusAnimationLabel.setIcon(ScopaView.this.busyIcons[0]);
                        ScopaView.this.busyIconIndex = 0;
                        ScopaView.this.busyIconTimer.start();
                    }
                    ScopaView.this.progressBar.setVisible(true);
                    ScopaView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    ScopaView.this.busyIconTimer.stop();
                    ScopaView.this.statusAnimationLabel.setIcon(ScopaView.this.idleIcon);
                    ScopaView.this.progressBar.setVisible(false);
                    ScopaView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    ScopaView.this.statusMessageLabel.setText(text == null ? "" : text);
                    ScopaView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    ScopaView.this.progressBar.setVisible(true);
                    ScopaView.this.progressBar.setIndeterminate(false);
                    ScopaView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = ScopaApp.getApplication().getMainFrame();
            this.aboutBox = new ScopaAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        ScopaApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabelScopa = new JLabel();
        this.jP1Panel = new JPanel();
        this.jP1_1 = new JLabel();
        this.jP1_2 = new JLabel();
        this.jP1_3 = new JLabel();
        this.jP2Panel = new JPanel();
        this.jP2_1 = new JLabel();
        this.jP2_2 = new JLabel();
        this.jP2_3 = new JLabel();
        this.jCampoTransparente = new JPanel();
        this.jF01 = new JLabel();
        this.jF02 = new JLabel();
        this.jF03 = new JLabel();
        this.jF04 = new JLabel();
        this.jF05 = new JLabel();
        this.jF06 = new JLabel();
        this.jF07 = new JLabel();
        this.jF08 = new JLabel();
        this.jF09 = new JLabel();
        this.jF10 = new JLabel();
        this.jF11 = new JLabel();
        this.jF12 = new JLabel();
        this.jCampo = new JPanel();
        this.jC01 = new JLabel();
        this.jC02 = new JLabel();
        this.jC03 = new JLabel();
        this.jC04 = new JLabel();
        this.jC05 = new JLabel();
        this.jC06 = new JLabel();
        this.jC07 = new JLabel();
        this.jC08 = new JLabel();
        this.jC09 = new JLabel();
        this.jC10 = new JLabel();
        this.jC11 = new JLabel();
        this.jC12 = new JLabel();
        this.jButtonPrev = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonNext = new JButton();
        this.jMazzoP1 = new JLabel();
        this.jScopaP1_1 = new JLabel();
        this.jScopaP1_2 = new JLabel();
        this.jScopaP1_3 = new JLabel();
        this.jScopaP1_4 = new JLabel();
        this.jScopaP1_5 = new JLabel();
        this.jScopaP1_6 = new JLabel();
        this.jScopeP1 = new JLabel();
        this.jMazzoP2 = new JLabel();
        this.jScopaP2_1 = new JLabel();
        this.jScopaP2_2 = new JLabel();
        this.jScopaP2_3 = new JLabel();
        this.jScopaP2_4 = new JLabel();
        this.jScopaP2_5 = new JLabel();
        this.jScopaP2_6 = new JLabel();
        this.jScopeP2 = new JLabel();
        this.jLabelMano = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.nuovaPartita = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.opzioniMenu = new JMenu();
        this.jMenu1 = new JMenu();
        this.jDiffBassa = new JRadioButtonMenuItem();
        this.jDiffMedia = new JRadioButtonMenuItem();
        this.jDiffAlta = new JRadioButtonMenuItem();
        this.jDiffMandrake = new JRadioButtonMenuItem();
        this.jPausa = new JCheckBoxMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        ResourceMap resourceMap = Application.getInstance(ScopaApp.class).getContext().getResourceMap(ScopaView.class);
        this.mainPanel.setBackground(resourceMap.getColor("mainPanel.background"));
        this.mainPanel.setMaximumSize(new Dimension(400, 530));
        this.mainPanel.setMinimumSize(new Dimension(400, 530));
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(400, 540));
        this.mainPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ScopaView.this.jButtonKeyPressed(evt);
            }
        });
        this.mainPanel.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelScopa.setIcon(new ImageIcon(this.getClass().getResource("/Napoletane/scoparotante.gif")));
        this.jLabelScopa.setText(resourceMap.getString("jLabelScopa.text", new Object[0]));
        this.jLabelScopa.setMaximumSize(new Dimension(400, 540));
        this.jLabelScopa.setMinimumSize(new Dimension(400, 540));
        this.jLabelScopa.setName("jLabelScopa");
        this.jLabelScopa.setPreferredSize(new Dimension(400, 540));
        this.mainPanel.add((Component)this.jLabelScopa, new AbsoluteConstraints(0, 0, 400, 540));
        this.jP1Panel.setBackground(resourceMap.getColor("jP1Panel.background"));
        this.jP1Panel.setName("jP1Panel");
        this.jP1Panel.setLayout(new GridLayout(1, 3, 10, 0));
        this.jP1_1.setIcon(new ImageIcon(this.getClass().getResource("/Napoletane/XX.png")));
        this.jP1_1.setText(resourceMap.getString("0.text", new Object[0]));
        this.jP1_1.setName("0");
        this.jP1_1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScopaView.this.jP2MouseClicked(evt);
            }
        });
        this.jP1Panel.add(this.jP1_1);
        this.jP1_2.setIcon(this.jP1_1.getIcon());
        this.jP1_2.setName("1");
        this.jP1_2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScopaView.this.jP2MouseClicked(evt);
            }
        });
        this.jP1Panel.add(this.jP1_2);
        this.jP1_3.setHorizontalAlignment(0);
        this.jP1_3.setIcon(this.jP1_1.getIcon());
        this.jP1_3.setName("2");
        this.jP1_3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScopaView.this.jP2MouseClicked(evt);
            }
        });
        this.jP1Panel.add(this.jP1_3);
        this.mainPanel.add((Component)this.jP1Panel, new AbsoluteConstraints(200, 410, -1, 120));
        this.jP2Panel.setBackground(resourceMap.getColor("jP2Panel.background"));
        this.jP2Panel.setName("jP2Panel");
        this.jP2Panel.setLayout(new GridLayout(1, 3, 10, 0));
        this.jP2_1.setIcon(this.jP1_1.getIcon());
        this.jP2_1.setText(resourceMap.getString("0.text", new Object[0]));
        this.jP2_1.setName("0");
        this.jP2Panel.add(this.jP2_1);
        this.jP2_2.setIcon(this.jP1_1.getIcon());
        this.jP2_2.setName("1");
        this.jP2Panel.add(this.jP2_2);
        this.jP2_3.setIcon(this.jP1_1.getIcon());
        this.jP2_3.setName("2");
        this.jP2Panel.add(this.jP2_3);
        this.mainPanel.add((Component)this.jP2Panel, new AbsoluteConstraints(10, 10, -1, 110));
        this.jCampoTransparente.setBackground(resourceMap.getColor("jCampoTransparente.background"));
        this.jCampoTransparente.setName("jCampoTransparente");
        this.jCampoTransparente.setOpaque(false);
        this.jCampoTransparente.setLayout(new GridLayout(2, 6, 10, 5));
        this.jF01.setIcon(new ImageIcon(this.getClass().getResource("/Napoletane/freccia2.gif")));
        this.jF01.setName("jF01");
        this.jCampoTransparente.add(this.jF01);
        this.jF02.setIcon(this.jF01.getIcon());
        this.jF02.setName("jF02");
        this.jCampoTransparente.add(this.jF02);
        this.jF03.setIcon(this.jF01.getIcon());
        this.jF03.setName("jF03");
        this.jCampoTransparente.add(this.jF03);
        this.jF04.setIcon(this.jF01.getIcon());
        this.jF04.setName("jF04");
        this.jCampoTransparente.add(this.jF04);
        this.jF05.setIcon(this.jF01.getIcon());
        this.jF05.setName("jF05");
        this.jCampoTransparente.add(this.jF05);
        this.jF06.setIcon(this.jF01.getIcon());
        this.jF06.setName("jF06");
        this.jCampoTransparente.add(this.jF06);
        this.jF07.setIcon(this.jF01.getIcon());
        this.jF07.setName("jF07");
        this.jCampoTransparente.add(this.jF07);
        this.jF08.setIcon(this.jF01.getIcon());
        this.jF08.setName("jF08");
        this.jCampoTransparente.add(this.jF08);
        this.jF09.setIcon(this.jF01.getIcon());
        this.jF09.setName("jF09");
        this.jCampoTransparente.add(this.jF09);
        this.jF10.setIcon(this.jF01.getIcon());
        this.jF10.setName("jF10");
        this.jCampoTransparente.add(this.jF10);
        this.jF11.setIcon(this.jF01.getIcon());
        this.jF11.setName("jF11");
        this.jCampoTransparente.add(this.jF11);
        this.jF12.setIcon(this.jF01.getIcon());
        this.jF12.setName("jF12");
        this.jCampoTransparente.add(this.jF12);
        this.mainPanel.add((Component)this.jCampoTransparente, new AbsoluteConstraints(10, 120, -1, 260));
        this.jCampo.setBackground(resourceMap.getColor("jCampo.background"));
        this.jCampo.setName("jCampo");
        this.jCampo.setLayout(new GridLayout(2, 6, 10, 5));
        this.jC01.setIcon(this.jP1_1.getIcon());
        this.jC01.setName("jC01");
        this.jCampo.add(this.jC01);
        this.jC02.setIcon(this.jP1_1.getIcon());
        this.jC02.setName("jC02");
        this.jCampo.add(this.jC02);
        this.jC03.setIcon(this.jP1_1.getIcon());
        this.jC03.setName("jC03");
        this.jCampo.add(this.jC03);
        this.jC04.setIcon(this.jP1_1.getIcon());
        this.jC04.setName("jC04");
        this.jCampo.add(this.jC04);
        this.jC05.setIcon(this.jP1_1.getIcon());
        this.jC05.setName("jC05");
        this.jCampo.add(this.jC05);
        this.jC06.setIcon(this.jP1_1.getIcon());
        this.jC06.setName("jC06");
        this.jCampo.add(this.jC06);
        this.jC07.setIcon(this.jP1_1.getIcon());
        this.jC07.setName("jC07");
        this.jCampo.add(this.jC07);
        this.jC08.setIcon(this.jP1_1.getIcon());
        this.jC08.setName("jC08");
        this.jCampo.add(this.jC08);
        this.jC09.setIcon(this.jP1_1.getIcon());
        this.jC09.setName("jC09");
        this.jCampo.add(this.jC09);
        this.jC10.setIcon(this.jP1_1.getIcon());
        this.jC10.setName("jC10");
        this.jCampo.add(this.jC10);
        this.jC11.setIcon(this.jP1_1.getIcon());
        this.jC11.setName("jC11");
        this.jCampo.add(this.jC11);
        this.jC12.setIcon(this.jP1_1.getIcon());
        this.jC12.setName("jC12");
        this.jCampo.add(this.jC12);
        this.mainPanel.add((Component)this.jCampo, new AbsoluteConstraints(10, 120, -1, 260));
        this.jButtonPrev.setText(resourceMap.getString("prev.text", new Object[0]));
        this.jButtonPrev.setName("prev");
        this.jButtonPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScopaView.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonPrev.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ScopaView.this.jButtonKeyPressed(evt);
            }
        });
        this.mainPanel.add((Component)this.jButtonPrev, new AbsoluteConstraints(10, 383, -1, 20));
        this.jButtonOk.setText(resourceMap.getString("ok.text", new Object[0]));
        this.jButtonOk.setName("ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScopaView.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonOk.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ScopaView.this.jButtonKeyPressed(evt);
            }
        });
        this.mainPanel.add((Component)this.jButtonOk, new AbsoluteConstraints(70, 383, -1, 20));
        this.jButtonNext.setText(resourceMap.getString("next.text", new Object[0]));
        this.jButtonNext.setName("next");
        this.jButtonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScopaView.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonNext.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ScopaView.this.jButtonKeyPressed(evt);
            }
        });
        this.mainPanel.add((Component)this.jButtonNext, new AbsoluteConstraints(130, 383, -1, 20));
        this.jMazzoP1.setIcon(new ImageIcon(this.getClass().getResource("/Napoletane/mazzo90.png")));
        this.jMazzoP1.setText(resourceMap.getString("jMazzoP1.text", new Object[0]));
        this.jMazzoP1.setName("jMazzoP1");
        this.mainPanel.add((Component)this.jMazzoP1, new AbsoluteConstraints(130, 420, -1, -1));
        this.jScopaP1_1.setIcon(this.jP1_1.getIcon());
        this.jScopaP1_1.setName("jScopaP1_1");
        this.mainPanel.add((Component)this.jScopaP1_1, new AbsoluteConstraints(110, 420, -1, -1));
        this.jScopaP1_2.setIcon(this.jP1_1.getIcon());
        this.jScopaP1_2.setName("jScopaP1_2");
        this.mainPanel.add((Component)this.jScopaP1_2, new AbsoluteConstraints(90, 420, -1, -1));
        this.jScopaP1_3.setIcon(this.jP1_1.getIcon());
        this.jScopaP1_3.setName("jScopaP1_3");
        this.mainPanel.add((Component)this.jScopaP1_3, new AbsoluteConstraints(70, 420, -1, -1));
        this.jScopaP1_4.setIcon(this.jP1_1.getIcon());
        this.jScopaP1_4.setName("jScopaP1_4");
        this.mainPanel.add((Component)this.jScopaP1_4, new AbsoluteConstraints(50, 420, -1, -1));
        this.jScopaP1_5.setIcon(this.jP1_1.getIcon());
        this.jScopaP1_5.setName("jScopaP1_5");
        this.mainPanel.add((Component)this.jScopaP1_5, new AbsoluteConstraints(30, 420, -1, -1));
        this.jScopaP1_6.setIcon(this.jP1_1.getIcon());
        this.jScopaP1_6.setName("jScopaP1_6");
        this.mainPanel.add((Component)this.jScopaP1_6, new AbsoluteConstraints(10, 420, -1, -1));
        this.jScopeP1.setText(resourceMap.getString("jScopeP1.text", new Object[0]));
        this.jScopeP1.setName("jScopeP1");
        this.mainPanel.add((Component)this.jScopeP1, new AbsoluteConstraints(70, 520, 30, 20));
        this.jMazzoP2.setIcon(this.jMazzoP1.getIcon());
        this.jMazzoP2.setName("jMazzoP2");
        this.mainPanel.add((Component)this.jMazzoP2, new AbsoluteConstraints(210, 10, -1, -1));
        this.jScopaP2_1.setIcon(this.jP1_1.getIcon());
        this.jScopaP2_1.setName("jScopaP2_1");
        this.mainPanel.add((Component)this.jScopaP2_1, new AbsoluteConstraints(240, 10, -1, -1));
        this.jScopaP2_2.setIcon(this.jP1_1.getIcon());
        this.jScopaP2_2.setName("jScopaP2_2");
        this.mainPanel.add((Component)this.jScopaP2_2, new AbsoluteConstraints(260, 10, -1, -1));
        this.jScopaP2_3.setIcon(this.jP1_1.getIcon());
        this.jScopaP2_3.setName("jScopaP2_3");
        this.mainPanel.add((Component)this.jScopaP2_3, new AbsoluteConstraints(280, 10, -1, -1));
        this.jScopaP2_4.setIcon(this.jP1_1.getIcon());
        this.jScopaP2_4.setName("jScopaP2_4");
        this.mainPanel.add((Component)this.jScopaP2_4, new AbsoluteConstraints(300, 10, -1, -1));
        this.jScopaP2_5.setIcon(this.jP1_1.getIcon());
        this.jScopaP2_5.setName("jScopaP2_5");
        this.mainPanel.add((Component)this.jScopaP2_5, new AbsoluteConstraints(320, 10, -1, -1));
        this.jScopaP2_6.setIcon(this.jP1_1.getIcon());
        this.jScopaP2_6.setName("jScopaP2_6");
        this.mainPanel.add((Component)this.jScopaP2_6, new AbsoluteConstraints(340, 10, -1, -1));
        this.jScopeP2.setText(resourceMap.getString("jScopeP2.text", new Object[0]));
        this.jScopeP2.setName("jScopeP2");
        this.mainPanel.add((Component)this.jScopeP2, new AbsoluteConstraints(310, 105, 30, 20));
        this.jLabelMano.setHorizontalAlignment(0);
        this.jLabelMano.setText(resourceMap.getString("jLabelMano.text", new Object[0]));
        this.jLabelMano.setName("jLabelMano");
        this.mainPanel.add((Component)this.jLabelMano, new AbsoluteConstraints(210, 390, 180, 20));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.nuovaPartita.setText(resourceMap.getString("nuovaPartita.text", new Object[0]));
        this.nuovaPartita.setName("nuovaPartita");
        this.nuovaPartita.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScopaView.this.nuovaPartitaActionPerformed(evt);
            }
        });
        fileMenu.add(this.nuovaPartita);
        ApplicationActionMap actionMap = Application.getInstance(ScopaApp.class).getContext().getActionMap(ScopaView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.opzioniMenu.setText(resourceMap.getString("opzioniMenu.text", new Object[0]));
        this.opzioniMenu.setName("opzioniMenu");
        this.jMenu1.setText(resourceMap.getString("jMenu1.text", new Object[0]));
        this.jMenu1.setName("jMenu1");
        this.groupDiff.add(this.jDiffBassa);
        this.jDiffBassa.setSelected(true);
        this.jDiffBassa.setText(resourceMap.getString("jDiffBassa.text", new Object[0]));
        this.jDiffBassa.setName("jDiffBassa");
        this.jMenu1.add(this.jDiffBassa);
        this.groupDiff.add(this.jDiffMedia);
        this.jDiffMedia.setText(resourceMap.getString("jDiffMedia.text", new Object[0]));
        this.jDiffMedia.setName("jDiffMedia");
        this.jMenu1.add(this.jDiffMedia);
        this.groupDiff.add(this.jDiffAlta);
        this.jDiffAlta.setText(resourceMap.getString("jDiffAlta.text", new Object[0]));
        this.jDiffAlta.setEnabled(false);
        this.jDiffAlta.setName("jDiffAlta");
        this.jMenu1.add(this.jDiffAlta);
        this.groupDiff.add(this.jDiffMandrake);
        this.jDiffMandrake.setText(resourceMap.getString("jDiffMandrake.text", new Object[0]));
        this.jDiffMandrake.setToolTipText(resourceMap.getString("jDiffMandrake.toolTipText", new Object[0]));
        this.jDiffMandrake.setEnabled(false);
        this.jDiffMandrake.setName("jDiffMandrake");
        this.jMenu1.add(this.jDiffMandrake);
        this.opzioniMenu.add(this.jMenu1);
        this.jPausa.setSelected(true);
        this.jPausa.setText(resourceMap.getString("jPausa.text", new Object[0]));
        this.jPausa.setName("jPausa");
        this.opzioniMenu.add(this.jPausa);
        this.menuBar.add(this.opzioniMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 400, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 230, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void jP2MouseClicked(MouseEvent evt) {
        JLabel curr = (JLabel)evt.getSource();
        Integer c = Integer.parseInt(curr.getName());
        this.hum = c;
        this.Do_aspetto_human();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        JButton curr = (JButton)evt.getSource();
        PlayerInterface currInt = null;
        Carta lanciata = null;
        int giocatore = 0;
        int newStato = -1;
        if (this.lanciataP1 != null) {
            currInt = this.pP1;
            lanciata = this.lanciataP1;
            newStato = this.aspetto_cpu;
            giocatore = 1;
        } else if (this.lanciataP2 != null) {
            currInt = this.pP2;
            lanciata = this.lanciataP2;
            newStato = this.aspetto_human;
            giocatore = 2;
        } else {
            return;
        }
        if (curr.getName().equals("prev")) {
            this.currPresa = this.currPresa == 0 ? this.nPrese - 1 : this.currPresa - 1;
            this.attivaScelta();
            this.jButtonPrev.requestFocusInWindow();
        } else if (curr.getName().equals("next")) {
            this.currPresa = (this.currPresa + 1) % this.nPrese;
            this.attivaScelta();
            this.jButtonNext.requestFocusInWindow();
        } else if (curr.getName().equals("ok")) {
            this.prendo(currInt, lanciata, newStato, giocatore);
        }
    }

    private void jButtonKeyPressed(KeyEvent evt) {
        int kc = evt.getKeyCode();
        PlayerInterface currInt = null;
        Carta lanciata = null;
        int newStato = -1;
        if (this.lanciataP1 != null) {
            currInt = this.pP1;
            lanciata = this.lanciataP1;
            newStato = this.aspetto_cpu;
        } else if (this.lanciataP2 != null) {
            currInt = this.pP2;
            lanciata = this.lanciataP2;
            newStato = this.aspetto_human;
        } else {
            return;
        }
        if (kc == 37) {
            this.jButtonPrev.requestFocusInWindow();
            this.currPresa = this.currPresa == 0 ? this.nPrese - 1 : this.currPresa - 1;
            this.attivaScelta();
        } else if (kc == 39) {
            this.jButtonNext.requestFocusInWindow();
            this.currPresa = (this.currPresa + 1) % this.nPrese;
            this.attivaScelta();
        }
    }

    private void nuovaPartitaActionPerformed(ActionEvent evt) {
        this.jLabelScopa.setVisible(false);
        this.pP1 = new HumanInterface();
        int s = 0;
        if (this.jDiffMedia.isSelected()) {
            s = 1;
        } else if (this.jDiffAlta.isSelected()) {
            s = 2;
        } else if (this.jDiffMandrake.isSelected()) {
            s = 3;
        }
        System.out.println(s);
        switch (s) {
            default: {
                this.pP2 = new IaInterface();
                break;
            }
            case 1: {
                this.pP2 = new Ia2Interface();
            }
        }
        for (JLabel jl : this.labelScopeP1) {
            jl.setVisible(false);
        }
        for (JLabel jl : this.labelScopeP2) {
            jl.setVisible(false);
        }
        this.jMazzoP1.setVisible(false);
        this.jMazzoP2.setVisible(false);
        this.jScopeP1.setText("");
        this.jScopeP2.setText("");
        this.terra.ripulisci();
        this.mano = 0;
        this.tot_h = 0;
        this.tot_c = 0;
        this.scopeP2 = 0;
        this.scopeP1 = 0;
        this.Do_crea_mazzo();
    }

    protected void CreateVariables() {
        this.hum = -1;
        this.iterazione = 0;
        this.stato_human = false;
        this.inizia_human = true;
        if (this.mz == null) {
            this.mz = new Mazzo();
        }
        this.mz.svuota();
        this.tot_h = 0;
        this.tot_c = 0;
        this.pP1 = null;
        this.pP2 = null;
        this.scopeP1 = 0;
        this.scopeP2 = 0;
    }

    protected int get_human() {
        int scelta = -1;
        scelta = this.hum;
        this.hum = -1;
        return scelta;
    }

    protected void disegna_cpu() {
        for (int i = 0; i < 3; ++i) {
            this.p2[i].setVisible(true);
        }
    }

    protected void disegna_human() {
        Carta[] nc = new Carta[3];
        boolean[] d = new boolean[3];
        this.pP1.vedi_carte(nc, d);
        for (int i = 0; i < 3; ++i) {
            if (!d[i]) {
                this.p1[i].setEnabled(false);
                this.p1[i].setVisible(false);
                continue;
            }
            this.p1[i].setIcon(Utility.immagineCarta(nc[i]));
            this.p1[i].setEnabled(true);
            this.p1[i].setVisible(true);
        }
    }

    protected void disegna_campo() {
        int dc = this.terra.dim();
        for (int i = 0; i < dc; ++i) {
            Carta nc = this.terra.leggi(i);
            this.campo[i].setIcon(Utility.immagineCarta(nc));
            this.campo[i].setVisible(true);
            this.frecce[i].setVisible(false);
        }
        for (int j = i; j < this.campo.length; ++j) {
            this.campo[j].setVisible(false);
            this.frecce[j].setVisible(false);
        }
        if (this.pP1.restituisci_mazzo().dim() > 0) {
            this.jMazzoP1.setVisible(true);
        } else {
            this.jMazzoP1.setVisible(false);
        }
        if (this.pP2.restituisci_mazzo().dim() > 0) {
            this.jMazzoP2.setVisible(true);
        } else {
            this.jMazzoP2.setVisible(false);
        }
        for (int k = 0; k < 6; ++k) {
            int scarto;
            if (this.scopeP1 > k) {
                scarto = 0;
                if (this.scopeP1 > 6) {
                    scarto = this.scopeP1 % 6;
                    System.out.println(scarto);
                }
                this.labelScopeP1[k].setIcon(Utility.immagineCarta(this.lastScopeP1[(scarto + k) % 6]));
                this.labelScopeP1[k].setVisible(true);
            } else {
                this.labelScopeP1[k].setVisible(false);
            }
            if (this.scopeP2 > k) {
                scarto = 0;
                if (this.scopeP2 > 6) {
                    scarto = this.scopeP2 % 6;
                    System.out.println(scarto);
                }
                this.labelScopeP2[k].setIcon(Utility.immagineCarta(this.lastScopeP2[(scarto + k) % 6]));
                this.labelScopeP2[k].setVisible(true);
                continue;
            }
            this.labelScopeP2[k].setVisible(false);
        }
        if (this.scopeP1 > 6) {
            this.jScopeP1.setText("" + this.scopeP1);
        } else {
            this.jScopeP1.setText("");
        }
        if (this.scopeP2 > 6) {
            this.jScopeP2.setText("" + this.scopeP2);
        } else {
            this.jScopeP2.setText("");
        }
    }

    protected void disattiva_human() {
        for (int i = 0; i < 3; ++i) {
            this.p1[i].setEnabled(false);
        }
        this.stato_human = false;
    }

    protected void Do_crea_mazzo() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 1; j <= 10; ++j) {
                Carta nc = new Carta(i, j);
                this.mz.inserisci(nc);
            }
        }
        this.Do_mischio();
    }

    protected void Do_mischio() {
        this.mz.resetta();
        for (int i = 0; i < 5000; ++i) {
            this.mz.mischia(10);
        }
        this.Do_metti_terra();
    }

    protected void Do_metti_terra() {
        this.mz.resetta();
        for (int i = 0; i < 4; ++i) {
            Carta nc = this.mz.preleva();
            this.terra.poggia(nc);
        }
        this.disegna_campo();
        this.Do_dai_carte();
    }

    protected void Do_dai_carte() {
        if (!this.mz.is_end()) {
            ++this.mano;
            this.jLabelMano.setText("Mano: " + this.mano);
            Prese acq = new Prese();
            block4: for (int j = 0; j < 2; ++j) {
                acq.svuota();
                for (int i = 0; i < 3; ++i) {
                    Carta nc = this.mz.preleva();
                    if (nc == null) {
                        this.stato = this.pausa;
                        return;
                    }
                    acq.aggiungi(nc);
                }
                switch (j) {
                    case 0: {
                        if (this.inizia_human) {
                            this.pP1.ricevi_carte(acq);
                            continue block4;
                        }
                        this.pP2.ricevi_carte(acq);
                        continue block4;
                    }
                    case 1: {
                        if (this.inizia_human) {
                            this.pP2.ricevi_carte(acq);
                            continue block4;
                        }
                        this.pP1.ricevi_carte(acq);
                    }
                }
            }
            this.disegna_human();
            this.disegna_cpu();
            if (this.inizia_human) {
                this.stato = this.attiva_human;
            } else {
                this.disattiva_human();
                this.stato = this.aspetto_cpu;
            }
        } else {
            this.inizia_human = !this.inizia_human;
            this.stato = this.spoglio;
        }
        if (this.stato == this.attiva_human) {
            this.Do_attiva_human();
        } else if (this.stato == this.aspetto_cpu) {
            this.Do_aspetto_cpu();
        } else if (this.stato == this.spoglio) {
            this.Do_spoglio();
        }
    }

    protected void Do_attiva_human() {
        for (int i = 0; i < 3; ++i) {
            this.p1[i].setEnabled(true);
        }
    }

    protected void Do_aspetto_human() {
        if (!this.stato_human) {
            this.disegna_human();
        }
        this.stato_human = true;
        Carta[] nc = new Carta[3];
        boolean[] d = new boolean[3];
        this.pP1.vedi_carte(nc, d);
        int scelta = -1;
        scelta = this.get_human();
        if (scelta != -1) {
            if (d[scelta]) {
                this.disattiva_human();
                this.pP1.lancia_carta(scelta);
                this.disegna_human();
                this.disattiva_human();
                this.stato = this.pausa;
                int n_prese = 0;
                Prese[] lista = new Prese[10];
                n_prese = this.terra.combinazioni(nc[scelta], lista, n_prese);
                if (n_prese > 0) {
                    this.currPresa = 0;
                    this.prese = lista;
                    this.nPrese = n_prese;
                    this.lanciataP1 = nc[scelta];
                    this.disegna_campo();
                    this.attivaScelta();
                    this.stato = this.pausa;
                } else {
                    this.terra.poggia(nc[scelta]);
                    this.stato = this.aspetto_cpu;
                }
            }
        } else {
            boolean ss = this.pP1.is_vuoto();
            if (ss) {
                this.stato = this.dai_carte;
            }
            this.disegna_campo();
        }
        if (this.stato == this.aspetto_cpu) {
            this.Do_aspetto_cpu();
        } else if (this.stato == this.dai_carte) {
            this.Do_dai_carte();
        }
    }

    protected void Do_aspetto_cpu() {
        this.disattiva_human();
        Carta nc = this.pP2.lancia_carta(this.terra);
        if (nc != null) {
            this.p2[this.cancello].setVisible(false);
            this.cancello = this.cancello == 0 ? 2 : --this.cancello;
            this.stato = this.pausa;
            int n_prese = 0;
            Prese[] lista = new Prese[10];
            n_prese = this.terra.combinazioni(nc, lista, n_prese);
            this.disegna_campo();
            if (n_prese > 0) {
                Prese s_presa = this.pP2.scegli_presa(this.terra, lista, n_prese);
                this.lanciataP1 = null;
                this.lanciataP2 = nc;
                this.nPrese = 1;
                this.prese = new Prese[1];
                this.prese[0] = s_presa;
                this.currPresa = 0;
                this.attivaScelta();
                if (!this.jPausa.isSelected()) {
                    this.pausaTimer.start();
                }
            } else {
                this.terra.poggia(nc);
                this.stato = this.aspetto_human;
            }
        } else {
            this.stato = this.dai_carte;
        }
        if (this.stato == this.aspetto_human) {
            this.Do_aspetto_human();
        } else if (this.stato == this.dai_carte) {
            this.Do_dai_carte();
        }
    }

    protected void Do_spoglio() {
        this.stato = this.pausa;
        int dimens = this.terra.dim();
        if (dimens > 0) {
            Prese pr = new Prese();
            pr.svuota();
            for (int i = 0; i < dimens; ++i) {
                Carta nc = this.terra.leggi(i);
                if (nc == null) continue;
                pr.aggiungi(nc);
            }
            if (this.last_human) {
                this.jLabelMano.setText("Prende tutto Human");
                this.pP1.prendi(this.terra, pr);
            } else {
                this.jLabelMano.setText("Prende tutto CPU");
                this.pP2.prendi(this.terra, pr);
            }
        }
        Timer spoglioTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScopaView.this.spoglio();
            }
        });
        spoglioTimer.setRepeats(false);
        spoglioTimer.start();
    }

    protected void spoglio() {
        this.terra.ripulisci();
        this.disegna_campo();
        SpoglioDialog dialog = new SpoglioDialog((Frame)this.getFrame(), true);
        dialog.setPlayer(this.pP1, this.pP2, this.tot_h, this.tot_c);
        dialog.setVisible(true);
        this.tot_h = dialog.getTotale(0);
        this.tot_c = dialog.getTotale(1);
        if (this.tot_h > this.tot_c && this.tot_h >= 11) {
            this.BOX("Vince Human", "Human");
            this.stato = this.finish;
        } else if (this.tot_c > this.tot_h && this.tot_c >= 11) {
            this.BOX("Vince Cpu", "Cpu");
            this.stato = this.finish;
        } else {
            this.stato = this.reset;
        }
        if (this.stato == this.finish) {
            this.Do_finish();
        } else if (this.stato == this.reset) {
            this.Do_reset();
        }
    }

    protected void Do_reset() {
        this.pP1.svuota();
        this.pP2.svuota();
        this.terra.ripulisci();
        this.mano = 0;
        this.scopeP1 = 0;
        this.scopeP2 = 0;
        this.Do_mischio();
    }

    protected void Do_finish() {
        this.stato = this.pausa;
    }

    protected void attivaScelta() {
        for (JLabel jl : this.frecce) {
            jl.setVisible(false);
        }
        for (int i = 0; i < this.terra.dim(); ++i) {
            if (!this.prese[this.currPresa].contiene(this.terra.leggi(i))) continue;
            this.frecce[i].setVisible(true);
        }
        Carta nc = null;
        nc = this.lanciataP1 != null ? this.lanciataP1 : this.lanciataP2;
        this.campo[11].setIcon(Utility.immagineCarta(nc));
        this.campo[11].setVisible(true);
        this.jButtonPrev.setVisible(true);
        this.jButtonOk.setVisible(true);
        this.jButtonNext.setVisible(true);
        this.jButtonOk.requestFocusInWindow();
    }

    protected void scopa() {
        this.statusMessageLabel.setText("Scopa!");
        this.messageTimer.setInitialDelay(1500);
        ((ImageIcon)this.jLabelScopa.getIcon()).getImage().flush();
        this.jLabelScopa.setVisible(true);
        this.messageTimer.start();
    }

    protected void prendo(PlayerInterface currInt, Carta lanciata, int newStato, int giocatore) {
        if (this.lanciataP1 == null && this.lanciataP2 == null) {
            return;
        }
        this.last_human = giocatore == 1;
        this.terra.rimuovi(this.prese[this.currPresa]);
        currInt.prendi(this.terra, lanciata);
        currInt.prendi(this.terra, this.prese[this.currPresa]);
        if (!(this.terra.dim() != 0 || this.pP2.is_vuoto() && this.pP1.is_vuoto() && this.mz.is_end())) {
            this.scopa();
            if (giocatore == 1) {
                this.lastScopeP1[this.scopeP1 % this.lastScopeP1.length] = lanciata;
                ++this.scopeP1;
            } else if (giocatore == 2) {
                this.lastScopeP2[this.scopeP2 % this.lastScopeP2.length] = lanciata;
                ++this.scopeP2;
            }
            currInt.scopa();
        }
        this.lanciataP1 = null;
        this.lanciataP2 = null;
        this.jButtonNext.setVisible(false);
        this.jButtonOk.setVisible(false);
        this.jButtonPrev.setVisible(false);
        this.stato = newStato;
        if (this.stato == this.aspetto_cpu) {
            this.Do_aspetto_cpu();
        } else if (this.stato == this.aspetto_human) {
            this.Do_aspetto_human();
        }
    }

    private void BOX(String text, String title) {
        JOptionPane.showMessageDialog(this.getFrame(), text, title, 0);
    }
}

