/*
 * Filename:	joytune.cpp
 * Author:	Robert Manley
 * Date:	Jan 9, 1995
 *
 * Copyright 1994 Robert J. Manley and Multi-Player Computer Adventures
 * All rights reserved.
 */

#include <stdlib.h>
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_DOSMEMMGR
#include <os2.h>
#include <iostream.h>

#include "joyos2.h"

ostream &
operator << (ostream &os, const GAME_2DPOS_STRUCT &pos)
{
	os << pos.x << "," << pos.y;
	return os;
}

ostream &
operator << (ostream &os, const GAME_3POS_STRUCT &pos)

{
	os << pos.lower << " " << pos.centre << " " << pos.upper;
	return os;
}

istream &
operator >> (istream &is, GAME_3POS_STRUCT &pos)

{
	is >> pos.lower >> pos.centre >> pos.upper;
	return is;
}

int
main (int argc, char *argv[])
{
	APIRET			rc;
	HFILE			hGame;
	ULONG			action;
	ULONG			version;
	GAME_PARM_STRUCT	gameParms;
	GAME_CALIB_STRUCT	gameCalib;
	GAME_STATUS_STRUCT	gameStatus;
	GAME_DIGSET_STRUCT	gameDigset;
	ULONG			parmLen, dataLen;

	cout << "Advanced OS/2 Joystick Driver Digital Reponse Tuning Application v0.1" << endl;
	cout << "Copyright 1994 Robert J. Manley and Multi-Player Computer Adventures" << endl;
	cout << endl;

	rc = DosOpen(
		GAMEPDDNAME,
		&hGame,
		&action,
		0,
		FILE_READONLY,
		FILE_OPEN,
		OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,
		NULL);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not open device" << endl;
		exit(-1);
	}

	dataLen = sizeof(version);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER,  GAME_GET_VERSION,
		NULL, 0, NULL,
		&version, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}

	if (version < 0x2a)
	{
		cerr << "ERROR: Incorrect version of driver" << endl;
		exit(-1);
	}

	dataLen = sizeof(gameParms);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER,  GAME_GET_PARMS,
		NULL, 0, NULL,
		&gameParms, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}

	if ((gameParms.useA == 0) && (gameParms.useB == 0))
	{
		cout << "No joysticks detected" << endl;
		DosClose(hGame);
		exit(0);
	}

	dataLen = sizeof(gameDigset);
	rc = DosDevIOCtl(
		hGame,
		IOCTL_CAT_USER, GAME_GET_DIGSET,
		NULL, 0, NULL,
		&gameDigset, dataLen, &dataLen);
	if (rc != 0)
	{
		cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
		exit(-1);
	}

	cout << "Current Digital Response Settings:" << endl;
	if (gameParms.useA)
		cout << "\tAx: " << gameDigset.Ax << "\tAy: " << gameDigset.Ay << endl;
	if (gameParms.useB)
		cout << "\tBx: " << gameDigset.Bx << "\tBy: " << gameDigset.By << endl;
	cout << endl;

	cout << "Do you wish to enter new digital response values? (y/N) ";
	char r = cin.get();
	if ((r == 'y') || (r == 'Y'))
	{
		cout << endl;
		cout << "Enter 3 increasing values separated by spaces for each of the following" << endl;
		cout << "Example: 1 75 149 (0 is invalid)" << endl;

		if (gameParms.useA)
		{
			cout << "\tAx: "; cin >> gameDigset.Ax;
			cout << "\t\t\tAy: "; cin >> gameDigset.Ay;
		}
		if (gameParms.useB)
		{
			cout << "\tBx: "; cin >> gameDigset.Bx;
			cout << "\t\t\tBy: "; cin >> gameDigset.By;
		}

		parmLen = sizeof(gameDigset);
		rc = DosDevIOCtl(
			hGame,
			IOCTL_CAT_USER, GAME_SET_DIGSET,
			&gameDigset, parmLen, &parmLen,
			NULL, 0, NULL);
		if (rc != 0)
		{
			cerr << "ERROR " << rc << ": Could not call IOCtl" << endl;
			exit(-1);
		}
	}
	cout << endl;

	DosClose(hGame);
}
