/***************************************************/
/* REXX Procedure to perform full backups          */
/***************************************************/
'@ECHO OFF'
logswitch = 1             /* Maintain the log file */
av = 'YES'                /* AutoVerify = YES | NO */

/***************************************************/
/* Extract the date and in mm/dd/yy format         */
/***************************************************/
rundate = Date('U')

/***************************************************/
/* Initialize REXXUtil environment (if not present)*/
/***************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End

/***************************************************/
/*  Locate the active BackMaster directory         */
/***************************************************/
bmname = SysSearchPath('PATH', 'BACKMAST.EXE')
bmdrive = Filespec('D', bmname)
bmpath = Filespec('P', bmname)
bmpath = bmdrive||bmpath

/***************************************************/
/* Extract the drives available on the system      */
/***************************************************/
drives = SysDriveMap('C:', 'LOCAL')

/***************************************************/
/* Load number of drives into table root           */
/***************************************************/
drive.0 = Words(drives)

/***************************************************/
/* Load the table with the available drive letters */
/***************************************************/
Do x=1 To drive.0 By 1
   drive.x = Word(drives, x)
End

/***************************************************/
/* Build a list of drive partitions to back up.    */
/***************************************************/
drive_string = ''
Do x=1 To drive.0 By 1
   filesys = FileType(drive.x)
   If filesys = 'HPFS' | filesys = 'FAT' Then
      drive_string = drive_string || ,
                     Strip(drive.x, 'T', ':') || ,
                     ','
End
drive_string = Strip(drive_string, 'T', ',')

/***************************************************/
/* If we're maintaining the log file, do so now.   */
/***************************************************/
If logswitch Then
   Do
      rc = SysFileTree(bmpath || 'BACKMAST.OLD', 'file', 'F')
      If file.0 <> 0 Then
         Call SysFileDelete bmpath || 'BACKMAST.OLD'
      rc = SysFileTree(bmpath || 'BACKMAST.LOG', 'file', 'F')
      If file.0 <> 0 Then
         'REN' bmpath || 'BACKMAST.LOG' bmpath || 'BACKMAST.OLD'
   End


/***************************************************/
/* Perform a full backup of all FAT or HPFS drives.*/
/***************************************************/
'START /MIN BACKMAST /D:' || ,
                     drive_string ,
                     '/BF:"FULL:' rundate || ,
                     '" /AV:' || av

/***************************************************/
/* All done, end processing.                       */
/***************************************************/
If rxload Then
   Call SysDropFuncs  /* Drop only if we loaded */
Exit
