/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.PCDManager;
import com.sun.tools.javamake.PublicExceptions;
import com.sun.tools.javamake.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;
    private static ClassPath projectClassPath;
    private static ClassPath standardClassPath;
    private static ClassPath bootClassPath;
    private static ClassPath extClassPath;
    private static String compilerUserClassPath;
    private static String standardClassPathStr;
    private static String projectClassPathStr;
    private static String bootClassPathStr;
    private static String extDirsStr;
    private static Hashtable classCache;

    public static void setClassPath(String string) throws PublicExceptions.InvalidCmdOptionException {
        standardClassPathStr = string;
        standardClassPath = new ClassPath(string, false);
    }

    public static void setProjectClassPath(String string) throws PublicExceptions.InvalidCmdOptionException {
        projectClassPathStr = string;
        projectClassPath = new ClassPath(string, true);
    }

    public static void setBootClassPath(String string) throws PublicExceptions.InvalidCmdOptionException {
        bootClassPathStr = string;
        bootClassPath = new ClassPath(string, false);
    }

    public static void setExtDirs(String string) throws PublicExceptions.InvalidCmdOptionException {
        extDirsStr = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (stringArray == null) continue;
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(file + File.separator + stringArray[n]);
                ++n;
            }
        }
        extClassPath = new ClassPath(arrayList, false);
    }

    public static void initializeAllClassPaths() {
        compilerUserClassPath = standardClassPathStr == null && projectClassPathStr == null ? "." : (standardClassPathStr == null ? projectClassPathStr : (projectClassPathStr == null ? standardClassPathStr : standardClassPathStr + File.pathSeparator + projectClassPathStr));
        if (standardClassPathStr == null) {
            try {
                standardClassPath = new ClassPath(".", false);
            }
            catch (PublicExceptions.InvalidCmdOptionException invalidCmdOptionException) {
                // empty catch block
            }
        }
        if (projectClassPathStr == null) {
            projectClassPath = new ClassPath();
        }
        if (bootClassPathStr == null) {
            try {
                bootClassPath = new ClassPath(System.getProperty("sun.boot.class.path"), false);
            }
            catch (PublicExceptions.InvalidCmdOptionException invalidCmdOptionException) {
                // empty catch block
            }
        }
        if (extDirsStr == null) {
            try {
                ClassPath.setExtDirs(System.getProperty("java.ext.dirs"));
            }
            catch (PublicExceptions.InvalidCmdOptionException invalidCmdOptionException) {
                // empty catch block
            }
            extDirsStr = null;
        }
    }

    public static String getCompilerUserClassPath() {
        return compilerUserClassPath;
    }

    public static String getCompilerBootClassPath() {
        return bootClassPathStr;
    }

    public static String getCompilerExtDirs() {
        return extDirsStr;
    }

    public static void getSuperclasses(String string, Collection collection, PCDManager pCDManager) {
        int n = 0;
        while (string != "java/lang/Object") {
            ClassInfo classInfo = ClassPath.getClassInfoForName(string, pCDManager);
            if (classInfo == null) {
                return;
            }
            if (n++ > 0) {
                collection.add(classInfo.name);
            }
            string = classInfo.superName;
        }
    }

    public static void addAllImplementedInterfaceNames(String string, Set set, PCDManager pCDManager) {
        String string2;
        if (string == "java/lang/Object") {
            return;
        }
        ClassInfo classInfo = ClassPath.getClassInfoForName(string, pCDManager);
        if (classInfo == null) {
            return;
        }
        String[] stringArray = classInfo.interfaces;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                set.add(stringArray[n]);
                ClassPath.addAllImplementedInterfaceNames(stringArray[n], set, pCDManager);
                ++n;
            }
        }
        if ((string2 = classInfo.superName) != null) {
            ClassPath.addAllImplementedInterfaceNames(string2, set, pCDManager);
        }
    }

    public static String[] getProjectJars() {
        if (projectClassPath == null || projectClassPath.isEmpty()) {
            return null;
        }
        PathEntry[] pathEntryArray = ClassPath.projectClassPath.paths;
        String[] stringArray = new String[pathEntryArray.length];
        int n = 0;
        while (n < pathEntryArray.length) {
            stringArray[n] = pathEntryArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public static ClassInfo getClassInfoForName(String string, PCDManager pCDManager) {
        ClassInfo classInfo = (ClassInfo)classCache.get(string);
        if (classInfo != null) {
            return classInfo;
        }
        byte[] byArray = bootClassPath.getBytesForClass(string);
        if (byArray == null) {
            byArray = extClassPath.getBytesForClass(string);
        }
        if (byArray == null) {
            byArray = standardClassPath.getBytesForClass(string);
        }
        if (byArray == null) {
            byArray = projectClassPath.getBytesForClass(string);
        }
        if (byArray == null) {
            return null;
        }
        classInfo = new ClassInfo(byArray, pCDManager, string);
        classCache.put(string, classInfo);
        return classInfo;
    }

    public static ClassLoader getClassLoaderForPath(String string) throws Exception {
        boolean bl = System.getProperty("os.name").startsWith("Win");
        ClassPath classPath = new ClassPath(string, false);
        PathEntry[] pathEntryArray = classPath.paths;
        URL[] uRLArray = new URL[pathEntryArray.length];
        int n = 0;
        while (n < pathEntryArray.length) {
            String string2 = pathEntryArray[n].toString();
            if (!string2.startsWith("file://") && !string2.startsWith("http://")) {
                if (bl && string2.charAt(1) == ':') {
                    string2 = "/" + string2;
                }
                string2 = "file://" + string2;
            }
            if (!(string2.endsWith(".jar") || string2.endsWith(".zip") || string2.endsWith(File.separator))) {
                string2 = string2 + File.separator;
            }
            uRLArray[n] = new URL(string2);
            ++n;
        }
        return new URLClassLoader(uRLArray);
    }

    private ClassPath() {
        this.paths = new PathEntry[0];
    }

    private ClassPath(String string, boolean bl) throws PublicExceptions.InvalidCmdOptionException {
        if (string == null) {
            throw new PublicExceptions.InvalidCmdOptionException("null argument");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        this.init(arrayList, bl);
    }

    private ClassPath(ArrayList arrayList, boolean bl) throws PublicExceptions.InvalidCmdOptionException {
        this.init(arrayList, bl);
    }

    private void init(ArrayList arrayList, boolean bl) throws PublicExceptions.InvalidCmdOptionException {
        if (arrayList == null) {
            throw new PublicExceptions.InvalidCmdOptionException("null argument");
        }
        ArrayList<PathEntry> arrayList2 = new ArrayList<PathEntry>(arrayList.size());
        int n = 0;
        while (n < arrayList.size()) {
            block11: {
                String string = (String)arrayList.get(n);
                if (!string.equals("")) {
                    File file = new File(string);
                    try {
                        if (file.exists() && file.canRead()) {
                            if (file.isDirectory()) {
                                if (bl) {
                                    throw new PublicExceptions.InvalidCmdOptionException("directories are not allowed on this class path: " + string);
                                }
                                arrayList2.add(new Dir(file));
                            } else {
                                arrayList2.add(new Zip(new ZipFile(file)));
                            }
                        } else if (bl) {
                            throw new IOException("file does not exist");
                        }
                    }
                    catch (IOException iOException) {
                        if (!bl) break block11;
                        throw new PublicExceptions.InvalidCmdOptionException("error initializing class path component " + string + ": " + iOException.getMessage());
                    }
                }
            }
            ++n;
        }
        this.paths = new PathEntry[arrayList2.size()];
        arrayList2.toArray(this.paths);
    }

    private boolean isEmpty() {
        return this.paths.length == 0;
    }

    private byte[] getBytesForClass(String string) {
        String string2 = string + ".class";
        int n = 0;
        while (n < this.paths.length) {
            byte[] byArray = this.paths[n].getBytesForClassFile(string2);
            if (byArray != null) {
                return byArray;
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        if (this.paths == null) {
            return "NULL";
        }
        String string = "";
        int n = 0;
        while (n < this.paths.length) {
            string = string + this.paths[n].toString();
            ++n;
        }
        return string;
    }

    static {
        classCache = new Hashtable();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile zipFile) {
            this.zip = zipFile;
        }

        byte[] getBytesForClassFile(String string) {
            ZipEntry zipEntry = this.zip.getEntry(string);
            if (zipEntry != null) {
                return Utils.readZipEntryIntoBuffer(this.zip, zipEntry);
            }
            return null;
        }

        public String toString() {
            return this.zip.getName();
        }
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(File file) throws IOException {
            this.dir = file.getCanonicalPath();
        }

        byte[] getBytesForClassFile(String string) {
            File file = new File(this.dir + File.separatorChar + string);
            if (file.exists()) {
                return Utils.readFileIntoBuffer(file);
            }
            return null;
        }

        public String toString() {
            return this.dir.toString();
        }
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract byte[] getBytesForClassFile(String var1);

        public abstract String toString();
    }
}

