/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.ClassFileReader;
import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.ClassPath;
import com.sun.tools.javamake.CompatibilityChecker;
import com.sun.tools.javamake.PCDContainer;
import com.sun.tools.javamake.PCDEntry;
import com.sun.tools.javamake.PrivateException;
import com.sun.tools.javamake.PublicExceptions;
import com.sun.tools.javamake.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.Adler32;

public class PCDManager {
    private PCDContainer pcdc;
    private Hashtable pcd;
    private String[] projectJavaAndJarFilesArray;
    private String[] addedJavaAndJarFilesArray;
    private String[] removedJavaAndJarFilesArray;
    private String[] updatedJavaAndJarFilesArray;
    private ArrayList newJavaFiles;
    private HashSet updatedJavaFiles;
    private HashSet recompiledJavaFiles;
    private HashSet updatedClasses;
    private HashSet allUpdatedClasses;
    private HashSet updatedAndCheckedClasses;
    private HashSet deletedClasses;
    private HashSet updatedJarFiles;
    private HashSet stableJarFiles;
    private HashSet newJarFiles;
    private HashSet deletedJarFiles;
    private String destDir;
    private boolean destDirSpecified;
    private ArrayList javacAddArgs;
    private Class compilerClass;
    private Method compileMethod;
    private String jcExecApp;
    private Object externalApp;
    private Method externalCompileSourceFilesMethod;
    private Adler32 checkSum;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private CompatibilityChecker cv;
    private ClassFileReader cfr;
    private boolean newProject = false;
    private static boolean backSlashFileSeparator = File.separatorChar != '/';
    static /* synthetic */ Class array$Ljava$lang$String;

    public PCDManager(PCDContainer pCDContainer, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string, ArrayList arrayList, boolean bl, boolean bl2) {
        this.pcdc = pCDContainer;
        if (pCDContainer.pcd == null) {
            this.pcd = new Hashtable();
            pCDContainer.pcd = this.pcd;
            this.newProject = true;
        } else {
            this.pcd = pCDContainer.pcd;
        }
        this.projectJavaAndJarFilesArray = stringArray;
        this.addedJavaAndJarFilesArray = stringArray2;
        this.removedJavaAndJarFilesArray = stringArray3;
        this.updatedJavaAndJarFilesArray = stringArray4;
        this.newJavaFiles = new ArrayList();
        this.updatedJavaFiles = new HashSet();
        this.recompiledJavaFiles = new HashSet();
        this.updatedAndCheckedClasses = new HashSet();
        this.deletedClasses = new HashSet();
        this.allUpdatedClasses = new HashSet();
        this.updatedJarFiles = new HashSet();
        this.stableJarFiles = new HashSet();
        this.newJarFiles = new HashSet();
        this.deletedJarFiles = new HashSet();
        this.initializeDestDir(string);
        this.javacAddArgs = arrayList;
        this.checkSum = new Adler32();
        this.cv = new CompatibilityChecker(this, bl, bl2);
        this.cfr = new ClassFileReader();
    }

    public Enumeration entriesEnum() {
        return this.pcd.elements();
    }

    public ClassFileReader getClassFileReader() {
        return this.cfr;
    }

    public ClassInfo getClassInfoForName(int n, String string) {
        PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
        if (pCDEntry != null) {
            return this.getClassInfoForPCDEntry(n, pCDEntry);
        }
        return null;
    }

    public boolean isProjectClass(int n, String string) {
        if (n == 0) {
            return this.pcd.containsKey(string);
        }
        PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
        return pCDEntry != null && pCDEntry.checkResult != 3;
    }

    public ClassInfo getClassInfoForPCDEntry(int n, PCDEntry pCDEntry) {
        if (n == 0) {
            return pCDEntry.oldClassInfo;
        }
        ClassInfo classInfo = pCDEntry.newClassInfo;
        if (classInfo == null) {
            byte[] byArray = null;
            String string = null;
            if (pCDEntry.javaFileFullPath.endsWith(".java")) {
                File file = Utils.checkFileForName(pCDEntry.classFileFullPath);
                if (file == null) {
                    return null;
                }
                byArray = Utils.readFileIntoBuffer(file);
                string = pCDEntry.classFileFullPath;
            } else {
                try {
                    JarFile jarFile = new JarFile(pCDEntry.javaFileFullPath);
                    JarEntry jarEntry = jarFile.getJarEntry(pCDEntry.className + ".class");
                    if (jarEntry == null) {
                        return null;
                    }
                    byArray = Utils.readZipEntryIntoBuffer(jarFile, jarEntry);
                }
                catch (IOException iOException) {
                    throw new PrivateException(iOException);
                }
            }
            pCDEntry.newClassInfo = classInfo = new ClassInfo(byArray, n, this, string);
        }
        return classInfo;
    }

    public String classAlreadyRecompiledOrUncompileable(String string) {
        PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
        if (pCDEntry == null) {
            Enumeration enumeration = this.pcd.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(string2);
                if (pCDEntry2.className != string) continue;
                System.out.println("ERROR: inconsistent entry: key = " + string2 + ", name in entry = " + pCDEntry2.className);
            }
            throw this.internalException(string + " not in project when it should be");
        }
        if (pCDEntry.checkResult == 3) {
            return "";
        }
        if (pCDEntry.javaFileFullPath.endsWith(".jar")) {
            return pCDEntry.javaFileFullPath;
        }
        return this.recompiledJavaFiles.contains(pCDEntry.javaFileFullPath) ? "" : null;
    }

    public void initializeCompiler(String string, String string2, String string3, String string4, Object object, Method method) {
        Object object2;
        ClassPath.initializeAllClassPaths();
        if (object != null) {
            this.externalApp = object;
            this.externalCompileSourceFilesMethod = method;
            return;
        }
        if (string != null) {
            this.jcExecApp = string;
            return;
        }
        if (string2 == null) {
            object2 = System.getProperty("java.home");
            if (((String)object2).endsWith(File.separator + "jre") || ((String)object2).endsWith(File.separator + "bin")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 4);
            }
            string2 = (String)object2 + "/lib/tools.jar";
        }
        object2 = null;
        try {
            object2 = ClassPath.getClassLoaderForPath(string2);
        }
        catch (Exception exception) {
            throw this.compilerInteractionException("error opening compiler path", exception, 0);
        }
        if (string3 == null) {
            string3 = "com.sun.tools.javac.Main";
        }
        if (string4 == null) {
            string4 = "compile";
        }
        try {
            this.compilerClass = ((ClassLoader)object2).loadClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.compilerInteractionException("error loading compiler main class com.sun.tools.javac.Main", classNotFoundException, 0);
        }
        Class[] classArray = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = PCDManager.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        try {
            this.compileMethod = this.compilerClass.getMethod(string4, classArray);
        }
        catch (Exception exception) {
            throw this.compilerInteractionException("error getting method com.sun.tools.javac.Main.compile(String args[])", exception, 0);
        }
    }

    public void run() {
        Utils.startTiming(2);
        this.synchronizeProjectFilesAndPCD();
        Utils.stopAndPrintTiming("Synchro", 2);
        Utils.printTiming("of which synchro check file", 3);
        Utils.startTiming(4);
        this.findUpdatedJavaAndJarFiles();
        Utils.stopAndPrintTiming("findUpdatedJavaAndJarFiles", 4);
        Utils.printTiming("of which classFileObsoleteOrDeleted", 5);
        this.projectJavaAndJarFilesArray = null;
        this.updatedClasses = new HashSet();
        this.dealWithClassesInUpdatedJarFiles();
        int n = 0;
        int n2 = 0;
        while (n == 0 || this.updatedJavaFiles.size() != 0 || this.newJavaFiles.size() != 0) {
            if (this.updatedJavaFiles.size() > 0 || this.newJavaFiles.size() > 0) {
                Utils.startTiming(6);
                int n3 = this.recompileUpdatedJavaFiles();
                Utils.stopAndPrintTiming("Compile", 6);
                if (n3 != 0) {
                    n2 = n3;
                }
            }
            Utils.startTiming(12);
            if (n++ == 0 && n2 == 0) {
                this.findClassFilesForNewJavaAndJarFiles();
                this.dealWithNestedClassesForUpdatedJavaFiles();
            }
            Utils.stopAndPrintTiming("Entering new classes in PDB", 12);
            this.updatedJavaFiles.clear();
            this.newJavaFiles.clear();
            Utils.startTiming(7);
            this.findUpdatedClasses();
            Utils.stopAndPrintTiming("Find updated classes", 7);
            Utils.startTiming(8);
            this.checkDeletedClasses();
            this.checkUpdatedClasses();
            Utils.stopAndPrintTiming("Check updated classes", 8);
            this.updatedClasses = new HashSet();
        }
        Utils.startTiming(9);
        this.updateClassFilesInfoInPCD(n2);
        this.pcdc.save();
        Utils.stopAndPrintTiming("PDB write", 9);
        if (n2 != 0) {
            throw this.compilerInteractionException("compilation error(s)", null, n2);
        }
    }

    public String[] getAllUpdatedClassesAsStringArray() {
        String[] stringArray = new String[this.allUpdatedClasses.size()];
        int n = 0;
        Iterator iterator = this.allUpdatedClasses.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ((String)iterator.next()).replace('/', '.');
        }
        return stringArray;
    }

    private void synchronizeProjectFilesAndPCD() {
        if (this.projectJavaAndJarFilesArray != null) {
            Object object;
            Object object2;
            Object object3;
            HashSet<String> hashSet = new HashSet<String>(this.pcd.size() * 3 / 2);
            Enumeration enumeration = this.entriesEnum();
            while (enumeration.hasMoreElements()) {
                hashSet.add(((PCDEntry)enumeration.nextElement()).javaFileFullPath);
            }
            HashSet<Object> hashSet2 = new HashSet<Object>(this.projectJavaAndJarFilesArray.length * 3 / 2);
            int n = 0;
            while (n < this.projectJavaAndJarFilesArray.length) {
                object3 = this.projectJavaAndJarFilesArray[n];
                Utils.startTiming(10);
                object2 = Utils.checkFileForName((String)object3);
                Utils.stopAndAddTiming(10, 3);
                if (object2 == null) {
                    throw new PrivateException(new FileNotFoundException("specified source file " + (String)object3 + " not found."));
                }
                object = ((File)object2).getAbsolutePath();
                if (backSlashFileSeparator) {
                    object = Utils.convertDriveLetterToLowerCase((String)object);
                }
                hashSet2.add(object);
                if (!hashSet.contains(object)) {
                    if (((String)object).endsWith(".java")) {
                        this.newJavaFiles.add(object);
                    } else if (((String)object).endsWith(".jar")) {
                        this.newJarFiles.add(object);
                    } else {
                        throw new PrivateException(new PublicExceptions.InvalidSourceFileExtensionException("specified source file " + (String)object3 + " has an invalid extension (not .java or .jar)."));
                    }
                }
                ++n;
            }
            object3 = this.pcd.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = (PCDEntry)this.pcd.get(object2);
                ((PCDEntry)object).oldClassInfo.restorePCDM(this);
                if (hashSet2.contains(((PCDEntry)object).javaFileFullPath)) continue;
                this.deletedClasses.add(object2);
                if (((PCDEntry)object).javaFileFullPath.endsWith(".jar")) {
                    this.deletedJarFiles.add(((PCDEntry)object).javaFileFullPath);
                    continue;
                }
                this.initializeClassFileFullPath((PCDEntry)object);
                new File(((PCDEntry)object).classFileFullPath).delete();
            }
        } else {
            String string;
            if (this.addedJavaAndJarFilesArray != null) {
                int n = 0;
                while (n < this.addedJavaAndJarFilesArray.length) {
                    String string2 = this.addedJavaAndJarFilesArray[n].intern();
                    if (string2.endsWith(".java")) {
                        this.newJavaFiles.add(string2);
                    } else if (string2.endsWith(".jar")) {
                        this.newJarFiles.add(string2);
                    } else {
                        throw new PrivateException(new PublicExceptions.InvalidSourceFileExtensionException("specified source file " + string2 + " has an invalid extension (not .java or .jar)."));
                    }
                    ++n;
                }
            }
            HashSet<String> hashSet = null;
            if (this.removedJavaAndJarFilesArray != null) {
                hashSet = new HashSet<String>();
                int n = 0;
                while (n < this.removedJavaAndJarFilesArray.length) {
                    string = this.removedJavaAndJarFilesArray[n].intern();
                    hashSet.add(string);
                    if (string.endsWith(".jar")) {
                        this.deletedJarFiles.add(string);
                    }
                    ++n;
                }
            }
            Enumeration enumeration = this.pcd.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
                pCDEntry.oldClassInfo.restorePCDM(this);
                if (hashSet == null || !hashSet.contains(pCDEntry.javaFileFullPath)) continue;
                this.deletedClasses.add(string);
                if (pCDEntry.javaFileFullPath.endsWith(".jar")) continue;
                this.initializeClassFileFullPath(pCDEntry);
                new File(pCDEntry.classFileFullPath).delete();
            }
        }
    }

    private void updateClassFilesInfoInPCD(int n) {
        PCDEntry pCDEntry;
        Object object;
        Iterator iterator;
        if (n != 0) {
            iterator = this.updatedAndCheckedClasses.iterator();
            while (iterator.hasNext()) {
                object = (PCDEntry)this.pcd.get((String)iterator.next());
                if (((PCDEntry)object).checkResult != 3 || ((PCDEntry)object).oldClassInfo.directlyEnclosingClass == "") continue;
                pCDEntry = (PCDEntry)this.pcd.get(((PCDEntry)object).oldClassInfo.directlyEnclosingClass);
                pCDEntry.checkResult = 2;
            }
        }
        iterator = this.updatedAndCheckedClasses.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            pCDEntry = (PCDEntry)this.pcd.get(object);
            if (pCDEntry.checkResult == 0) continue;
            if (pCDEntry.checkResult == 3) {
                if (n != 0) continue;
                this.pcd.remove(object);
                continue;
            }
            if (pCDEntry.checkResult != 1 && pCDEntry.checkResult != 4 && (pCDEntry.checkResult != 2 || n != 0)) continue;
            if (pCDEntry.newClassInfo == null) {
                Utils.printWarningMessage("Warning: internal information inconsistency detected during pdb updating");
                Utils.printWarningMessage("Please report this problem to Mikhail.Dmitriev@sun.com");
                Utils.printWarningMessage("Class name: " + (String)object);
                if (pCDEntry.checkResult != 4) continue;
                this.pcd.remove(object);
            }
            pCDEntry.oldClassFileLastModified = pCDEntry.newClassFileLastModified;
            pCDEntry.oldClassFileFingerprint = pCDEntry.newClassFileFingerprint;
            pCDEntry.oldClassInfo = pCDEntry.newClassInfo;
        }
    }

    private void findUpdatedJavaAndJarFiles() {
        boolean bl = this.projectJavaAndJarFilesArray != null;
        Enumeration enumeration = this.entriesEnum();
        while (enumeration.hasMoreElements()) {
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            if (this.deletedClasses.contains(pCDEntry.className)) continue;
            if (pCDEntry.javaFileFullPath.endsWith(".java")) {
                this.initializeClassFileFullPath(pCDEntry);
                if (bl) {
                    Utils.startTiming(11);
                    if (this.classFileObsoleteOrDeleted(pCDEntry)) {
                        this.updatedJavaFiles.add(pCDEntry.javaFileFullPath);
                    }
                    Utils.stopAndAddTiming(11, 5);
                }
                pCDEntry.checked = true;
                continue;
            }
            if (this.projectJavaAndJarFilesArray == null) continue;
            boolean bl2 = pCDEntry.checked = !this.checkJarFileForUpdate(pCDEntry);
        }
        if (!bl && this.updatedJavaAndJarFilesArray != null) {
            int n = 0;
            while (n < this.updatedJavaAndJarFilesArray.length) {
                if (this.updatedJavaAndJarFilesArray[n].endsWith(".java")) {
                    this.updatedJavaFiles.add(this.updatedJavaAndJarFilesArray[n]);
                } else {
                    this.updatedJarFiles.add(this.updatedJavaAndJarFilesArray[n]);
                }
                ++n;
            }
        }
    }

    private boolean classFileObsoleteOrDeleted(PCDEntry pCDEntry) {
        File file = Utils.checkFileForName(pCDEntry.classFileFullPath);
        if (file == null || !file.exists()) {
            return true;
        }
        File file2 = new File(pCDEntry.javaFileFullPath);
        return file.lastModified() < file2.lastModified();
    }

    private boolean checkJarFileForUpdate(PCDEntry pCDEntry) {
        String string = pCDEntry.javaFileFullPath;
        if (this.stableJarFiles.contains(string)) {
            return false;
        }
        if (this.updatedJarFiles.contains(string) || this.newJarFiles.contains(string) || this.deletedJarFiles.contains(string)) {
            return true;
        }
        File file = new File(string);
        if (pCDEntry.oldClassFileLastModified != file.lastModified()) {
            this.updatedJarFiles.add(string);
            return true;
        }
        this.stableJarFiles.add(string);
        return false;
    }

    public int recompileUpdatedJavaFiles() {
        if (this.externalApp != null) {
            return this.recompileUpdatedJavaFilesUsingExternalMethod();
        }
        return this.recompileUpdatedJavaFilesOurselves();
    }

    private int recompileUpdatedJavaFilesOurselves() {
        Object[] objectArray;
        String string;
        int n = this.updatedJavaFiles.size() + this.newJavaFiles.size();
        int n2 = this.javacAddArgs.size();
        int n3 = n2 + n + 2;
        String string2 = ClassPath.getCompilerBootClassPath();
        if (string2 != null) {
            n3 += 2;
        }
        if ((string = ClassPath.getCompilerExtDirs()) != null) {
            n3 += 2;
        }
        if (this.jcExecApp != null) {
            ++n3;
        }
        String[] stringArray = new String[n3];
        int n4 = 0;
        if (this.jcExecApp != null) {
            stringArray[n4++] = this.jcExecApp;
        }
        int n5 = 0;
        while (n5 < n2) {
            stringArray[n4++] = (String)this.javacAddArgs.get(n5);
            ++n5;
        }
        stringArray[n4++] = "-classpath";
        stringArray[n4++] = ClassPath.getCompilerUserClassPath();
        if (string2 != null) {
            stringArray[n4++] = "-bootclasspath";
            stringArray[n4++] = string2;
        }
        if (string != null) {
            stringArray[n4++] = "-extdirs";
            stringArray[n4++] = string;
        }
        if (!this.newProject) {
            Utils.printInfoMessage("Recompiling source files:");
        }
        Iterator iterator = this.updatedJavaFiles.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!this.newProject) {
                Utils.printInfoMessage(string3);
            }
            int n6 = n4++;
            String string4 = string3;
            stringArray[n6] = string4;
            this.recompiledJavaFiles.add(string4);
        }
        int n7 = 0;
        while (n7 < this.newJavaFiles.size()) {
            objectArray = (String)this.newJavaFiles.get(n7);
            if (!this.newProject) {
                Utils.printInfoMessage((String)objectArray);
            }
            stringArray[n4++] = objectArray;
            this.recompiledJavaFiles.add(objectArray);
            ++n7;
        }
        if (this.jcExecApp == null) {
            objectArray = new Object[]{stringArray};
            try {
                Object t = this.compilerClass.newInstance();
                Integer n8 = (Integer)this.compileMethod.invoke(t, objectArray);
                return n8;
            }
            catch (Exception exception) {
                throw this.compilerInteractionException("exception thrown when trying to invoke the compiler method", exception, 0);
            }
        }
        int n9 = 0;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getErrorStream();
            InputStream inputStream2 = process.getInputStream();
            boolean bl = false;
            while (!bl) {
                try {
                    n9 = process.exitValue();
                    bl = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Utils.delay(100);
                }
                try {
                    Utils.readAndPrintBytesFromStream(inputStream, System.err);
                    Utils.readAndPrintBytesFromStream(inputStream2, System.out);
                }
                catch (IOException iOException) {
                    throw this.compilerInteractionException("I/O error when reading the compiler application output", iOException, n9);
                }
            }
            return n9;
        }
        catch (IOException iOException) {
            throw this.compilerInteractionException("I/O error when trying to invoke the compiler application", iOException, n9);
        }
    }

    private int recompileUpdatedJavaFilesUsingExternalMethod() {
        int n = this.updatedJavaFiles.size() + this.newJavaFiles.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        Iterator iterator = this.updatedJavaFiles.iterator();
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            this.recompiledJavaFiles.add(stringArray[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.newJavaFiles.size()) {
            int n4 = n2++;
            String string = (String)this.newJavaFiles.get(n3);
            stringArray[n4] = string;
            this.recompiledJavaFiles.add(string);
            ++n3;
        }
        try {
            Integer n5 = (Integer)this.externalCompileSourceFilesMethod.invoke(this.externalApp, new Object[]{stringArray});
            return n5;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.compilerInteractionException("compiler method is not accessible", illegalAccessException, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.compilerInteractionException("illegal arguments passed to compiler method", illegalArgumentException, 0);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.compilerInteractionException("exception when executing the compiler method", invocationTargetException, 0);
        }
    }

    private void findClassFilesForNewJavaAndJarFiles() {
        Object object;
        Object object2;
        int n = 0;
        while (n < this.newJavaFiles.size()) {
            object2 = (String)this.newJavaFiles.get(n);
            object = this.findClassFileOnFilesystem((String)object2, null, null);
            if (object != null) {
                if (((PCDEntry)object).checkResult == 4) {
                    this.findAndUpdateAllNestedClassesForClass((PCDEntry)object, false);
                } else {
                    this.findAndUpdateAllNestedClassesForClass((PCDEntry)object, true);
                }
            }
            ++n;
        }
        object2 = this.newJarFiles.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.processAllClassesFromJarFile((String)object);
        }
    }

    private PCDEntry findClassFileOnFilesystem(String string, PCDEntry pCDEntry, String string2) {
        String string3;
        String string4;
        String string5 = null;
        String string6 = null;
        File file = null;
        if (pCDEntry == null) {
            string6 = string.substring(0, string.length() - 5);
            if (this.destDirSpecified) {
                while (file == null) {
                    string5 = this.destDir + string6 + ".class";
                    file = Utils.checkFileForName(string5);
                    if (file != null) continue;
                    int n = string6.indexOf(File.separatorChar);
                    if (n == -1) {
                        Utils.printWarningMessage("Warning: unable to find .class file corresponding to source " + string);
                        return null;
                    }
                    string6 = string6.substring(n + 1);
                }
            } else {
                string5 = string6 + ".class";
                file = Utils.checkFileForName(string5);
                if (file == null) {
                    Utils.printWarningMessage("Warning: unable to find .class file corresponding to source " + string);
                    return null;
                }
            }
        } else {
            string5 = Utils.getClassFileFullPathForNestedClass(pCDEntry.classFileFullPath, string2);
            file = Utils.checkFileForName(string5);
            if (file == null) {
                Utils.printWarningMessage("Warning: unable to find .class file corresponding to nested class " + string2);
                return null;
            }
            string6 = string2;
        }
        if (backSlashFileSeparator) {
            string6 = string6.replace(File.separatorChar, '/');
        }
        byte[] byArray = Utils.readFileIntoBuffer(file);
        ClassInfo classInfo = new ClassInfo(byArray, 1, this, string5);
        if (!(pCDEntry == null || classInfo.directlyEnclosingClass == pCDEntry.newClassInfo.name || (string4 = pCDEntry.newClassInfo.name).startsWith((string3 = classInfo.directlyEnclosingClass) + "$") && Character.isDigit(string4.charAt(string3.length() + 1)))) {
            throw new PrivateException(new PublicExceptions.ClassFileParseException("Enclosing class names for class " + classInfo.name + " don't match:\n" + classInfo.directlyEnclosingClass + " and " + pCDEntry.newClassInfo.name));
        }
        if (this.destDirSpecified) {
            if (!string6.equals(classInfo.name)) {
                throw new PrivateException(new PublicExceptions.ClassNameMismatchException("Error: deduced class name is different from the real one for source " + string + "\n" + string6 + " and " + classInfo.name));
            }
        } else {
            string6 = classInfo.name;
        }
        if (pCDEntry != null) {
            string = pCDEntry.javaFileFullPath;
        }
        long l = file.lastModified();
        long l2 = this.computeFP(byArray);
        if (this.pcd.containsKey(string6)) {
            PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(string6);
            if (pCDEntry2.checked) {
                throw new PrivateException(new PublicExceptions.DoubleEntryException("Two entries for class " + classInfo.name + " detected: " + pCDEntry2.javaFileFullPath + " and " + string));
            }
            pCDEntry2.javaFileFullPath = string;
            pCDEntry2.classFileFullPath = string5;
            pCDEntry2.newClassInfo = classInfo;
            if (this.deletedClasses.contains(string6)) {
                this.deletedClasses.remove(string6);
            }
            return pCDEntry2;
        }
        PCDEntry pCDEntry3 = new PCDEntry(string6, string, string5, l, l2, classInfo);
        pCDEntry3.checkResult = 4;
        this.updatedAndCheckedClasses.add(string6);
        this.pcd.put(string6, pCDEntry3);
        return pCDEntry3;
    }

    private void findAndUpdateAllNestedClassesForClass(PCDEntry pCDEntry, boolean bl) {
        ClassInfo classInfo = pCDEntry.newClassInfo;
        if (classInfo.nestedClasses == null) {
            return;
        }
        String[] stringArray = classInfo.nestedClasses;
        String string = pCDEntry.javaFileFullPath;
        String string2 = pCDEntry.classFileFullPath;
        boolean bl2 = string.endsWith(".java");
        int n = 0;
        while (n < stringArray.length) {
            block11: {
                PCDEntry pCDEntry2;
                block10: {
                    pCDEntry2 = (PCDEntry)this.pcd.get(stringArray[n]);
                    if (pCDEntry2 != null) break block10;
                    if (bl2) {
                        pCDEntry2 = this.findClassFileOnFilesystem(null, pCDEntry, stringArray[n]);
                    }
                    if (pCDEntry2 == null) break block11;
                }
                if (bl) {
                    if (this.deletedClasses.contains(stringArray[n])) {
                        this.deletedClasses.remove(stringArray[n]);
                    }
                    pCDEntry2.javaFileFullPath = string;
                    pCDEntry2.classFileFullPath = string.endsWith(".java") ? Utils.getClassFileFullPathForNestedClass(string2, stringArray[n]) : string;
                }
                if (pCDEntry2.newClassInfo == null) {
                    this.getClassInfoForPCDEntry(1, pCDEntry2);
                }
                pCDEntry2.newClassInfo.accessFlags = pCDEntry.newClassInfo.nestedClassAccessFlags[n];
                pCDEntry2.newClassInfo.isNonMemberNestedClass = pCDEntry.newClassInfo.nestedClassNonMember[n];
                if (!pCDEntry.javaFileFullPath.endsWith(".java")) {
                    return;
                }
                this.findAndUpdateAllNestedClassesForClass(pCDEntry2, bl);
            }
            ++n;
        }
    }

    private void dealWithNestedClassesForUpdatedJavaFiles() {
        if (this.updatedJavaFiles.size() == 0) {
            return;
        }
        ArrayList<PCDEntry> arrayList = new ArrayList<PCDEntry>();
        Enumeration enumeration = this.entriesEnum();
        while (enumeration.hasMoreElements()) {
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            if (pCDEntry.checkResult == 4 || !this.updatedJavaFiles.contains(pCDEntry.javaFileFullPath)) continue;
            ClassInfo classInfo = pCDEntry.oldClassInfo;
            ClassInfo classInfo2 = this.getClassInfoForPCDEntry(1, pCDEntry);
            if (classInfo2 == null || classInfo.nestedClasses == null && classInfo2.nestedClasses == null) continue;
            arrayList.add(pCDEntry);
        }
        this.dealWithNestedClassesForUpdatedPCDEntries(arrayList, false);
    }

    private void dealWithNestedClassesForUpdatedPCDEntries(ArrayList arrayList, boolean bl) {
        int n = 0;
        while (n < arrayList.size()) {
            int n2;
            PCDEntry pCDEntry = (PCDEntry)arrayList.get(n);
            ClassInfo classInfo = pCDEntry.oldClassInfo;
            ClassInfo classInfo2 = pCDEntry.newClassInfo;
            if (classInfo2.nestedClasses != null) {
                this.findAndUpdateAllNestedClassesForClass(pCDEntry, bl);
                if (classInfo.nestedClasses != null) {
                    n2 = 0;
                    while (n2 < classInfo.nestedClasses.length) {
                        boolean bl2 = false;
                        String string = classInfo.nestedClasses[n2];
                        int n3 = 0;
                        while (n3 < classInfo2.nestedClasses.length) {
                            if (string == classInfo2.nestedClasses[n3]) {
                                bl2 = true;
                                break;
                            }
                            ++n3;
                        }
                        if (!bl2) {
                            this.deletedClasses.add(string);
                        }
                        ++n2;
                    }
                }
            } else {
                n2 = 0;
                while (n2 < classInfo.nestedClasses.length) {
                    this.deletedClasses.add(classInfo.nestedClasses[n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void findUpdatedClasses() {
        Enumeration enumeration = this.entriesEnum();
        while (enumeration.hasMoreElements()) {
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            String string = pCDEntry.className;
            if (this.updatedAndCheckedClasses.contains(string) || this.deletedClasses.contains(string) || !pCDEntry.javaFileFullPath.endsWith(".java") || !this.classFileUpdated(pCDEntry)) continue;
            this.updatedClasses.add(string);
            this.allUpdatedClasses.add(string);
        }
    }

    private boolean classFileUpdated(PCDEntry pCDEntry) {
        File file = Utils.checkFileForName(pCDEntry.classFileFullPath);
        if (file == null) {
            return false;
        }
        long l = file.lastModified();
        if (l > pCDEntry.oldClassFileLastModified) {
            pCDEntry.newClassFileLastModified = l;
            long l2 = this.computeFP(file);
            if (l2 != pCDEntry.oldClassFileFingerprint) {
                pCDEntry.newClassFileFingerprint = l2;
                return true;
            }
        }
        return false;
    }

    private void checkUpdatedClasses() {
        Iterator iterator = this.updatedClasses.iterator();
        while (iterator.hasNext()) {
            int n;
            String[] stringArray;
            String string = (String)iterator.next();
            PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
            this.getClassInfoForPCDEntry(1, pCDEntry);
            if (pCDEntry.oldClassInfo.directlyEnclosingClass != "") {
                stringArray = this.getClassInfoForName(1, pCDEntry.oldClassInfo.directlyEnclosingClass);
                n = 0;
                while (n < stringArray.nestedClasses.length) {
                    if (string == stringArray.nestedClasses[n]) {
                        pCDEntry.newClassInfo.accessFlags = stringArray.nestedClassAccessFlags[n];
                        pCDEntry.newClassInfo.isNonMemberNestedClass = stringArray.nestedClassNonMember[n];
                        break;
                    }
                    ++n;
                }
            }
            if (!pCDEntry.oldClassInfo.isNonMemberNestedClass || !pCDEntry.newClassInfo.isNonMemberNestedClass) {
                Utils.printInfoMessage("Checking " + pCDEntry.className);
                pCDEntry.checkResult = this.cv.compareClassVersions(pCDEntry) ? 1 : 2;
                stringArray = this.cv.getAffectedClasses();
                if (stringArray != null) {
                    n = 0;
                    while (n < stringArray.length) {
                        PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(stringArray[n]);
                        this.updatedJavaFiles.add(pCDEntry2.javaFileFullPath);
                        ++n;
                    }
                }
            } else {
                pCDEntry.checkResult = 1;
            }
            this.updatedAndCheckedClasses.add(string);
        }
    }

    private void checkDeletedClasses() {
        Iterator iterator = this.deletedClasses.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string);
            if (pCDEntry == null) {
                Utils.printWarningMessage("Warning: internal information inconsistency when checking deleted classes");
                Utils.printWarningMessage("Please report this problem to Mikhail.Dmitriev@sun.com");
                Utils.printWarningMessage("Class name: " + string);
                continue;
            }
            ClassInfo classInfo = pCDEntry.oldClassInfo;
            if (!classInfo.isNonMemberNestedClass) {
                Utils.printInfoMessage("Checking deleted class " + classInfo.name);
                this.cv.checkDeletedClass(pCDEntry);
                String[] stringArray = this.cv.getAffectedClasses();
                if (stringArray != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        PCDEntry pCDEntry2 = (PCDEntry)this.pcd.get(stringArray[n]);
                        if (!this.deletedClasses.contains(pCDEntry2.className)) {
                            this.updatedJavaFiles.add(pCDEntry2.javaFileFullPath);
                        }
                        ++n;
                    }
                }
            }
            pCDEntry.checkResult = 3;
            this.updatedAndCheckedClasses.add(string);
        }
        this.deletedClasses.clear();
    }

    private void processAllClassesFromJarFile(String string) {
        Serializable serializable;
        JarFile jarFile = null;
        long l = 0L;
        try {
            serializable = new File(string);
            l = ((File)serializable).lastModified();
            jarFile = new JarFile(string);
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException);
        }
        serializable = new ArrayList();
        ArrayList<PCDEntry> arrayList = new ArrayList<PCDEntry>();
        ArrayList<PCDEntry> arrayList2 = new ArrayList<PCDEntry>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if (!string2.endsWith(".class")) continue;
            string2 = string2.substring(0, string2.length() - 6).intern();
            byte[] byArray = null;
            byArray = Utils.readZipEntryIntoBuffer(jarFile, jarEntry);
            long l2 = this.computeFP(byArray);
            PCDEntry pCDEntry = (PCDEntry)this.pcd.get(string2);
            if (pCDEntry != null) {
                if (pCDEntry.checked) {
                    throw new PrivateException(new PublicExceptions.DoubleEntryException("Two entries for class " + string2 + " detected: " + pCDEntry.javaFileFullPath + " and " + string));
                }
                pCDEntry.checked = true;
                pCDEntry.newClassFileLastModified = l;
                if (pCDEntry.oldClassFileFingerprint == l2 && pCDEntry.javaFileFullPath == string) {
                    pCDEntry.oldClassFileLastModified = l;
                    continue;
                }
                if (pCDEntry.oldClassFileFingerprint != l2) {
                    this.updatedClasses.add(string2);
                    this.allUpdatedClasses.add(string2);
                    pCDEntry.newClassFileLastModified = l;
                    pCDEntry.newClassFileFingerprint = l2;
                    pCDEntry.newClassInfo = new ClassInfo(byArray, 1, this, string2);
                    if (pCDEntry.oldClassInfo.nestedClasses != null || pCDEntry.newClassInfo.nestedClasses != null) {
                        arrayList.add(pCDEntry);
                    }
                } else {
                    pCDEntry.oldClassFileLastModified = l;
                }
                if (pCDEntry.javaFileFullPath != string) {
                    if (this.deletedClasses.contains(string2)) {
                        this.deletedClasses.remove(string2);
                    }
                    if (pCDEntry.oldClassInfo.nestedClasses != null) {
                        arrayList2.add(pCDEntry);
                        pCDEntry.newClassInfo = new ClassInfo(byArray, 1, this, string2);
                    }
                }
                pCDEntry.javaFileFullPath = string;
                continue;
            }
            ClassInfo classInfo = new ClassInfo(byArray, 1, this, string2);
            pCDEntry = new PCDEntry(string2, string, string, l, l2, classInfo);
            pCDEntry.checkResult = 4;
            this.updatedAndCheckedClasses.add(string2);
            this.pcd.put(string2, pCDEntry);
            if (pCDEntry.newClassInfo.nestedClasses == null) continue;
            ((ArrayList)serializable).add(pCDEntry);
        }
        this.dealWithNestedClassesForUpdatedPCDEntries(arrayList, false);
        this.dealWithNestedClassesForUpdatedPCDEntries(arrayList2, true);
        int n = 0;
        while (n < ((ArrayList)serializable).size()) {
            this.findAndUpdateAllNestedClassesForClass((PCDEntry)((ArrayList)serializable).get(n), false);
            ++n;
        }
    }

    private void dealWithClassesInUpdatedJarFiles() {
        if (this.updatedJarFiles.size() == 0) {
            return;
        }
        Iterator iterator = this.updatedJarFiles.iterator();
        while (iterator.hasNext()) {
            this.processAllClassesFromJarFile((String)iterator.next());
        }
        Enumeration enumeration = this.pcd.elements();
        while (enumeration.hasMoreElements()) {
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            if (!this.updatedJarFiles.contains(pCDEntry.javaFileFullPath) || pCDEntry.checked) continue;
            this.deletedClasses.add(pCDEntry.className);
        }
    }

    private void initializeDestDir(String string) {
        if (string != null && !string.equals("")) {
            File file = Utils.checkOrCreateDirForName(string);
            if (file == null) {
                throw new PrivateException(new IOException("specified directory " + string + " cannot be created."));
            }
            string = PCDManager.getCanonicalPath(file);
            if (!string.endsWith(File.separator)) {
                string = string + File.separatorChar;
            }
            this.destDir = string;
            this.destDirSpecified = true;
        } else {
            this.destDirSpecified = false;
        }
    }

    private void initializeClassFileFullPath(PCDEntry pCDEntry) {
        String string;
        if (this.destDirSpecified) {
            string = this.destDir + pCDEntry.className + ".class";
        } else {
            String string2;
            String string3 = pCDEntry.javaFileFullPath;
            int n = string3.lastIndexOf(File.separatorChar);
            if (n != -1) {
                string3 = string3.substring(0, n + 1);
            }
            if ((n = (string2 = pCDEntry.className).lastIndexOf(47)) != -1) {
                string2 = string2.substring(n + 1);
            }
            string = string3 + string2 + ".class";
        }
        if (backSlashFileSeparator) {
            string = string.replace('/', File.separatorChar);
        }
        pCDEntry.classFileFullPath = string;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath().intern();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException);
        }
    }

    private long computeFP(File file) {
        byte[] byArray = Utils.readFileIntoBuffer(file);
        return this.computeFP(byArray);
    }

    private long computeFP(byte[] byArray) {
        this.checkSum.reset();
        this.checkSum.update(byArray);
        return this.checkSum.getValue();
    }

    private PrivateException compilerInteractionException(String string, Exception exception, int n) {
        return new PrivateException(new PublicExceptions.CompilerInteractionException(string, exception, n));
    }

    private PrivateException internalException(String string) {
        return new PrivateException(new PublicExceptions.InternalException(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

