/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javamake;

import com.sun.tools.javamake.ClassInfo;
import com.sun.tools.javamake.PCDEntry;
import com.sun.tools.javamake.PCDManager;
import com.sun.tools.javamake.PrivateException;
import com.sun.tools.javamake.PublicExceptions;
import com.sun.tools.javamake.Utils;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RefClassFinder {
    private boolean failOnDependentJar;
    private boolean noWarnOnDependentJar;
    private String checkedClassName;
    private PCDManager pcdm;
    private Set affectedClassNames;
    private boolean checkedClassIsFromJar;

    public RefClassFinder(PCDManager pCDManager, boolean bl, boolean bl2) {
        this.pcdm = pCDManager;
        this.failOnDependentJar = bl;
        this.noWarnOnDependentJar = bl2;
    }

    public void initialize(String string, boolean bl) {
        this.checkedClassName = string;
        this.checkedClassIsFromJar = bl;
        this.affectedClassNames = new HashSet();
    }

    public String[] getAffectedClassNames() {
        int n = this.affectedClassNames.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Iterator iterator = this.affectedClassNames.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2++] = (String)iterator.next();
        }
        return stringArray;
    }

    public void findAllProjectClasses(ClassInfo classInfo, int n) {
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2;
            PCDEntry pCDEntry = (PCDEntry)enumeration.nextElement();
            if (pCDEntry.checkResult == 3 || pCDEntry.javaFileFullPath.endsWith(".jar") || (classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, pCDEntry)) == null || !this.memberAccessibleFrom(classInfo, n, classInfo2, true)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findReferencingClasses0(ClassInfo classInfo) {
        this.findReferencingClasses(classInfo, 0, false, null);
    }

    public void findReferencingClassesForDeletedClass(ClassInfo classInfo) {
        String string = classInfo.packageName;
        boolean bl = classInfo.isPublic();
        boolean bl2 = classInfo.isInterface();
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || !bl && string != classInfo2.packageName || !classInfo2.referencesClass(classInfo.name, bl2, 1)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findDiffPackageAndNotSubReferencingClasses1(ClassInfo classInfo) {
        String string = classInfo.packageName;
        String string2 = classInfo.directlyEnclosingClass;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || string == classInfo2.packageName || classInfo2.isSubclassOf(string2, false) || !classInfo2.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findReferencingClasses1(ClassInfo classInfo) {
        String string = classInfo.topLevelEnclosingClass;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || string == classInfo2.topLevelEnclosingClass || !classInfo2.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findThisPackageOrSubReferencingClasses1(ClassInfo classInfo) {
        String string = classInfo.directlyEnclosingClass;
        String string2 = classInfo.topLevelEnclosingClass;
        String string3 = classInfo.packageName;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || classInfo2.packageName != string3 && !classInfo2.isSubclassOf(string, false) || classInfo2.topLevelEnclosingClass == string2 || !classInfo2.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findThisPackageReferencingClasses1(ClassInfo classInfo) {
        String string = classInfo.topLevelEnclosingClass;
        String string2 = classInfo.packageName;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || classInfo2.packageName != string2 || string == classInfo2.topLevelEnclosingClass || !classInfo2.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findDiffPackageReferencingClasses1(ClassInfo classInfo) {
        String string = classInfo.packageName;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || classInfo2.packageName == string || !classInfo2.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findDiffPackageAndSubReferencingClasses1(ClassInfo classInfo) {
        String string = classInfo.packageName;
        String string2 = classInfo.directlyEnclosingClass;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || classInfo2.packageName == string || !classInfo2.isSubclassOf(string2, false) || !classInfo2.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    public void findReferencingClasses2(ClassInfo classInfo, ClassInfo classInfo2) {
        HashSet hashSet = new HashSet();
        this.findReferencingClasses(classInfo, 2, false, hashSet);
        HashSet hashSet2 = new HashSet();
        this.findReferencingClasses(classInfo2, 2, false, hashSet2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!hashSet2.contains(string)) continue;
            this.addToAffectedClassNames(string);
        }
    }

    public void findDirectSubclasses(ClassInfo classInfo) {
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n = 0;
        while (n < classInfoArray.length) {
            this.addToAffectedClassNames(classInfoArray[n].name);
            ++n;
        }
    }

    public void findDirectlyAndOtherwiseImplementingConcreteClasses(ClassInfo classInfo) {
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || classInfo2.isInterface()) continue;
            if (classInfo2.isAbstract()) {
                if (!classInfo2.implementsInterfaceDirectlyOrIndirectly(classInfo.name)) continue;
                this.findAllNearestConcreteSubclasses(classInfo2);
                continue;
            }
            if (!classInfo2.implementsIntfOrSubintfDirectly(classInfo.name)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    private void findAllNearestConcreteSubclasses(ClassInfo classInfo) {
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n = 0;
        while (n < classInfoArray.length) {
            if (classInfoArray[n].isAbstract()) {
                this.findAllNearestConcreteSubclasses(classInfoArray[n]);
            } else {
                this.addToAffectedClassNames(classInfoArray[n].name);
            }
            ++n;
        }
    }

    public void findAbstractSubtypesWithSameNameMethod(ClassInfo classInfo, String string, final String string2) {
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || !classInfo2.isInterface() && !classInfo2.isAbstract() || !classInfo2.implementsInterfaceDirectlyOrIndirectly(classInfo.name)) continue;
            this.addToAffectedClassNames(classInfo2.name);
            classInfo2.findExistingSameNameMethods(string, true, true, new ClassInfo.MethodHandler(){

                void handleMethod(ClassInfo classInfo, int n) {
                    String string = classInfo.methodSignatures[n];
                    if (string2 != string && Utils.sameParamNumber(string2, string)) {
                        RefClassFinder.this.findReferencingClassesForMethod(classInfo, n);
                    }
                }
            });
        }
    }

    public void findReferencingClassesForField(ClassInfo classInfo, int n) {
        this.findReferencingClassesForMember(classInfo, n, true, false, false);
    }

    public void findDiffPackageReferencingClassesForField(ClassInfo classInfo, int n) {
        this.findReferencingClassesForMember(classInfo, n, true, true, false);
    }

    public void findDiffPackageAndSubReferencingClassesForField(ClassInfo classInfo, int n) {
        this.findReferencingClassesForMember(classInfo, n, true, true, true);
    }

    public void findReferencingClassesForMethod(ClassInfo classInfo, int n) {
        this.findReferencingClassesForMember(classInfo, n, false, false, false);
    }

    public void findDiffPackageReferencingClassesForMethod(ClassInfo classInfo, int n) {
        this.findReferencingClassesForMember(classInfo, n, false, true, false);
    }

    public void findDiffPackageAndSubReferencingClassesForMethod(ClassInfo classInfo, int n) {
        this.findReferencingClassesForMember(classInfo, n, false, true, true);
    }

    public void findSubclassesReimplementingMethod(ClassInfo classInfo, int n) {
        this.findSubclassesReimplementingMethod(classInfo, classInfo, n);
    }

    private void findSubclassesReimplementingMethod(ClassInfo classInfo, ClassInfo classInfo2, int n) {
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n2 = 0;
        while (n2 < classInfoArray.length) {
            ClassInfo classInfo3 = classInfoArray[n2];
            if (classInfo3.declaresMethod(classInfo2, n)) {
                this.addToAffectedClassNames(classInfo3.name);
            } else {
                this.findSubclassesReimplementingMethod(classInfo3, classInfo2, n);
            }
            ++n2;
        }
    }

    public void findConcreteSubclassesNotOverridingAbstractMethod(ClassInfo classInfo, ClassInfo classInfo2, int n) {
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n2 = 0;
        while (n2 < classInfoArray.length) {
            ClassInfo classInfo3 = classInfoArray[n2];
            int n3 = classInfo3.getDeclaredMethodPos(classInfo2, n);
            if (n3 == -1) {
                if (!classInfo3.isAbstract()) {
                    this.addToAffectedClassNames(classInfo3.name);
                } else {
                    this.findConcreteSubclassesNotOverridingAbstractMethod(classInfo3, classInfo2, n);
                }
            } else if (Modifier.isAbstract(classInfo3.methodAccessFlags[n3])) {
                this.findConcreteSubclassesNotOverridingAbstractMethod(classInfo3, classInfo2, n);
            }
            ++n2;
        }
    }

    public void findRefsToMethodsThrowingException(ClassInfo classInfo) {
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null) continue;
            int n = -1;
            do {
                if ((n = classInfo2.hasMethodThrowingException(classInfo, n + 1)) == -1) continue;
                this.findReferencingClassesForMethod(classInfo2, n);
            } while (n != -1);
        }
    }

    public void findClassesDeclaringField(String string, String string2, boolean bl, String string3) {
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo == null || string3 != null && classInfo.packageName != string3 || !classInfo.declaresField(string, string2, bl)) continue;
            this.addToAffectedClassNames(classInfo.name);
        }
    }

    public void addToAffectedClassNames(String string) {
        String string2 = this.pcdm.classAlreadyRecompiledOrUncompileable(string);
        if (string2 == null) {
            this.affectedClassNames.add(string);
        } else if (string2 != "") {
            if (this.checkedClassIsFromJar || this.noWarnOnDependentJar) {
                return;
            }
            String string3 = "Class " + string + " is affected by a change to " + this.checkedClassName + ", but can't be recompiled, " + "since it is located in archive " + string2;
            if (this.failOnDependentJar) {
                throw new PrivateException(new PublicExceptions.JarDependsOnSourceException(string3));
            }
            Utils.printWarningMessage("Warning: " + string3);
        }
    }

    private void findReferencingClasses(ClassInfo classInfo, int n, boolean bl, HashSet hashSet) {
        String string = classInfo.packageName;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || bl && string == classInfo2.packageName || n != 2 && !this.classAccessibleFrom(classInfo, classInfo2) || !classInfo2.referencesClass(classInfo.name, classInfo.isInterface(), n)) continue;
            if (hashSet == null) {
                this.addToAffectedClassNames(classInfo2.name);
                continue;
            }
            hashSet.add(classInfo2.name);
        }
    }

    private void findReferencingClassesForMember(ClassInfo classInfo, int n, boolean bl, boolean bl2, boolean bl3) {
        String string = classInfo.name;
        String string2 = classInfo.packageName;
        Enumeration enumeration = this.pcdm.entriesEnum();
        while (enumeration.hasMoreElements()) {
            String string3;
            ClassInfo classInfo2 = this.pcdm.getClassInfoForPCDEntry(0, (PCDEntry)enumeration.nextElement());
            if (classInfo2 == null || (string3 = classInfo2.name).equals(string) || !this.memberAccessibleFrom(classInfo, n, classInfo2, bl) || bl2 && string2 == classInfo2.packageName || bl3 && !classInfo2.isSubclassOf(string, false)) continue;
            if (bl) {
                if (!classInfo2.referencesField(classInfo, n)) continue;
                this.addToAffectedClassNames(classInfo2.name);
                continue;
            }
            if (!classInfo2.referencesMethod(classInfo, n)) continue;
            this.addToAffectedClassNames(classInfo2.name);
        }
    }

    private boolean classAccessibleFrom(ClassInfo classInfo, ClassInfo classInfo2) {
        char c = classInfo.accessFlags;
        String string = classInfo.packageName;
        String string2 = classInfo2.packageName;
        if (Modifier.isPublic(c)) {
            return true;
        }
        return Modifier.isProtected(c) ? string == string2 || classInfo2.isSubclassOf(classInfo.directlyEnclosingClass, false) : (Modifier.isPrivate(c) ? classInfo.topLevelEnclosingClass == classInfo2.topLevelEnclosingClass : string == string2);
    }

    private boolean memberAccessibleFrom(ClassInfo classInfo, int n, ClassInfo classInfo2, boolean bl) {
        char c = classInfo.accessFlags;
        char c2 = bl ? classInfo.fieldAccessFlags[n] : classInfo.methodAccessFlags[n];
        String string = classInfo.packageName;
        String string2 = classInfo2.packageName;
        if (Modifier.isPublic(c)) {
            if (Modifier.isPublic(c2)) {
                return true;
            }
            if (Modifier.isProtected(c2) && (string == string2 || classInfo2.isSubclassOf(classInfo.name, false))) {
                return true;
            }
            if (Modifier.isPrivate(c2) ? classInfo.topLevelEnclosingClass == classInfo2.topLevelEnclosingClass : string == string2) {
                return true;
            }
        } else if (Modifier.isProtected(c)) {
            if (string != string2 && !classInfo2.isSubclassOf(classInfo.directlyEnclosingClass, false)) {
                return true;
            }
            if (Modifier.isPublic(c2) || Modifier.isProtected(c2)) {
                return true;
            }
            if (Modifier.isPrivate(c2) ? classInfo.topLevelEnclosingClass == classInfo2.topLevelEnclosingClass : string == string2) {
                return true;
            }
        } else if (Modifier.isPrivate(c)) {
            if (classInfo.topLevelEnclosingClass == classInfo2.topLevelEnclosingClass) {
                return true;
            }
        } else {
            if (string != string2) {
                return false;
            }
            if (Modifier.isPublic(c2) || Modifier.isProtected(c2)) {
                return true;
            }
            if (Modifier.isPrivate(c2)) {
                if (classInfo.topLevelEnclosingClass == classInfo2.topLevelEnclosingClass) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

