/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.cards.playingcards;

import com.slackandassociates.cards.BlankCard;
import com.slackandassociates.cards.BlankCardEnum;
import com.slackandassociates.cards.Card;
import com.slackandassociates.cards.CardEnum;
import com.slackandassociates.cards.CardInvalidEnumException;
import com.slackandassociates.cards.playingcards.PlayingCardEnum;

public class PlayingCard
implements Card {
    public static final int JPC_INVALID_RETURN = BlankCard.JC_INVALID_RETURN;
    public static final int JPC_RED_CARD = 0;
    public static final int JPC_BLACK_CARD = 1;
    public static final int JPC_CLUBS = 0;
    public static final int JPC_DIAMONDS = 1;
    public static final int JPC_HEARTS = 2;
    public static final int JPC_SPADES = 3;
    public static final int JPC_ACE = 1;
    public static final int JPC_TWO = 2;
    public static final int JPC_THREE = 3;
    public static final int JPC_FOUR = 4;
    public static final int JPC_FIVE = 5;
    public static final int JPC_SIX = 6;
    public static final int JPC_SEVEN = 7;
    public static final int JPC_EIGHT = 8;
    public static final int JPC_NINE = 9;
    public static final int JPC_TEN = 10;
    public static final int JPC_JACK = 11;
    public static final int JPC_QUEEN = 12;
    public static final int JPC_KING = 13;
    private CardEnum cardValue = BlankCardEnum.NO_CARD;
    private int compMode = 0;

    public PlayingCard() {
    }

    public PlayingCard(CardEnum cardEnum) {
        this.cardValue = cardEnum;
    }

    public CardEnum getCardValue() {
        return this.cardValue;
    }

    public void setCardValue(CardEnum cardEnum) throws CardInvalidEnumException {
        if (!(cardEnum instanceof PlayingCardEnum)) {
            throw new CardInvalidEnumException("PlayingCard.setCardValue - expecting a PlayingCardEnum instance.");
        }
        this.cardValue = cardEnum;
    }

    public int getCardColor() {
        int n = JPC_INVALID_RETURN;
        int n2 = this.cardValue.getValue();
        if (n2 >= PlayingCardEnum.ACE_OF_DIAMONDS.getValue() && n2 <= PlayingCardEnum.KING_OF_HEARTS.getValue() || n2 == PlayingCardEnum.RED_JOKER.getValue()) {
            n = 0;
        } else if (n2 >= PlayingCardEnum.ACE_OF_CLUBS.getValue() && n2 <= PlayingCardEnum.KING_OF_CLUBS.getValue() || n2 >= PlayingCardEnum.ACE_OF_SPADES.getValue() && n2 <= PlayingCardEnum.KING_OF_SPADES.getValue() || n2 == PlayingCardEnum.BLACK_JOKER.getValue()) {
            n = 1;
        }
        return n;
    }

    public int getCardSuit() {
        int n = JPC_INVALID_RETURN;
        int n2 = this.cardValue.getValue();
        if (n2 >= PlayingCardEnum.ACE_OF_CLUBS.getValue() && n2 <= PlayingCardEnum.KING_OF_CLUBS.getValue()) {
            n = 0;
        } else if (n2 >= PlayingCardEnum.ACE_OF_DIAMONDS.getValue() && n2 <= PlayingCardEnum.KING_OF_DIAMONDS.getValue()) {
            n = 1;
        } else if (n2 >= PlayingCardEnum.ACE_OF_HEARTS.getValue() && n2 <= PlayingCardEnum.KING_OF_HEARTS.getValue()) {
            n = 2;
        } else if (n2 >= PlayingCardEnum.ACE_OF_SPADES.getValue() && n2 <= PlayingCardEnum.KING_OF_SPADES.getValue()) {
            n = 3;
        }
        return n;
    }

    public int getCardPointValue() {
        int n = JPC_INVALID_RETURN;
        int n2 = this.cardValue.getValue();
        if (n2 >= PlayingCardEnum.ACE_OF_SPADES.getValue() && n2 <= PlayingCardEnum.KING_OF_SPADES.getValue()) {
            n2 -= PlayingCardEnum.KING_OF_HEARTS.getValue();
        } else if (n2 >= PlayingCardEnum.ACE_OF_HEARTS.getValue() && n2 <= PlayingCardEnum.KING_OF_HEARTS.getValue()) {
            n2 -= PlayingCardEnum.KING_OF_DIAMONDS.getValue();
        } else if (n2 >= PlayingCardEnum.ACE_OF_DIAMONDS.getValue() && n2 <= PlayingCardEnum.KING_OF_DIAMONDS.getValue()) {
            n2 -= PlayingCardEnum.KING_OF_CLUBS.getValue();
        }
        if (n2 >= PlayingCardEnum.ACE_OF_CLUBS.getValue() && n2 <= PlayingCardEnum.KING_OF_CLUBS.getValue()) {
            n = n2;
        }
        if (this.cardValue == PlayingCardEnum.RED_JOKER || this.cardValue == PlayingCardEnum.BLACK_JOKER) {
            n = 0;
        }
        return n;
    }

    public int getCardPointValueFace10() {
        int n = this.getCardPointValue();
        if (n >= PlayingCardEnum.JACK_OF_CLUBS.getValue() && n <= PlayingCardEnum.KING_OF_CLUBS.getValue()) {
            n = PlayingCardEnum.TEN_OF_CLUBS.getValue();
        }
        return n;
    }

    public String getCardName() {
        return ((Object)this.cardValue).toString();
    }

    public int getCompMode() {
        return this.compMode;
    }

    public void setCompMode(int n) {
        if (n >= 0 && n <= 2) {
            this.compMode = n;
        }
    }

    public int compareTo(Object object) {
        int n;
        int n2;
        if (object == null || !(object instanceof Card)) {
            throw new ClassCastException("PlayingCard: Invalid object being compared.");
        }
        int n3 = 0;
        switch (this.compMode) {
            case 1: {
                n2 = this.getCardPointValue();
                n = ((Card)object).getCardPointValue();
                break;
            }
            case 2: {
                n2 = this.getCardPointValueFace10();
                n = ((Card)object).getCardPointValueFace10();
                break;
            }
            default: {
                n2 = this.getCardValue().getValue();
                n = ((Card)object).getCardValue().getValue();
            }
        }
        if (n2 > n) {
            n3 = 1;
        } else if (n2 < n) {
            n3 = -1;
        }
        return n3;
    }

    public int hashCode() {
        return this.getCardName().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof Card) {
            try {
                bl = this.compareTo(object) == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public String toString() {
        return this.getCardName();
    }
}

