/*
 * Decompiled with CFR 0.152.
 */
package com.slackandassociates.cards.playingcards;

import com.slackandassociates.cards.playingcards.PlayingCard;
import com.slackandassociates.cards.playingcards.PlayingCardEnum;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class PlayingCardImageCache {
    private static final String CIC_PATH = "/com/slackandassociates/cards/playingcards/images/";
    private static final String CIC_EXT = ".gif";
    private HashMap cardCache = new HashMap(70);
    private boolean bImagesLoaded = false;
    public static final int IMAGE_WIDTH = 71;
    public static final int IMAGE_HEIGHT = 96;
    public static final int IMAGE_OFFSET = 15;

    public PlayingCardImageCache() {
        this(true);
    }

    public PlayingCardImageCache(boolean bl) {
        if (bl) {
            this.loadImageCache();
        }
    }

    private void loadImage(int n, Toolkit toolkit) {
        Image image = null;
        try {
            String string = CIC_PATH + n + CIC_EXT;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            do {
                if ((n2 = bufferedInputStream.read()) == -1) continue;
                byteArrayOutputStream.write(n2);
            } while (n2 != -1);
            bufferedInputStream.close();
            image = toolkit.createImage(byteArrayOutputStream.toByteArray());
            if (image != null) {
                this.cardCache.put("" + n, image);
            } else {
                System.out.println("Image failed to load: " + string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadImageCache() {
        if (!this.bImagesLoaded) {
            int n;
            this.bImagesLoaded = true;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int n2 = PlayingCardEnum.ACE_OF_CLUBS.getValue();
            int n3 = PlayingCardEnum.KING_OF_SPADES.getValue();
            for (n = n2; n <= n3; ++n) {
                this.loadImage(n, toolkit);
            }
            n2 = PlayingCardEnum.JC_CARDBACK_VAL1.getValue();
            n3 = PlayingCardEnum.JC_CARDBACK_VAL7.getValue();
            for (n = n2; n <= n3; ++n) {
                this.loadImage(n, toolkit);
            }
            n2 = PlayingCardEnum.JC_CARDSYMBOL_VAL1.getValue();
            n3 = PlayingCardEnum.JC_CARDSYMBOL_VAL4.getValue();
            for (n = n2; n <= n3; ++n) {
                this.loadImage(n, toolkit);
            }
            this.loadImage(PlayingCardEnum.RED_JOKER.getValue(), toolkit);
            this.loadImage(PlayingCardEnum.BLACK_JOKER.getValue(), toolkit);
        }
    }

    public void waitForImages(Component component) {
        MediaTracker mediaTracker = new MediaTracker(component);
        Iterator iterator = this.cardCache.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            mediaTracker.addImage((Image)this.cardCache.get(string), 0);
        }
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("PlayingCard.waitForImages: " + interruptedException);
        }
    }

    public Image getCardImage(PlayingCard playingCard) {
        return this.getCardImage((PlayingCardEnum)playingCard.getCardValue());
    }

    public Image getCardImage(PlayingCardEnum playingCardEnum) {
        if (!this.bImagesLoaded) {
            this.loadImageCache();
        }
        return (Image)this.cardCache.get("" + playingCardEnum.getValue());
    }
}

