/*
 * Decompiled with CFR 0.152.
 */
import com.slackandassociates.ImageCanvas;
import com.slackandassociates.SwingWorker;
import com.slackandassociates.Utilities;
import com.slackandassociates.cards.Card;
import com.slackandassociates.cards.CardDeck;
import com.slackandassociates.cards.CardHand;
import com.slackandassociates.cards.playingcards.PlayingCard;
import com.slackandassociates.cards.playingcards.PlayingCardDeck;
import com.slackandassociates.cards.playingcards.PlayingCardEnum;
import com.slackandassociates.cards.playingcards.PlayingCardImageCache;
import com.slackandassociates.dialogs.AboutDlg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Cribbage
extends JApplet {
    private static final boolean DEBUG_ON = false;
    private static final int W_WIDTH = 650;
    private static final int W_HEIGHT = 500;
    private static final int C_PLAYER = 0;
    private static final int H_PLAYER = 1;
    private static final String S_APPTITLE = "Cribbage";
    private static final String S_DISCARD = "Discard";
    private static final String S_KEEP = "Keep";
    private static final String S_PLAY = "Play";
    private static final String S_PLAY_GAME = "Play Game";
    private static final String S_NEW_GAME = "New Game";
    private static final String S_GO = "Go";
    private static final String S_CONTINUE = "Continue";
    private static final String S_BOARD_SOUNDS = "Board Sound On";
    private static final String S_LASTCARD = " gets one point for last card.";
    private CardDeck cards = new CardDeck(PlayingCardDeck.PC_DECK, class$com$slackandassociates$cards$playingcards$PlayingCard == null ? (class$com$slackandassociates$cards$playingcards$PlayingCard = Cribbage.class$("com.slackandassociates.cards.playingcards.PlayingCard")) : class$com$slackandassociates$cards$playingcards$PlayingCard);
    private PlayingCardImageCache cImgs = new PlayingCardImageCache();
    private PlayingCardEnum placeHolder = (PlayingCardEnum)PlayingCardEnum.JC_CARDSYMBOL_VAL3;
    private JFrame frame = null;
    private Container frame_cp = null;
    private JMenuBar mb = new JMenuBar();
    private JMenu m1 = new JMenu("File");
    private JMenuItem mi1 = new JMenuItem("Print");
    private JMenuItem mi2 = new JMenuItem("Exit");
    private JMenu m2 = new JMenu("Help");
    private JMenuItem mi3 = new JMenuItem("Contents");
    private JMenuItem mi4 = new JMenuItem("About");
    private ImageIcon mbOKImg = null;
    private ImageIcon mbStopImg = null;
    private CribBoard cbBoard = new StdCribBoard(false);
    private ImageCanvas icUpCard = null;
    private JLabel lbl1 = new JLabel("Cards Left: ", 2);
    private JLabel lblCL = new JLabel("0", 0);
    private JLabel lbl2 = new JLabel("Game Tally: ", 2);
    private JLabel lblGT = new JLabel("0", 0);
    private JLabel lbl3 = new JLabel("Score:", 2);
    private JLabel lblCompScore = new JLabel("0", 0);
    private JLabel lblPlayerScore = new JLabel("0", 0);
    private JLabel lbl4 = new JLabel("Games:", 2);
    private JLabel lblCompGames = new JLabel("0", 0);
    private JLabel lblPlayerGames = new JLabel("0", 0);
    private JButton newBtn = new JButton("Play Game");
    private JButton goBtn = new JButton("Go");
    private JButton contBtn = new JButton("Continue");
    private JCheckBox cbSndOn = new JCheckBox("Board Sound On");
    private JLabel lblCrib = new JLabel("[CRIB]");
    private PlayArea playArea = new PlayArea();
    private ImageCanvas c1 = new ImageCanvas(this.cImgs.getCardImage(this.placeHolder));
    private ImageCanvas c2 = new ImageCanvas(this.cImgs.getCardImage(this.placeHolder));
    private ImageCanvas c3 = new ImageCanvas(this.cImgs.getCardImage(this.placeHolder));
    private ImageCanvas c4 = new ImageCanvas(this.cImgs.getCardImage(this.placeHolder));
    private ImageCanvas c5 = new ImageCanvas(this.cImgs.getCardImage(this.placeHolder));
    private ImageCanvas c6 = new ImageCanvas(this.cImgs.getCardImage(this.placeHolder));
    private JButton b1 = new JButton("Discard");
    private JButton b2 = new JButton("Discard");
    private JButton b3 = new JButton("Discard");
    private JButton b4 = new JButton("Discard");
    private JButton b5 = new JButton("Discard");
    private JButton b6 = new JButton("Discard");
    private Font btnFnt = new Font("Helvetica", 0, 12);
    private ButtonHandler btnhnd = null;
    private CribBoardHandler crbhnd = null;
    private CribPlayHandler crbply = null;
    private CardHand playedCards = new CardHand(8, false);
    private CardHand[] hands = new CardHand[2];
    private CardHand[] playHands = new CardHand[2];
    private CardHand crib = new CardHand(4);
    private CribbageEngine cribEng = new CribbageEngine();
    private PlayingCard upCard = null;
    private boolean cribFlag = true;
    private int iDiscardCount = 0;
    private int mugginsPoints = 0;
    private ImageCanvas[] cardImgs = new ImageCanvas[6];
    private JButton[] buttons = new JButton[6];
    private int handTally = 0;
    private int playerGamesWon = 0;
    private int compGamesWon = 0;
    private boolean goFlagP = false;
    private boolean goFlagC = false;
    private boolean scoreLastPoint = true;
    private boolean gameOver = false;
    private boolean pPlayedLast = false;
    private boolean X31 = false;
    private boolean waitForMoves = false;
    private boolean pAlwaysStart = false;
    private CribbageProps props = new CribbageProps(this);
    static /* synthetic */ Class class$com$slackandassociates$cards$playingcards$PlayingCard;

    public Cribbage() {
        int n = 0;
        while (n < 2) {
            this.hands[n] = new CardHand(6);
            this.hands[n].setCompMode(1);
            this.playHands[n] = new CardHand(4);
            this.playHands[n].setCompMode(1);
            ++n;
        }
        this.crib.setCompMode(1);
        this.cardImgs[0] = this.c1;
        this.cardImgs[1] = this.c2;
        this.cardImgs[2] = this.c3;
        this.cardImgs[3] = this.c4;
        this.cardImgs[4] = this.c5;
        this.cardImgs[5] = this.c6;
        this.buttons[0] = this.b1;
        this.buttons[1] = this.b2;
        this.buttons[2] = this.b3;
        this.buttons[3] = this.b4;
        this.buttons[4] = this.b5;
        this.buttons[5] = this.b6;
    }

    private void createFrame() {
        this.frame = new JFrame(S_APPTITLE);
        ((Frame)this.frame).setIconImage(Utilities.loadImage(this, this.getToolkit(), this.props.getImagePath(), "cribbage.gif"));
        this.frame.setDefaultCloseOperation(3);
    }

    private void setupMenu() {
        this.mi1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Toolkit toolkit = Cribbage.this.frame.getToolkit();
                    PrintJob printJob = toolkit.getPrintJob(Cribbage.this.frame, "Cribbage Print", null);
                    Graphics graphics = printJob.getGraphics();
                    Cribbage.this.frame.printComponents(graphics);
                    graphics.dispose();
                    printJob.end();
                }
                catch (Exception exception) {
                    System.err.println("Print failed: " + exception);
                }
            }
        });
        this.m1.add(this.mi1);
        this.m1.addSeparator();
        this.mi2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.m1.add(this.mi2);
        this.mb.add(this.m1);
        this.mi3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new CribbageHelp(Cribbage.this.frame, Cribbage.this.props.getHelpPath()).show();
            }
        });
        this.m2.add(this.mi3);
        this.m2.addSeparator();
        this.mi4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutDlg(Cribbage.this.frame, Cribbage.S_APPTITLE, Cribbage.this.props.getVersionInfo(), "Michael G. Slack", Cribbage.this.props.getAuthorEmail()).show();
            }
        });
        this.m2.add(this.mi4);
        this.mb.add(this.m2);
        this.frame.setJMenuBar(this.mb);
    }

    private void setupLabels() {
        this.lblCompScore.setOpaque(true);
        this.lblCompScore.setBackground(Color.blue);
        this.lblCompScore.setForeground(Color.white);
        this.lblCompGames.setOpaque(true);
        this.lblCompGames.setBackground(Color.blue);
        this.lblCompGames.setForeground(Color.white);
        this.lblPlayerScore.setOpaque(true);
        this.lblPlayerScore.setBackground(Color.red);
        this.lblPlayerScore.setForeground(Color.white);
        this.lblPlayerGames.setOpaque(true);
        this.lblPlayerGames.setBackground(Color.red);
        this.lblPlayerGames.setForeground(Color.white);
        this.lblCrib.setOpaque(true);
        this.lblCrib.setBackground(Color.lightGray);
        this.lblCrib.setForeground(Color.white);
    }

    private void setButtonSize(JButton jButton) {
        Dimension dimension = new Dimension(100, 27);
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setFont(this.btnFnt);
    }

    private void setupCenter() {
        Box box = Box.createHorizontalBox();
        Box box2 = Box.createVerticalBox();
        Box box3 = Box.createVerticalBox();
        Box box4 = Box.createVerticalBox();
        Box box5 = Box.createVerticalBox();
        Dimension dimension = new Dimension(5, 16);
        this.setupLabels();
        box2.add(Box.createVerticalStrut(5));
        box2.add(this.lbl1);
        box2.add(this.lbl2);
        box2.add(this.lbl3);
        box2.add(this.lbl4);
        box2.add(Box.createVerticalGlue());
        box3.add(Box.createVerticalStrut(5));
        box3.add(this.lblCL);
        box3.add(this.lblGT);
        box3.add(this.lblCompScore);
        box3.add(this.lblCompGames);
        box3.add(Box.createVerticalGlue());
        box4.add(Box.createVerticalStrut(5));
        box4.add(Box.createRigidArea(dimension));
        box4.add(Box.createRigidArea(dimension));
        box4.add(this.lblPlayerScore);
        box4.add(this.lblPlayerGames);
        box4.add(Box.createVerticalGlue());
        this.newBtn.addActionListener(this.btnhnd);
        this.setButtonSize(this.newBtn);
        box5.add(this.newBtn);
        this.goBtn.addActionListener(this.btnhnd);
        this.setButtonSize(this.goBtn);
        this.goBtn.setEnabled(false);
        box5.add(this.goBtn);
        this.contBtn.addActionListener(this.btnhnd);
        this.setButtonSize(this.contBtn);
        this.contBtn.setEnabled(false);
        box5.add(this.contBtn);
        this.cbSndOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Cribbage.this.cbBoard.hasSoundEffects()) {
                    Cribbage.this.cbBoard.setSoundOn(!Cribbage.this.cbBoard.isSoundOn());
                }
            }
        });
        box5.add(this.cbSndOn);
        box5.add(this.lblCrib);
        box.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(box3);
        box.add(box4);
        box.add(box5);
        box.add(Box.createHorizontalGlue());
        this.frame_cp.add((Component)box, "Center");
    }

    private JPanel createCardPanel(ImageCanvas imageCanvas, JButton jButton) {
        JPanel jPanel = new JPanel();
        int n = 71;
        int n2 = 96;
        Dimension dimension = new Dimension(n + 10, n2 + 32);
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setLayout(null);
        imageCanvas.setBounds(new Rectangle(5, 1, n, n2));
        jButton.setBounds(new Rectangle(1, n2 + 4, n + 8, 27));
        jButton.setFont(this.btnFnt);
        jButton.setVisible(false);
        jPanel.add((Component)imageCanvas, null);
        jPanel.add((Component)jButton, null);
        return jPanel;
    }

    private void setupSouth() {
        Box box = Box.createHorizontalBox();
        box.add(this.createCardPanel(this.c1, this.b1));
        box.add(this.createCardPanel(this.c2, this.b2));
        box.add(this.createCardPanel(this.c3, this.b3));
        box.add(this.createCardPanel(this.c4, this.b4));
        box.add(this.createCardPanel(this.c5, this.b5));
        box.add(this.createCardPanel(this.c6, this.b6));
        box.add(Box.createGlue());
        this.b1.addActionListener(this.btnhnd);
        this.b2.addActionListener(this.btnhnd);
        this.b3.addActionListener(this.btnhnd);
        this.b4.addActionListener(this.btnhnd);
        this.b5.addActionListener(this.btnhnd);
        this.b6.addActionListener(this.btnhnd);
        this.frame_cp.add((Component)box, "South");
    }

    private void setupPanels() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.frame_cp.add((Component)((Object)this.cbBoard), "North");
        this.icUpCard = new ImageCanvas(this.cImgs.getCardImage(this.props.getCardBackImage()));
        jPanel.add(this.icUpCard);
        this.frame_cp.add((Component)jPanel, "West");
        this.setupCenter();
        jPanel2.add(this.playArea);
        this.frame_cp.add((Component)jPanel2, "East");
        this.setupSouth();
    }

    private void movePeg(int n, int n2) {
        try {
            this.cbBoard.movePeg(n, n2);
        }
        catch (Exception exception) {
            System.err.println("movePeg() error: " + exception);
        }
    }

    protected void get_Points(boolean bl) {
        int n = 0;
        int n2 = 0;
        n = bl ? this.cribEng.figure_Points(this.crib, true, this.upCard) : this.cribEng.figure_Points(this.hands[1], false, this.upCard);
        CribbageScoreDlg cribbageScoreDlg = new CribbageScoreDlg(this.frame, bl, n, this.mbStopImg);
        cribbageScoreDlg.show();
        n2 = cribbageScoreDlg.getPoints();
        this.movePeg(1, n2);
        this.mugginsPoints = n - n2;
    }

    protected void firePlayEvent(int n) {
        CribPlayEvent cribPlayEvent = new CribPlayEvent(this, n);
        this.crbply.update(cribPlayEvent);
    }

    protected void resetUpcard() {
        if (this.upCard != null) {
            this.upCard = null;
            this.icUpCard.setImage(this.cImgs.getCardImage(this.props.getCardBackImage()));
        }
    }

    protected void showScore() {
        try {
            this.lblCompScore.setText("" + this.cbBoard.getScore(0));
            this.lblPlayerScore.setText("" + this.cbBoard.getScore(1));
        }
        catch (Exception exception) {
            System.err.println("showScore() error: " + exception);
        }
    }

    protected void init_Game() {
        try {
            this.cbBoard.resetBoard();
        }
        catch (Exception exception) {
            System.err.println("init_Game() - board reset: " + exception);
        }
    }

    protected void clearPlayedCards() {
        this.handTally = 0;
        this.goFlagP = false;
        this.goFlagC = false;
        this.lblGT.setText("" + this.handTally);
        this.playedCards.removeAll();
        this.playArea.repaint();
    }

    protected void startHand() {
        this.clearPlayedCards();
        this.resetUpcard();
        this.iDiscardCount = 0;
        this.cards.shuffle();
        if (this.cribFlag) {
            this.lblCrib.setBackground(Color.red);
        } else {
            this.lblCrib.setBackground(Color.blue);
        }
        this.scoreLastPoint = true;
        int n = 0;
        while (n < this.hands.length) {
            this.hands[n].removeAll();
            this.playHands[n].removeAll();
            ++n;
        }
        this.crib.removeAll();
        int n2 = 0;
        while (n2 < 6) {
            this.hands[0].add(this.cards.getNextCard());
            this.hands[1].add(this.cards.getNextCard());
            this.buttons[n2].setVisible(true);
            this.buttons[n2].setEnabled(true);
            this.buttons[n2].setText(S_DISCARD);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 6) {
            this.cardImgs[n3].setImage(this.cImgs.getCardImage((PlayingCard)this.hands[1].cardAt(n3)));
            ++n3;
        }
    }

    protected void finishGame(int n) {
        this.gameOver = true;
        this.waitForMoves = false;
        if (n == 1) {
            this.showMessageBox("You've won, congratulations.");
            ++this.playerGamesWon;
            this.lblPlayerGames.setText("" + this.playerGamesWon);
        } else {
            this.showMessageBox("I've won.");
            ++this.compGamesWon;
            this.lblCompGames.setText("" + this.compGamesWon);
        }
        this.contBtn.setEnabled(false);
        this.goBtn.setEnabled(false);
        int n2 = 0;
        while (n2 < 6) {
            this.buttons[n2].setVisible(false);
            this.cardImgs[n2].setImage(this.cImgs.getCardImage(this.placeHolder));
            ++n2;
        }
    }

    protected void getUpCard() {
        this.upCard = (PlayingCard)this.cards.getNextCard();
        this.icUpCard.setImage(this.cImgs.getCardImage(this.upCard));
        if (this.upCard.getCardPointValue() == 11) {
            if (this.cribFlag) {
                this.movePeg(1, 2);
            } else {
                this.movePeg(0, 2);
            }
        }
    }

    protected void enablePlayerBtns(boolean bl) {
        int n = 0;
        while (n < 6) {
            if (this.buttons[n].isVisible()) {
                this.buttons[n].setEnabled(bl);
            }
            ++n;
        }
    }

    protected void enableControls(boolean bl) {
        this.newBtn.setEnabled(bl);
        this.cbSndOn.setEnabled(bl);
        this.enablePlayerBtns(bl);
    }

    protected void showMessageBox(String string) {
        JOptionPane.showMessageDialog(this.frame, string, "Information", 1, this.mbOKImg);
    }

    protected void play_Card(int n, int n2) {
        this.pPlayedLast = n == 1;
        int n3 = this.playHands[n].cardAt(n2).getCardPointValueFace10();
        this.playedCards.add(this.playHands[n].remove(n2));
        this.handTally += n3;
        this.lblGT.setText("" + this.handTally);
        this.playArea.repaint();
    }

    protected void doThePlay(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        int n3 = 0;
        String string = n == 1 ? this.props.getPlayName() : this.props.getCompName();
        this.play_Card(n, n2);
        n3 = this.cribEng.pointsInGame(this.playedCards);
        arrayList = this.cribEng.getScoreMessages();
        if (!arrayList.isEmpty()) {
            Iterator iterator = ((AbstractList)arrayList).iterator();
            while (iterator.hasNext()) {
                this.showMessageBox(string + (String)iterator.next());
            }
        }
        if (n3 > 0) {
            this.movePeg(n, n3);
        }
        if (this.handTally == 31) {
            this.clearPlayedCards();
            this.X31 = true;
        } else {
            this.X31 = false;
        }
    }

    protected void show_Cards(CardHand cardHand) {
        int n = 0;
        while (n < 4) {
            this.buttons[n].setVisible(false);
            this.cardImgs[n].setImage(this.cImgs.getCardImage((PlayingCard)cardHand.cardAt(n)));
            ++n;
        }
    }

    public void init() {
        Image image = null;
        String string = this.props.getImagePath();
        boolean bl = this.props.getGameSoundsOn();
        this.pAlwaysStart = this.props.getAlwaysStart();
        image = Utilities.loadImage(this, this.getToolkit(), string, "info.gif");
        this.mbOKImg = new ImageIcon(image);
        image = Utilities.loadImage(this, this.getToolkit(), string, "hand.gif");
        this.mbStopImg = new ImageIcon(image);
        this.btnhnd = new ButtonHandler();
        this.crbhnd = new CribBoardHandler();
        this.crbply = new CribPlayHandler();
        if (this.frame != null) {
            this.frame_cp = this.frame.getContentPane();
            this.setupMenu();
        } else {
            this.frame_cp = this.getContentPane();
            this.frame_cp.setLayout(new BorderLayout());
        }
        this.setupPanels();
        this.cbBoard.addCribBoardListener(this.crbhnd);
        try {
            this.cbBoard.initializeBoard();
        }
        catch (Exception exception) {
            System.err.println("Cribbage board initialization error: " + exception);
        }
        if (bl) {
            this.cbBoard.setSoundOn(bl);
            this.cbSndOn.setSelected(bl);
        }
        if (this.frame != null) {
            ((Component)this.frame).setSize(650, 500);
            Utilities.centerWindowOnScreen(this.frame, 650, 500);
            this.frame.setResizable(false);
            ((Component)this.frame).setVisible(true);
        }
        new CardLoader().start();
    }

    public void go() {
        this.init();
        this.start();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Cribbage cribbage = new Cribbage();
                cribbage.createFrame();
                cribbage.go();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PlayArea
    extends JComponent {
        private Dimension dim = new Dimension(184, 110);

        public PlayArea() {
            this.setPreferredSize(this.dim);
        }

        public AccessibleContext getAccessibleContext() {
            return null;
        }

        public void paint(Graphics graphics) {
            int n = 4;
            int n2 = 6;
            graphics.setColor(Color.gray);
            graphics.fillRect(0, 0, this.dim.width, this.dim.height);
            int n3 = Cribbage.this.playedCards.getCardCount();
            int n4 = 0;
            while (n4 < n3) {
                Card card = Cribbage.this.playedCards.cardAt(n4);
                if (card != CardHand.EMPTY_CARD) {
                    graphics.drawImage(Cribbage.this.cImgs.getCardImage((PlayingCard)card), n, n2, this);
                    n += 15;
                }
                ++n4;
            }
        }
    }

    class CribPlayHandler
    implements CribPlayListener {
        public void update(CribPlayEvent cribPlayEvent) {
            int n = cribPlayEvent.getEvent();
            if (n == 1) {
                new PlayPlayT().start();
            } else if (n == 2) {
                new CompPlayT().start();
            } else if (n == 3) {
                new ScoreT().start();
            }
        }
    }

    class ScoreT
    extends BaseT {
        public void run() {
            int n = 0;
            if (!Cribbage.this.gameOver) {
                this.waitOnBoard();
                if (!Cribbage.this.X31 && Cribbage.this.scoreLastPoint) {
                    if (Cribbage.this.pPlayedLast) {
                        Cribbage.this.showMessageBox(Cribbage.this.props.getPlayName() + Cribbage.S_LASTCARD);
                        Cribbage.this.movePeg(1, 1);
                    } else {
                        Cribbage.this.showMessageBox(Cribbage.this.props.getCompName() + Cribbage.S_LASTCARD);
                        Cribbage.this.movePeg(0, 1);
                    }
                    this.waitOnBoard();
                }
                if (!Cribbage.this.gameOver) {
                    Cribbage.this.clearPlayedCards();
                    n = Cribbage.this.cribEng.figure_Points(Cribbage.this.hands[0], false, Cribbage.this.upCard);
                    if (Cribbage.this.cribFlag) {
                        Cribbage.this.show_Cards(Cribbage.this.hands[0]);
                        Cribbage.this.showMessageBox(Cribbage.this.props.getCompName() + " has " + n + " points.");
                        Cribbage.this.movePeg(0, n);
                        this.waitOnBoard();
                        if (!Cribbage.this.gameOver) {
                            Cribbage.this.show_Cards(Cribbage.this.hands[1]);
                            Cribbage.this.get_Points(false);
                            this.waitOnBoard();
                            if (!Cribbage.this.gameOver) {
                                Cribbage.this.show_Cards(Cribbage.this.crib);
                                Cribbage.this.get_Points(true);
                                this.waitOnBoard();
                            }
                        }
                    } else {
                        Cribbage.this.show_Cards(Cribbage.this.hands[1]);
                        Cribbage.this.get_Points(false);
                        this.waitOnBoard();
                        if (!Cribbage.this.gameOver) {
                            Cribbage.this.show_Cards(Cribbage.this.hands[0]);
                            Cribbage.this.showMessageBox(Cribbage.this.props.getCompName() + " has " + n + " points.");
                            Cribbage.this.movePeg(0, n);
                            this.waitOnBoard();
                            if (!Cribbage.this.gameOver) {
                                Cribbage.this.show_Cards(Cribbage.this.crib);
                                n = Cribbage.this.cribEng.figure_Points(Cribbage.this.crib, true, Cribbage.this.upCard);
                                Cribbage.this.showMessageBox("There are " + n + " points in the crib.");
                                Cribbage.this.movePeg(0, n);
                                this.waitOnBoard();
                            }
                        }
                    }
                }
                if (!Cribbage.this.gameOver) {
                    Cribbage.this.cribFlag = !Cribbage.this.cribFlag;
                    Cribbage.this.startHand();
                }
            }
        }
    }

    class CompPlayT
    extends BaseT {
        private void doOneMove() {
            Cribbage.this.showMessageBox(Cribbage.this.props.getCompName() + Cribbage.S_LASTCARD);
            Cribbage.this.movePeg(0, 1);
            Cribbage.this.clearPlayedCards();
        }

        public void run() {
            boolean bl = false;
            int n = -1;
            if (!Cribbage.this.gameOver) {
                Cribbage.this.goBtn.setEnabled(false);
                Cribbage.this.enablePlayerBtns(false);
                this.waitOnBoard();
                if (this.isHandOver() || Cribbage.this.gameOver) {
                    return;
                }
                if (Cribbage.this.playHands[0].getCardCount() > 0) {
                    do {
                        this.waitOnBoard();
                        n = Cribbage.this.cribEng.getCardToPlay(Cribbage.this.playedCards, Cribbage.this.playHands[0]);
                        if (n != -1) {
                            Cribbage.this.doThePlay(0, n);
                            Cribbage.this.lblCL.setText("" + Cribbage.this.playHands[0].getCardCount());
                            continue;
                        }
                        if (Cribbage.this.goFlagP) {
                            this.doOneMove();
                            continue;
                        }
                        if (Cribbage.this.playHands[1].getCardCount() != 0) {
                            Cribbage.this.showMessageBox("I don't have a play, Go.");
                            Cribbage.this.goFlagC = true;
                            continue;
                        }
                        Cribbage.this.scoreLastPoint = false;
                        Cribbage.this.showMessageBox("I have no play, you get last point.");
                        Cribbage.this.movePeg(1, 1);
                        Cribbage.this.clearPlayedCards();
                    } while (!(bl = !Cribbage.this.goFlagP || Cribbage.this.playHands[0].getCardCount() == 0 || Cribbage.this.gameOver));
                    this.waitOnBoard();
                    if (Cribbage.this.playHands[0].getCardCount() == 0 && Cribbage.this.playHands[1].getCardCount() != 0 && Cribbage.this.goFlagP) {
                        this.doOneMove();
                        this.waitOnBoard();
                        Cribbage.this.goFlagP = true;
                    }
                }
                if (!Cribbage.this.gameOver) {
                    Cribbage.this.firePlayEvent(1);
                }
            }
        }
    }

    class PlayPlayT
    extends BaseT {
        public void run() {
            if (!Cribbage.this.gameOver) {
                this.waitOnBoard();
                if (this.isHandOver()) {
                    return;
                }
                if (Cribbage.this.playHands[1].getCardCount() > 0) {
                    Cribbage.this.goBtn.setEnabled(true);
                    Cribbage.this.enablePlayerBtns(true);
                } else {
                    Cribbage.this.firePlayEvent(2);
                }
            }
        }
    }

    class BaseT
    extends Thread {
        public boolean isHandOver() {
            boolean bl = false;
            if (Cribbage.this.playHands[0].getCardCount() == 0 && Cribbage.this.playHands[1].getCardCount() == 0) {
                bl = true;
                Cribbage.this.firePlayEvent(3);
            }
            return bl;
        }

        public void waitOnBoard() {
            try {
                do {
                    Thread.sleep(250L);
                } while (Cribbage.this.waitForMoves);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
        }
    }

    class ButtonHandler
    implements ActionListener {
        private void doDiscard(int n, int[] nArray) {
            Cribbage.this.crib.add(Cribbage.this.hands[n].remove(nArray[0]));
            Cribbage.this.crib.add(Cribbage.this.hands[n].remove(nArray[1]));
            Cribbage.this.hands[n].compressHand();
        }

        private void handleContinue() {
            int[] nArray = Cribbage.this.cribEng.analyzeHandForDiscards(Cribbage.this.hands[0]);
            this.doDiscard(0, nArray);
            Cribbage.this.lblCL.setText("" + Cribbage.this.hands[0].getCardCount());
            int n = 0;
            int n2 = 0;
            while (n2 < 6) {
                if (Cribbage.this.buttons[n2].getText().equals(Cribbage.S_KEEP)) {
                    nArray[n++] = n2;
                }
                if (n == 2) break;
                ++n2;
            }
            this.doDiscard(1, nArray);
            int n3 = 0;
            while (n3 < 4) {
                Cribbage.this.playHands[0].add(Cribbage.this.hands[0].cardAt(n3));
                Cribbage.this.playHands[1].add(Cribbage.this.hands[1].cardAt(n3));
                ++n3;
            }
            int n4 = 0;
            while (n4 < 6) {
                Cribbage.this.buttons[n4].setText(Cribbage.S_PLAY);
                if (n4 > 3) {
                    Cribbage.this.buttons[n4].setVisible(false);
                    Cribbage.this.cardImgs[n4].setImage(Cribbage.this.cImgs.getCardImage(Cribbage.this.placeHolder));
                } else {
                    Cribbage.this.cardImgs[n4].setImage(Cribbage.this.cImgs.getCardImage((PlayingCard)Cribbage.this.playHands[1].cardAt(n4)));
                }
                ++n4;
            }
            Cribbage.this.getUpCard();
            Cribbage.this.contBtn.setEnabled(false);
            if (Cribbage.this.cribFlag) {
                Cribbage.this.firePlayEvent(1);
            } else {
                Cribbage.this.firePlayEvent(2);
            }
        }

        private void handleGo() {
            int n = 0;
            while (n < 4) {
                if (Cribbage.this.buttons[n].isVisible() && Cribbage.this.handTally + Cribbage.this.playHands[1].cardAt(n).getCardPointValueFace10() <= 31) {
                    Cribbage.this.showMessageBox("Shame on you, you have a play.");
                    return;
                }
                ++n;
            }
            if (Cribbage.this.goFlagC) {
                Cribbage.this.showMessageBox(Cribbage.this.props.getPlayName() + Cribbage.S_LASTCARD);
                Cribbage.this.movePeg(1, 1);
                Cribbage.this.clearPlayedCards();
            } else if (Cribbage.this.playHands[0].getCardCount() > 0) {
                Cribbage.this.goFlagP = true;
            } else {
                Cribbage.this.scoreLastPoint = false;
                Cribbage.this.showMessageBox(Cribbage.this.props.getCompName() + Cribbage.S_LASTCARD);
                Cribbage.this.movePeg(0, 1);
                Cribbage.this.clearPlayedCards();
            }
            Cribbage.this.firePlayEvent(2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(Cribbage.S_CONTINUE)) {
                this.handleContinue();
            } else if (string.equals(Cribbage.S_DISCARD) || string.equals(Cribbage.S_KEEP)) {
                if (string.equals(Cribbage.S_DISCARD)) {
                    Cribbage.this.iDiscardCount++;
                    ((JButton)actionEvent.getSource()).setText(Cribbage.S_KEEP);
                } else {
                    Cribbage.this.iDiscardCount--;
                    ((JButton)actionEvent.getSource()).setText(Cribbage.S_DISCARD);
                }
                if (Cribbage.this.iDiscardCount == 2) {
                    Cribbage.this.contBtn.setEnabled(true);
                } else {
                    Cribbage.this.contBtn.setEnabled(false);
                }
            } else if (string.equals(Cribbage.S_GO)) {
                this.handleGo();
            } else if (string.equals(Cribbage.S_PLAY)) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                while (n3 < 4) {
                    if (Cribbage.this.buttons[n3] == actionEvent.getSource()) {
                        n = n3;
                    }
                    ++n3;
                }
                n2 = Cribbage.this.handTally + Cribbage.this.playHands[1].cardAt(n).getCardPointValueFace10();
                if (n2 > 31) {
                    Cribbage.this.showMessageBox("That totals more than 31, try again.");
                    return;
                }
                Cribbage.this.buttons[n].setVisible(false);
                Cribbage.this.cardImgs[n].setImage(Cribbage.this.cImgs.getCardImage(Cribbage.this.placeHolder));
                Cribbage.this.doThePlay(1, n);
                if (!Cribbage.this.gameOver && !Cribbage.this.goFlagC) {
                    Cribbage.this.firePlayEvent(2);
                }
            } else if (string.equals(Cribbage.S_PLAY_GAME) || string.equals(Cribbage.S_NEW_GAME)) {
                if (string.equals(Cribbage.S_PLAY_GAME)) {
                    ((JButton)actionEvent.getSource()).setText(Cribbage.S_NEW_GAME);
                } else {
                    Cribbage.this.init_Game();
                }
                if (Cribbage.this.pAlwaysStart) {
                    Cribbage.this.cribFlag = true;
                } else {
                    Cribbage.this.cribFlag = (int)Math.floor(Math.random() * 2.0) == 0;
                }
                if (Cribbage.this.cribFlag) {
                    Cribbage.this.showMessageBox("Your crib to start.");
                } else {
                    Cribbage.this.showMessageBox("My crib to start.");
                }
                Cribbage.this.startHand();
            }
        }
    }

    class CribBoardHandler
    implements CribBoardListener {
        private void doIt(boolean bl) {
            Cribbage.this.showScore();
            if (Cribbage.this.mugginsPoints > 0) {
                Cribbage.this.showMessageBox("MUGGINS! You missed " + Cribbage.this.mugginsPoints + " points (which I get).");
                Cribbage.this.movePeg(0, Cribbage.this.mugginsPoints);
                Cribbage.this.mugginsPoints = 0;
            } else {
                Cribbage.this.enableControls(true);
                if (!bl) {
                    Cribbage.this.waitForMoves = false;
                }
            }
        }

        public void update(CribBoardEvent cribBoardEvent) {
            int n = cribBoardEvent.getEvent();
            if (n == 2) {
                Cribbage.this.waitForMoves = true;
                Cribbage.this.enableControls(false);
            } else if (n == 3) {
                this.doIt(false);
            } else if (n == 5) {
                int n2 = cribBoardEvent.getWinningPlayer();
                Cribbage.this.mugginsPoints = 0;
                this.doIt(true);
                Cribbage.this.finishGame(n2);
            } else if (n == 4) {
                Cribbage.this.gameOver = false;
                Cribbage.this.showScore();
                Cribbage.this.lblCrib.setBackground(Color.lightGray);
                Cribbage.this.resetUpcard();
            }
        }
    }

    class CardLoader
    extends SwingWorker {
        CardLoader() {
        }

        public Object construct() {
            Cribbage.this.cImgs.waitForImages(Cribbage.this.frame_cp);
            return "Success";
        }

        public void finished() {
        }
    }
}

