/*
 * Decompiled with CFR 0.152.
 */
import com.slackandassociates.cards.Card;
import com.slackandassociates.cards.CardDeck;
import com.slackandassociates.cards.CardHand;
import com.slackandassociates.cards.playingcards.PlayingCard;
import com.slackandassociates.cards.playingcards.PlayingCardDeck;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class CribbageEngine
implements Serializable {
    private static final int[][] CONQ = new int[][]{{1, 1, 1, 2, 3, 9}, {1, 1, 2, 2, 3, 12}, {1, 1, 2, 3, 3, 12}, {1, 1, 2, 3, 4, 8}, {1, 2, 2, 2, 3, 9}, {1, 2, 2, 3, 3, 12}, {1, 2, 2, 3, 4, 8}, {1, 2, 3, 3, 3, 9}, {1, 2, 3, 3, 4, 8}, {1, 2, 3, 4, 4, 8}, {1, 2, 3, 4, 5, 5}};
    private static final int[][] CONR = new int[][]{{1, 1, 2, 3, 6}, {1, 2, 2, 3, 6}, {1, 2, 3, 3, 6}, {1, 2, 3, 4, 4}};
    private static final int[] CONS = new int[]{1, 2, 3, 3};
    private static final int[][] CONV = new int[][]{{0, 1, 2, 3, 4, 5, 0}, {0, 1, 2, 4, 3, 5, 0}, {0, 1, 2, 5, 3, 4, 0}, {0, 1, 3, 4, 2, 5, 0}, {0, 1, 3, 5, 2, 4, 0}, {0, 1, 4, 5, 2, 3, 0}, {0, 2, 3, 4, 1, 5, 0}, {0, 2, 3, 5, 1, 4, 0}, {0, 2, 4, 5, 1, 3, 0}, {0, 3, 4, 5, 1, 2, 0}, {1, 2, 3, 4, 0, 5, 0}, {1, 2, 3, 5, 0, 4, 0}, {1, 2, 4, 5, 0, 3, 0}, {1, 3, 4, 5, 0, 2, 0}, {2, 3, 4, 5, 0, 1, 0}};
    private ArrayList scoreMsgs = new ArrayList(4);

    private int checkForJack(CardHand cardHand, boolean bl, int n) {
        int n2 = 0;
        if (bl) {
            int n3 = 0;
            while (n3 < 4) {
                Card card = cardHand.cardAt(n3);
                if (card != null && card.getCardSuit() == n && card.getCardPointValue() == 11) {
                    n2 = 1;
                    break;
                }
                ++n3;
            }
        }
        return n2;
    }

    private int checkFlush(CardHand cardHand, boolean bl, int n) {
        Card card;
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        while (n4 < 3) {
            card = cardHand.cardAt(n4);
            Card card2 = cardHand.cardAt(n4 + 1);
            if (card == null || card2 == null || card.getCardSuit() != card2.getCardSuit()) {
                n3 = 0;
                break;
            }
            ++n4;
        }
        card = cardHand.cardAt(0);
        if (!bl && n3 == 4) {
            n2 = 4;
            if (card != null && card.getCardSuit() == n) {
                ++n2;
            }
        } else if (n3 == 4 && card != null && card.getCardSuit() == n) {
            n2 = 5;
        }
        return n2;
    }

    private int check15(CardHand cardHand, int n) {
        Card card;
        Card card2;
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 4) {
            n2 = n4 + 1;
            while (n2 < 5) {
                Card card3 = cardHand.cardAt(n4);
                Card card4 = cardHand.cardAt(n2);
                int n5 = 0;
                if (n2 == 4 && card3 != null) {
                    n5 = card3.getCardPointValueFace10() + n;
                } else if (card3 != null && card4 != null) {
                    n5 = card3.getCardPointValueFace10() + card4.getCardPointValueFace10();
                }
                if (n5 == 15) {
                    n3 += 2;
                }
                ++n2;
            }
            ++n4;
        }
        n2 = 0;
        while (n2 < 3) {
            int n6 = n2 + 1;
            while (n6 < 4) {
                int n7 = n6 + 1;
                while (n7 < 5) {
                    Card card5 = cardHand.cardAt(n2);
                    card2 = cardHand.cardAt(n6);
                    card = cardHand.cardAt(n7);
                    int n8 = 0;
                    if (card5 != null && card2 != null) {
                        n8 = card5.getCardPointValueFace10() + card2.getCardPointValueFace10();
                    }
                    if (n7 == 4) {
                        n8 += n;
                    } else if (card != null) {
                        n8 += card.getCardPointValueFace10();
                    }
                    if (n8 == 15) {
                        n3 += 2;
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n2;
        }
        int n9 = 0;
        while (n9 < 2) {
            int n10 = n9 + 1;
            while (n10 < 3) {
                int n11 = n10 + 1;
                while (n11 < 4) {
                    int n12 = n11 + 1;
                    while (n12 < 5) {
                        card = cardHand.cardAt(n9);
                        Card card6 = cardHand.cardAt(n10);
                        Card card7 = cardHand.cardAt(n11);
                        Card card8 = cardHand.cardAt(n12);
                        int n13 = 0;
                        if (card != null && card6 != null && card7 != null) {
                            n13 = card.getCardPointValueFace10() + card6.getCardPointValueFace10() + card7.getCardPointValueFace10();
                        }
                        if (n12 == 4) {
                            n13 += n;
                        } else if (card8 != null) {
                            n13 += card8.getCardPointValueFace10();
                        }
                        if (n13 == 15) {
                            n3 += 2;
                        }
                        ++n12;
                    }
                    ++n11;
                }
                ++n10;
            }
            ++n9;
        }
        int n14 = n;
        int n15 = 0;
        while (n15 < 4) {
            card2 = cardHand.cardAt(n15);
            if (card2 != null) {
                n14 += card2.getCardPointValueFace10();
            }
            ++n15;
        }
        if (n14 == 15) {
            n3 += 2;
        }
        return n3;
    }

    private int checkDups(CardHand cardHand, boolean bl, int n) {
        int n2 = 0;
        int[] nArray = new int[13];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        while (n4 < 4) {
            Card card = cardHand.cardAt(n4);
            if (card != null) {
                int n5 = card.getCardPointValue() - 1;
                nArray[n5] = nArray[n5] + 1;
            }
            ++n4;
        }
        if (bl) {
            int n6 = n - 1;
            nArray[n6] = nArray[n6] + 1;
        }
        int n7 = 0;
        while (n7 < nArray.length) {
            switch (nArray[n7]) {
                case 2: {
                    n2 += 2;
                    break;
                }
                case 3: {
                    n2 += 6;
                    break;
                }
                case 4: {
                    n2 += 12;
                    break;
                }
            }
            ++n7;
        }
        return n2;
    }

    private int checkRuns(CardHand cardHand, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int[] nArray = new int[5];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int[][] nArray2 = new int[11][6];
        int[][] nArray3 = new int[4][5];
        int[] nArray4 = new int[4];
        int n12 = 0;
        while (n12 < 4) {
            Card card = cardHand.cardAt(n12);
            nArray[n12] = card != null ? card.getCardPointValue() : 0;
            ++n12;
        }
        nArray[4] = n;
        int n13 = 0;
        while (n13 < nArray.length) {
            n7 = n13;
            while (n7 < nArray.length) {
                if (nArray[n13] > nArray[n7]) {
                    n9 = nArray[n7];
                    nArray[n7] = nArray[n13];
                    nArray[n13] = n9;
                }
                ++n7;
            }
            ++n13;
        }
        n7 = 0;
        while (n7 < 11) {
            int n14 = 0;
            while (n14 < 6) {
                nArray2[n7][n14] = CONQ[n7][n14];
                ++n14;
            }
            ++n7;
        }
        n10 = nArray[0] - nArray2[0][0];
        int n15 = 0;
        while (n15 < 11) {
            int n16 = 0;
            while (n16 < 5) {
                int[] nArray5 = nArray2[n15];
                int n17 = n16++;
                nArray5[n17] = nArray5[n17] + n10;
            }
            ++n15;
        }
        int n18 = 0;
        while (n18 < 11) {
            n6 = 0;
            while (n6 < 5) {
                if (nArray[n6] != nArray2[n18][n6]) break;
                if (n6 == 4) {
                    return nArray2[n18][5];
                }
                ++n6;
            }
            ++n18;
        }
        n6 = 0;
        while (n6 < 4) {
            int n19 = 0;
            while (n19 < 5) {
                nArray3[n6][n19] = CONR[n6][n19];
                ++n19;
            }
            ++n6;
        }
        int n20 = 0;
        while (n20 < 2) {
            n11 = nArray[n20] - nArray3[0][0];
            n5 = 0;
            while (n5 < 4) {
                n4 = 0;
                while (n4 < 4) {
                    int[] nArray6 = nArray3[n5];
                    int n21 = n4++;
                    nArray6[n21] = nArray6[n21] + n11;
                }
                ++n5;
            }
            n3 = 0;
            while (n3 < 4) {
                n2 = 0;
                while (n2 < 4) {
                    if (nArray[n2 + n20] != nArray3[n3][n2]) break;
                    if (n2 == 3) {
                        return nArray3[n3][4];
                    }
                    ++n2;
                }
                ++n3;
            }
            ++n20;
        }
        n5 = 0;
        while (n5 < 4) {
            nArray4[n5] = CONS[n5];
            ++n5;
        }
        n4 = 0;
        while (n4 < 3) {
            n11 = nArray[n4] - nArray4[0];
            n3 = 0;
            while (n3 < 3) {
                int n22 = n3++;
                nArray4[n22] = nArray4[n22] + n11;
            }
            n2 = 0;
            while (n2 < 3) {
                if (nArray[n4 + n2] != nArray4[n2]) break;
                if (n2 == 2) {
                    return nArray4[3];
                }
                ++n2;
            }
            ++n4;
        }
        return n8;
    }

    private int checkForRun(CardHand cardHand, int n) {
        int n2;
        int n3 = 0;
        int[] nArray = new int[20];
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            nArray[n5] = n5 < 10 ? 0 : 14;
            ++n5;
        }
        n4 = cardHand.getCardCount();
        int n6 = 0;
        while (n6 < n4) {
            Card card = cardHand.cardAt(n4 - n6 - 1);
            nArray[10 + n6] = card.getCardPointValue();
            ++n6;
        }
        int n7 = 0;
        while (n7 < n - 1) {
            n2 = n7 + 1;
            while (n2 < n) {
                if (nArray[n7 + 10] > nArray[n2 + 10]) {
                    n4 = nArray[n7 + 10];
                    nArray[n7 + 10] = nArray[n2 + 10];
                    nArray[n2 + 10] = n4;
                }
                ++n2;
            }
            ++n7;
        }
        n2 = 0;
        while (n2 < n - 1) {
            if (nArray[n2 + 10] != nArray[n2 + 11] - 1) {
                return n3;
            }
            ++n2;
        }
        return n;
    }

    public ArrayList getScoreMessages() {
        return new ArrayList(this.scoreMsgs);
    }

    public int figure_Points(CardHand cardHand, boolean bl, Card card) {
        int n = 0;
        int n2 = 25;
        int n3 = 25;
        int n4 = 25;
        boolean bl2 = false;
        if (card != null && card instanceof PlayingCard) {
            bl2 = true;
            n2 = card.getCardSuit();
            n3 = card.getCardPointValueFace10();
            n4 = card.getCardPointValue();
        }
        this.scoreMsgs.clear();
        n += this.checkForJack(cardHand, bl2, n2);
        n += this.checkFlush(cardHand, bl, n2);
        n += this.check15(cardHand, n3);
        n += this.checkDups(cardHand, bl2, n4);
        return n += this.checkRuns(cardHand, n4);
    }

    public int[] analyzeHandForDiscards(CardHand cardHand) {
        int[] nArray = new int[]{-1, -1};
        if (cardHand.getCardCount() == 6) {
            int n;
            int[][] nArray2 = new int[15][7];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int[] nArray3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int[] nArray4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int n5 = 0;
            while (n5 < 15) {
                int n6 = 0;
                while (n6 < 7) {
                    nArray2[n5][n6] = CONV[n5][n6];
                    ++n6;
                }
                ++n5;
            }
            int n7 = 0;
            while (n7 < 15) {
                CardHand cardHand2 = new CardHand(6);
                cardHand2.setCompMode(1);
                n = 0;
                while (n < 4) {
                    cardHand2.add(cardHand.cardAt(nArray2[n7][n]));
                    ++n;
                }
                nArray2[n7][6] = this.figure_Points(cardHand2, false, null);
                if (nArray2[n7][6] > n3) {
                    n3 = nArray2[n7][6];
                }
                ++n7;
            }
            int n8 = 0;
            while (n8 < 15) {
                if (nArray2[n8][6] == n3) {
                    nArray3[n4++] = n8;
                }
                ++n8;
            }
            n2 = nArray3[0];
            if (n4 != 1) {
                n = 5;
                int n9 = 1;
                do {
                    int n10;
                    int n11;
                    n3 = 0;
                    int n12 = 0;
                    while (n12 < nArray4.length) {
                        nArray4[n12] = 0;
                        ++n12;
                    }
                    int n13 = 0;
                    while (n13 < n4) {
                        n11 = 0;
                        while (n11 < 4) {
                            n10 = nArray2[nArray3[n13]][n11];
                            Card card = cardHand.cardAt(n10);
                            if (card != null && card.getCardPointValue() == n) {
                                int n14 = n13;
                                nArray4[n14] = nArray4[n14] + 1;
                                if (nArray4[n13] > n3) {
                                    n3 = nArray4[n13];
                                }
                            }
                            ++n11;
                        }
                        ++n13;
                    }
                    n11 = 0;
                    n10 = 0;
                    while (n10 < n4) {
                        if (nArray4[n10] != 0 && nArray4[n10] == n3) {
                            ++n11;
                            n2 = nArray3[n10];
                        }
                        ++n10;
                    }
                    if (n11 != 1) {
                        if (n11 != 0) {
                            int n15 = n4 - 2;
                            while (n15 >= 0) {
                                if (nArray4[n15] == 0) {
                                    int n16 = n15;
                                    while (n16 < n4 - 2) {
                                        nArray3[n16] = nArray3[n16 + 1];
                                        ++n16;
                                    }
                                }
                                --n15;
                            }
                            n4 = n11;
                        }
                        switch (++n9) {
                            case 2: {
                                n = 8;
                                break;
                            }
                            case 3: {
                                n = 7;
                                break;
                            }
                            case 4: {
                                n = 11;
                                break;
                            }
                            case 5: {
                                n = 1;
                                break;
                            }
                            default: {
                                n2 = nArray3[(int)Math.floor(Math.random() * (double)n4)];
                                n9 = 6;
                                break;
                            }
                        }
                        continue;
                    }
                    n9 = 6;
                } while (n9 < 6);
            }
            nArray[0] = nArray2[n2][4];
            nArray[1] = nArray2[n2][5];
        }
        return nArray;
    }

    public int getGameTally(CardHand cardHand) {
        int n = 0;
        int n2 = cardHand.getCardCount();
        int n3 = 0;
        while (n3 < n2) {
            Card card = cardHand.cardAt(n3);
            if (card != CardHand.EMPTY_CARD) {
                n += card.getCardPointValueFace10();
            }
            ++n3;
        }
        return n;
    }

    public int pointsInGame(CardHand cardHand) {
        int n = 0;
        int n2 = this.getGameTally(cardHand);
        int n3 = cardHand.getCardCount();
        int n4 = 2;
        int n5 = 0;
        this.scoreMsgs.clear();
        if (n3 > 1) {
            if (n2 == 15) {
                n += 2;
                this.scoreMsgs.add(" gets 2 points for fifteen.");
            }
            if (n2 == 31) {
                n += 2;
                this.scoreMsgs.add(" gets 2 points for thirtyone.");
            }
            if (n3 - 2 > 2) {
                n4 = n3 - 2;
            }
            int n6 = n3;
            while (n6 >= n4) {
                Card card = cardHand.cardAt(n6 - 1);
                Card card2 = cardHand.cardAt(n6 - 2);
                if (card == CardHand.EMPTY_CARD || card2 == CardHand.EMPTY_CARD || card.getCardPointValue() != card2.getCardPointValue()) break;
                switch (n3 - n6 + 1) {
                    case 1: {
                        n += 2;
                        n5 = 1;
                        break;
                    }
                    case 2: {
                        n += 4;
                        n5 = 2;
                        break;
                    }
                    case 3: {
                        n += 6;
                        n5 = 3;
                    }
                }
                --n6;
            }
            if (n5 != 0) {
                switch (n5) {
                    case 1: {
                        this.scoreMsgs.add(" gets 2 points for a pair.");
                        break;
                    }
                    case 2: {
                        this.scoreMsgs.add(" gets 6 points for three-of-a-kind.");
                        break;
                    }
                    case 3: {
                        this.scoreMsgs.add(" gets 12 points for four-of-a-kind.");
                    }
                }
            }
            if (n3 > 2) {
                n4 = 0;
                int n7 = 3;
                int n8 = 0;
                while (n7 <= n3) {
                    n4 = this.checkForRun(cardHand, n7);
                    if (n4 != 0) {
                        n8 = n4;
                    }
                    ++n7;
                }
                if (n8 != 0) {
                    this.scoreMsgs.add(" gets " + n8 + " points for a " + n8 + " card run.");
                }
                n += n8;
            }
        }
        return n;
    }

    public int getCardToPlay(CardHand cardHand, CardHand cardHand2) {
        int n = -1;
        int n2 = cardHand.getCardCount();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n7 = 0;
        while (n7 < 4) {
            Card card = cardHand2.cardAt(n7);
            if (card != CardHand.EMPTY_CARD && this.getGameTally(cardHand) + card.getCardPointValueFace10() <= 31) {
                cardHand.add(card);
                n3 = this.pointsInGame(cardHand);
                cardHand.remove(n2);
                if (n3 > n4) {
                    n4 = n3;
                    n = n7;
                }
                if (card.getCardPointValue() == 5 && cardHand.getCardCount() == 0) {
                    nArray2[n6++] = n7;
                } else {
                    nArray[n5++] = n7;
                }
            }
            ++n7;
        }
        if (n == -1 && n5 != 0) {
            n = n5 == 1 ? nArray[0] : nArray[(int)Math.floor(Math.random() * (double)n5)];
        }
        if (n == -1 && n6 != 0) {
            n = n6 == 1 ? nArray2[0] : nArray2[(int)Math.floor(Math.random() * (double)n6)];
        }
        this.scoreMsgs.clear();
        return n;
    }

    public static final class Test {
        CribbageEngine ce = new CribbageEngine();
        CardDeck deck = new CardDeck(PlayingCardDeck.PC_DECK, class$com$slackandassociates$cards$playingcards$PlayingCard == null ? (class$com$slackandassociates$cards$playingcards$PlayingCard = Test.class$("com.slackandassociates.cards.playingcards.PlayingCard")) : class$com$slackandassociates$cards$playingcards$PlayingCard);
        CardHand playedCards = new CardHand(8, false);
        CardHand hand1 = new CardHand(6);
        CardHand hand2 = new CardHand(6);
        CardHand h1 = new CardHand(4);
        CardHand h2 = new CardHand(4);
        CardHand crib = new CardHand(4);
        Card upCard = null;
        static /* synthetic */ Class class$com$slackandassociates$cards$playingcards$PlayingCard;

        private void setup() {
            this.hand1.setCompMode(1);
            this.hand2.setCompMode(1);
            this.h1.setCompMode(1);
            this.h2.setCompMode(1);
            this.deck.shuffle();
            int n = 0;
            while (n < 6) {
                this.hand1.add(this.deck.getNextCard());
                this.hand2.add(this.deck.getNextCard());
                ++n;
            }
        }

        private void showHands(boolean bl, boolean bl2, boolean bl3) {
            System.out.println("----- Hands -----");
            if (bl3) {
                System.out.println("Hand 1: " + this.h1);
                System.out.println("Hand 2: " + this.h2);
            } else {
                System.out.println("Hand 1: " + this.hand1);
                System.out.println("Hand 2: " + this.hand2);
            }
            if (bl) {
                System.out.println("Crib: " + this.crib);
            }
            if (bl2) {
                System.out.println("Played: " + this.playedCards);
            }
        }

        private void doDiscard(int[] nArray, int[] nArray2) {
            this.crib.add(this.hand1.remove(nArray[0]));
            this.crib.add(this.hand1.remove(nArray[1]));
            this.crib.add(this.hand2.remove(nArray2[0]));
            this.crib.add(this.hand2.remove(nArray2[1]));
            this.hand1.compressHand();
            this.hand2.compressHand();
            this.upCard = this.deck.getNextCard();
        }

        private void doPlay() {
            int n = -1;
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            int n5 = 0;
            while (n5 < 4) {
                this.h1.add(this.hand1.cardAt(n5));
                this.h2.add(this.hand2.cardAt(n5));
                ++n5;
            }
            int n6 = 0;
            while (n6 < 2) {
                Iterator iterator;
                n = this.ce.getCardToPlay(this.playedCards, this.h1);
                if (n != -1) {
                    this.playedCards.add(this.h1.remove(n));
                }
                n3 = this.ce.pointsInGame(this.playedCards);
                arrayList = this.ce.getScoreMessages();
                n2 = this.ce.getCardToPlay(this.playedCards, this.h2);
                if (n2 != -1) {
                    this.playedCards.add(this.h2.remove(n2));
                    n4 = this.ce.pointsInGame(this.playedCards);
                    arrayList2 = this.ce.getScoreMessages();
                } else {
                    n4 = 0;
                    arrayList2.clear();
                }
                System.out.println("--- Playing ---");
                System.out.println("Hand 1 plays - " + n + ", scores: " + n3);
                if (!arrayList.isEmpty()) {
                    iterator = ((AbstractList)arrayList).iterator();
                    while (iterator.hasNext()) {
                        System.out.println(" Hand 1" + (String)iterator.next());
                    }
                }
                System.out.println("Hand 2 plays - " + n2 + ", scores: " + n4);
                if (!arrayList2.isEmpty()) {
                    iterator = ((AbstractList)arrayList2).iterator();
                    while (iterator.hasNext()) {
                        System.out.println(" Hand 2" + (String)iterator.next());
                    }
                }
                this.showHands(false, true, true);
                ++n6;
            }
        }

        private void doPoints() {
            int n = this.ce.figure_Points(this.hand1, false, this.upCard);
            int n2 = this.ce.figure_Points(this.hand2, false, this.upCard);
            int n3 = this.ce.figure_Points(this.crib, true, this.upCard);
            System.out.println("----- Scores (with upcard) -----");
            System.out.println("Hand 1: " + n + ", Hand 2: " + n2 + ", Crib: " + n3);
        }

        public void go() {
            this.setup();
            this.showHands(false, false, false);
            int[] nArray = this.ce.analyzeHandForDiscards(this.hand1);
            int[] nArray2 = this.ce.analyzeHandForDiscards(this.hand2);
            System.out.println("----- Have crib discards now -----");
            System.out.println("Hand 1 discards (index's): " + nArray[0] + ", " + nArray[1]);
            System.out.println("Hand 2 discards (index's): " + nArray2[0] + ", " + nArray2[1]);
            this.doDiscard(nArray, nArray2);
            this.showHands(true, false, false);
            System.out.println("----- Upcard dealt -----");
            System.out.println("Upcard - " + this.upCard);
            this.doPlay();
            this.doPoints();
        }

        public static void main(String[] stringArray) {
            Test test = new Test();
            test.go();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

