/*
 * Decompiled with CFR 0.152.
 */
import com.slackandassociates.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class CribbageHelp
extends JDialog
implements HyperlinkListener {
    private static final int D_HLP_WIDTH = 500;
    private static final int D_HLP_HEIGHT = 320;
    private static final String S_LOADMSG = "<html><body><br><br>Loading page, please wait...</body></html>";
    private static final String S_ERR1 = "<html><body>Page load failed for page (<b>";
    private static final String S_ERR2 = "</b>).</body></html>";
    private JEditorPane help = new JEditorPane();
    private JScrollPane scroller = new JScrollPane(this.help);
    private JPanel dPnl1 = new JPanel();
    private JButton dB1 = new JButton("Exit");
    private String helpPath = "";
    private String gPgNm = "fake";
    private URL gURLPg = null;

    public CribbageHelp(JFrame jFrame, String string) {
        super(jFrame, "Cribbage Help", true);
        this.helpPath = string;
        this.setupHelpDlg(jFrame);
    }

    private void setupHelpDlg(JFrame jFrame) {
        Container container = this.getContentPane();
        ((Component)this).setSize(500, 320);
        Utilities.centerDialog(jFrame, this);
        container.setLayout(new BorderLayout());
        container.add((Component)this.scroller, "Center");
        this.dB1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CribbageHelp.this.dispose();
            }
        });
        this.dPnl1.add(this.dB1);
        container.add((Component)this.dPnl1, "South");
        this.initEditorPane();
    }

    private void initEditorPane() {
        this.help.setEditorKit(new HTMLEditorKit());
        this.help.setEditable(false);
        this.help.addHyperlinkListener(this);
        this.loadPage("index.html", null);
    }

    protected void loadPage(String string, URL uRL) {
        this.help.setText(S_LOADMSG);
        this.gPgNm = string;
        this.gURLPg = uRL;
        Runnable runnable = new Runnable(){

            public void run() {
                String string = CribbageHelp.S_ERR1 + CribbageHelp.this.gPgNm + CribbageHelp.S_ERR2;
                URL uRL = null;
                try {
                    String string2 = CribbageHelp.this.helpPath + CribbageHelp.this.gPgNm;
                    uRL = CribbageHelp.this.gURLPg == null ? this.getClass().getResource(string2) : CribbageHelp.this.gURLPg;
                    if (uRL != null) {
                        CribbageHelp.this.help.setPage(uRL);
                    } else {
                        System.err.println("Help file returned null - " + string2);
                        CribbageHelp.this.help.setText(string);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Failed help file read (" + CribbageHelp.this.gPgNm + "): " + exception);
                    CribbageHelp.this.help.setText(string);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLDocument hTMLDocument = (HTMLDocument)this.help.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
            } else {
                this.loadPage("", hyperlinkEvent.getURL());
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = Utilities.createTestFrame("Help Test", 500, 320);
        new CribbageHelp(jFrame, "help/").show();
    }
}

