/*
 * Decompiled with CFR 0.152.
 */
import com.slackandassociates.Utilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.accessibility.AccessibleContext;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class StdCribBoard
extends JComponent
implements CribBoard {
    private static final int BRD_WIDTH = 641;
    private static final int BRD_HEIGHT = 156;
    private static final int MAX_PLAYERS = 2;
    private static final int MAX_SCORE = 121;
    private static final String NOT_INIT_MSG = "Cribbage board not initialized.";
    private static final String SND_FILE_NAME = "tac.wav";
    private static final int CB_EMPTY = 1;
    private static final int CB_BLUE = 2;
    private static final int CB_RED = 3;
    private static final int[][] DEF_BOARD = new int[][]{{0, 2, 0, 4, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0}, {0, 2, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 3, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0}, {0, 3, 0, 4, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0}};
    private static final int[][][] BOARD_POS = new int[][][]{new int[][]{{4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}, {10, 0}, {11, 0}, {12, 0}, {13, 0}, {14, 0}, {16, 0}, {17, 0}, {18, 0}, {19, 0}, {20, 0}, {22, 0}, {23, 0}, {24, 0}, {25, 0}, {26, 0}, {28, 0}, {29, 0}, {30, 0}, {31, 0}, {32, 0}, {34, 0}, {35, 0}, {36, 0}, {37, 0}, {38, 0}, {38, 1}, {37, 1}, {36, 1}, {35, 1}, {34, 1}, {32, 1}, {31, 1}, {30, 1}, {29, 1}, {28, 1}, {26, 1}, {25, 1}, {24, 1}, {23, 1}, {22, 1}, {20, 1}, {19, 1}, {18, 1}, {17, 1}, {16, 1}, {14, 1}, {13, 1}, {12, 1}, {11, 1}, {10, 1}, {8, 1}, {7, 1}, {6, 1}, {5, 1}, {4, 1}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}, {10, 0}, {11, 0}, {12, 0}, {13, 0}, {14, 0}, {16, 0}, {17, 0}, {18, 0}, {19, 0}, {20, 0}, {22, 0}, {23, 0}, {24, 0}, {25, 0}, {26, 0}, {28, 0}, {29, 0}, {30, 0}, {31, 0}, {32, 0}, {34, 0}, {35, 0}, {36, 0}, {37, 0}, {38, 0}, {38, 1}, {37, 1}, {36, 1}, {35, 1}, {34, 1}, {32, 1}, {31, 1}, {30, 1}, {29, 1}, {28, 1}, {26, 1}, {25, 1}, {24, 1}, {23, 1}, {22, 1}, {20, 1}, {19, 1}, {18, 1}, {17, 1}, {16, 1}, {14, 1}, {13, 1}, {12, 1}, {11, 1}, {10, 1}, {8, 1}, {7, 1}, {6, 1}, {5, 1}, {4, 1}, {1, 1}}, new int[][]{{4, 4}, {5, 4}, {6, 4}, {7, 4}, {8, 4}, {10, 4}, {11, 4}, {12, 4}, {13, 4}, {14, 4}, {16, 4}, {17, 4}, {18, 4}, {19, 4}, {20, 4}, {22, 4}, {23, 4}, {24, 4}, {25, 4}, {26, 4}, {28, 4}, {29, 4}, {30, 4}, {31, 4}, {32, 4}, {34, 4}, {35, 4}, {36, 4}, {37, 4}, {38, 4}, {38, 3}, {37, 3}, {36, 3}, {35, 3}, {34, 3}, {32, 3}, {31, 3}, {30, 3}, {29, 3}, {28, 3}, {26, 3}, {25, 3}, {24, 3}, {23, 3}, {22, 3}, {20, 3}, {19, 3}, {18, 3}, {17, 3}, {16, 3}, {14, 3}, {13, 3}, {12, 3}, {11, 3}, {10, 3}, {8, 3}, {7, 3}, {6, 3}, {5, 3}, {4, 3}, {4, 4}, {5, 4}, {6, 4}, {7, 4}, {8, 4}, {10, 4}, {11, 4}, {12, 4}, {13, 4}, {14, 4}, {16, 4}, {17, 4}, {18, 4}, {19, 4}, {20, 4}, {22, 4}, {23, 4}, {24, 4}, {25, 4}, {26, 4}, {28, 4}, {29, 4}, {30, 4}, {31, 4}, {32, 4}, {34, 4}, {35, 4}, {36, 4}, {37, 4}, {38, 4}, {38, 3}, {37, 3}, {36, 3}, {35, 3}, {34, 3}, {32, 3}, {31, 3}, {30, 3}, {29, 3}, {28, 3}, {26, 3}, {25, 3}, {24, 3}, {23, 3}, {22, 3}, {20, 3}, {19, 3}, {18, 3}, {17, 3}, {16, 3}, {14, 3}, {13, 3}, {12, 3}, {11, 3}, {10, 3}, {8, 3}, {7, 3}, {6, 3}, {5, 3}, {4, 3}, {1, 3}}};
    private boolean bInitialized = false;
    private Dimension dim = new Dimension(641, 156);
    private EventListenerList listenerList = new EventListenerList();
    private Image imgArrow = null;
    private Image imgBlank = null;
    private Image imgBluePeg = null;
    private Image imgEmptyPeg = null;
    private Image imgRedPeg = null;
    private boolean bSoundLoaded = false;
    private boolean bSoundOn = false;
    private byte[] snd;
    private int snd_len = 0;
    private AudioFormat format = null;
    private DataLine.Info info = null;
    private SourceDataLine sdl = null;
    private int[] playerScore = new int[]{0, 0};
    private int[][] board = new int[5][40];
    private int p1PegP = 120;
    private int p2PegP = 120;
    private CribbageProps props = new CribbageProps(this);
    private CribBoardEvent cbe = null;
    static /* synthetic */ Class class$CribBoardListener;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public StdCribBoard() {
        this(true);
    }

    public StdCribBoard(boolean bl) {
        this.setPreferredSize(this.dim);
        if (bl) {
            try {
                this.initializeBoard();
            }
            catch (Exception exception) {
                System.err.println("StdCribBoard constructor (init): " + exception.toString());
            }
        }
    }

    private Image loadImage(String string) {
        return Utilities.loadImage(this, this.getToolkit(), this.props.getImagePath(), string);
    }

    /*
     * Loose catch block
     */
    private void loadSound() {
        block13: {
            AudioInputStream audioInputStream = null;
            this.bSoundLoaded = true;
            String string = this.props.getSoundPath();
            InputStream inputStream = this.getClass().getResourceAsStream(string + SND_FILE_NAME);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
            int n = 0;
            int n2 = 0;
            this.format = audioInputStream.getFormat();
            n2 = (int)audioInputStream.getFrameLength() * this.format.getFrameSize();
            this.snd = new byte[n2];
            this.snd_len = 0;
            do {
                if ((n = audioInputStream.read()) == -1) continue;
                this.snd[this.snd_len++] = (byte)n;
            } while (n != -1);
            if (this.snd_len < n2) {
                throw new CribbageException("Only read " + this.snd_len + " bytes of " + n2);
            }
            Object var8_8 = null;
            try {
                if (audioInputStream != null) {
                    audioInputStream.close();
                }
                break block13;
            }
            catch (Exception exception) {}
            break block13;
            {
                catch (Exception exception) {
                    System.err.println("Sound Load Error: " + exception);
                    this.bSoundLoaded = false;
                    Object var8_9 = null;
                    try {
                        if (audioInputStream != null) {
                            audioInputStream.close();
                        }
                        break block13;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (audioInputStream != null) {
                        audioInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void fireCribEvent(int n, String string, int n2) {
        this.cbe = n2 != -1 ? new CribBoardEvent(this, true, n2) : (string != null && !"".equals(string) ? new CribBoardEvent((Object)this, string) : new CribBoardEvent((Object)this, n));
        SwingUtilities.invokeLater(new Runnable(){
            static /* synthetic */ Class class$CribBoardListener;

            public void run() {
                CribBoardEvent cribBoardEvent = StdCribBoard.this.cbe;
                Object[] objectArray = StdCribBoard.this.listenerList.getListenerList();
                int n = objectArray.length - 2;
                while (n >= 0) {
                    if (objectArray[n] == (class$CribBoardListener == null ? 1.class$("CribBoardListener") : class$CribBoardListener)) {
                        ((CribBoardListener)objectArray[n + 1]).update(cribBoardEvent);
                    }
                    n -= 2;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 1;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.dim.width, this.dim.height);
        if (this.bInitialized) {
            int n3 = 0;
            while (n3 < 5) {
                n = 1;
                int n4 = 0;
                while (n4 < 40) {
                    switch (this.board[n3][n4]) {
                        case 0: {
                            graphics.drawImage(this.imgBlank, n, n2, this);
                            break;
                        }
                        case 1: {
                            graphics.drawImage(this.imgEmptyPeg, n, n2, this);
                            break;
                        }
                        case 2: {
                            graphics.drawImage(this.imgBluePeg, n, n2, this);
                            break;
                        }
                        case 3: {
                            graphics.drawImage(this.imgRedPeg, n, n2, this);
                            break;
                        }
                        case 4: {
                            graphics.drawImage(this.imgArrow, n, n2, this);
                            break;
                        }
                    }
                    n += this.imgBlank.getWidth(null) + 1;
                    ++n4;
                }
                n2 += this.imgBlank.getHeight(null) + 1;
                ++n3;
            }
        }
    }

    public void addCribBoardListener(CribBoardListener cribBoardListener) {
        this.listenerList.add(class$CribBoardListener == null ? (class$CribBoardListener = StdCribBoard.class$("CribBoardListener")) : class$CribBoardListener, cribBoardListener);
    }

    public void removeCribBoardListener(CribBoardListener cribBoardListener) {
        this.listenerList.remove(class$CribBoardListener == null ? (class$CribBoardListener = StdCribBoard.class$("CribBoardListener")) : class$CribBoardListener, cribBoardListener);
    }

    public void initializeBoard() throws CribbageInitException {
        if (!this.bInitialized) {
            this.bInitialized = true;
            this.imgArrow = this.loadImage("arrow.gif");
            this.imgBlank = this.loadImage("blank.gif");
            this.imgBluePeg = this.loadImage("bluepeg.gif");
            this.imgEmptyPeg = this.loadImage("emptypeg.gif");
            this.imgRedPeg = this.loadImage("redpeg.gif");
            this.bInitialized = this.imgArrow != null && this.imgBlank != null && this.imgBluePeg != null && this.imgEmptyPeg != null && this.imgRedPeg != null;
            this.loadSound();
            if (this.bInitialized) {
                try {
                    this.resetBoard();
                }
                catch (Exception exception) {
                    this.bInitialized = false;
                }
            }
        }
    }

    public void resetBoard() throws CribbageNotInitException {
        if (!this.bInitialized) {
            throw new CribbageNotInitException("resetBoard(): Cribbage board not initialized.");
        }
        int n = 0;
        while (n < this.playerScore.length) {
            this.playerScore[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            int n3 = 0;
            while (n3 < 40) {
                this.board[n2][n3] = DEF_BOARD[n2][n3];
                ++n3;
            }
            ++n2;
        }
        this.p1PegP = 120;
        this.p2PegP = 120;
        this.repaint();
        this.fireCribEvent(4, "", -1);
    }

    public boolean movePeg(int n) throws CribbageRangeException, CribbageNotInitException {
        return this.movePeg(n, 1);
    }

    public boolean movePeg(int n, int n2) throws CribbageRangeException, CribbageNotInitException {
        if (!this.bInitialized) {
            throw new CribbageNotInitException("movePeg(int): Cribbage board not initialized.");
        }
        if (n < 0 || n >= 2) {
            throw new CribbageRangeException("Player is out of range - (" + n + ")");
        }
        this.fireCribEvent(2, "", -1);
        boolean bl = this.playerScore[n] + n2 >= 121;
        new MovePeg(this, n, n2).start();
        return bl;
    }

    public int getScore(int n) throws CribbageRangeException {
        if (n < 0 || n >= 2) {
            throw new CribbageRangeException("Player is out of range - (" + n + ")");
        }
        return this.playerScore[n];
    }

    public int getMaxScore() {
        return 121;
    }

    public boolean hasWon(int n) throws CribbageRangeException {
        if (n < 0 || n >= 2) {
            throw new CribbageRangeException("Player is out of range - (" + n + ")");
        }
        return this.playerScore[n] >= 121;
    }

    public int getWinner() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.playerScore.length) {
            try {
                if (this.hasWon(n2)) {
                    n = n2;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return n;
    }

    public int getMaxNumberOfPlayers() {
        return 2;
    }

    public int getNumberOfPlayers() {
        return 2;
    }

    public void setNumberOfPlayers(int n) throws CribbageRangeException {
        if (n < 2 || n > 2) {
            throw new CribbageRangeException("Max players can only be set to 2 - tried: " + n + ".");
        }
    }

    public boolean hasSoundEffects() {
        return this.bSoundLoaded;
    }

    public void setSoundOn(boolean bl) {
        if (bl && this.bSoundLoaded) {
            try {
                if (this.info == null) {
                    this.info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = StdCribBoard.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, this.format);
                }
                if (this.sdl == null) {
                    this.sdl = (SourceDataLine)AudioSystem.getLine(this.info);
                }
                if (!this.bSoundOn) {
                    this.sdl.open(this.format, this.snd_len);
                }
            }
            catch (Exception exception) {
                System.err.println("Sound On Error: " + exception);
                this.bSoundLoaded = false;
            }
        } else if (this.bSoundLoaded) {
            try {
                if (this.sdl != null) {
                    this.sdl.close();
                }
                this.sdl = null;
            }
            catch (Exception exception) {
                System.err.println("Sound Off Error: " + exception);
            }
        }
        if (this.bSoundLoaded) {
            this.bSoundOn = bl;
        }
    }

    public boolean isSoundOn() {
        return this.bSoundOn;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MovePeg
    extends Thread {
        private JComponent owner = null;
        private int iPlayer = 0;
        private int iMoves = 0;

        public MovePeg() {
        }

        public MovePeg(JComponent jComponent, int n, int n2) {
            this.owner = jComponent;
            this.iPlayer = n;
            this.iMoves = n2;
        }

        private void moveOneSpace(int n, int n2, int n3, int n4, int n5) {
            ((StdCribBoard)StdCribBoard.this).board[n2][n] = 1;
            ((StdCribBoard)StdCribBoard.this).board[n4][n3] = n5;
            if (this.owner != null) {
                this.owner.repaint();
            }
        }

        private void playPegSound() {
            PegSound pegSound = null;
            if (StdCribBoard.this.bSoundLoaded && StdCribBoard.this.bSoundOn) {
                pegSound = new PegSound();
                pegSound.start();
            }
            try {
                if (StdCribBoard.this.bSoundLoaded && !StdCribBoard.this.bSoundOn || !StdCribBoard.this.bSoundLoaded) {
                    Thread.sleep(200L);
                } else {
                    pegSound.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            if (StdCribBoard.this.playerScore[this.iPlayer] < 121 && this.iMoves > 0) {
                int n = StdCribBoard.this.playerScore[this.iPlayer];
                int n2 = this.iPlayer == 0 ? StdCribBoard.this.p1PegP : StdCribBoard.this.p2PegP;
                int n3 = this.iPlayer == 0 ? 2 : 3;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                boolean bl = false;
                if (n != 0) {
                    n4 = BOARD_POS[this.iPlayer][n2][0];
                    n5 = BOARD_POS[this.iPlayer][n2][1];
                    if (this.iPlayer == 0) {
                        StdCribBoard.this.p1PegP = n - 1;
                    } else {
                        StdCribBoard.this.p2PegP = n - 1;
                    }
                } else {
                    n4 = 1;
                    n5 = this.iPlayer == 0 ? 0 : 4;
                }
                int n8 = 0;
                while (n8 < this.iMoves) {
                    this.playPegSound();
                    n = StdCribBoard.this.playerScore[this.iPlayer];
                    int[] nArray = StdCribBoard.this.playerScore;
                    int n9 = this.iPlayer;
                    nArray[n9] = nArray[n9] + 1;
                    n6 = BOARD_POS[this.iPlayer][n][0];
                    n7 = BOARD_POS[this.iPlayer][n][1];
                    this.moveOneSpace(n4, n5, n6, n7, n3);
                    n5 = n7;
                    n4 = n6;
                    if (StdCribBoard.this.playerScore[this.iPlayer] >= 121) break;
                    ++n8;
                }
            }
            if (StdCribBoard.this.playerScore[this.iPlayer] >= 121) {
                StdCribBoard.this.fireCribEvent(5, "", this.iPlayer);
            } else {
                StdCribBoard.this.fireCribEvent(3, "", -1);
            }
        }
    }

    class PegSound
    extends Thread {
        public void run() {
            try {
                StdCribBoard.this.sdl.start();
                StdCribBoard.this.sdl.write(StdCribBoard.this.snd, 0, StdCribBoard.this.snd.length);
                StdCribBoard.this.sdl.drain();
                StdCribBoard.this.sdl.stop();
            }
            catch (Exception exception) {
                System.err.println("Sound Playback Error: " + exception);
                StdCribBoard.this.bSoundLoaded = false;
            }
        }
    }
}

