/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jbinder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class CurvedBorder
implements Border {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    public static final int ROUNDED = 0;
    public static final int PLATEAU = 1;
    protected int type = 0;
    protected int curve = 0;
    protected int thickness = 1;
    protected int percent = 10;
    protected Color start;

    public CurvedBorder() {
        this(0, 0, 5, 10, null);
    }

    public CurvedBorder(int n) {
        this(0, 0, n, 10, null);
    }

    public CurvedBorder(int n, int n2, int n3) {
        this(n, n2, n3, 10, null);
    }

    public CurvedBorder(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null);
    }

    public CurvedBorder(int n, int n2, int n3, int n4, Color color) {
        this.type = n;
        this.curve = n2;
        this.thickness = n3;
        this.percent = n4;
        this.start = color;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Color getStartColor(Component component) {
        if (this.start == null) {
            this.start = component.getBackground();
        }
        return this.start;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.getStartColor(component);
        Color color2 = this.getStartColor(component);
        if (this.curve == 0) {
            for (int i = this.thickness - 1; i >= 0; --i) {
                this.drawLines(graphics, color, color2, n, n2, n3, n4, i);
                if (this.type == 0) {
                    color = CurvedBorder.brighter(color, this.percent);
                    color2 = CurvedBorder.darker(color2, this.percent);
                    continue;
                }
                color = CurvedBorder.darker(color, this.percent);
                color2 = CurvedBorder.brighter(color2, this.percent);
            }
        } else {
            for (int i = 0; i < this.thickness; ++i) {
                this.drawLines(graphics, color, color2, n, n2, n3, n4, i);
                if (this.type == 0) {
                    color = CurvedBorder.brighter(color, this.percent);
                    color2 = CurvedBorder.darker(color2, this.percent);
                    continue;
                }
                color = CurvedBorder.darker(color, this.percent);
                color2 = CurvedBorder.brighter(color2, this.percent);
            }
        }
    }

    private void drawLines(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(color);
        graphics.drawLine(n + n5, n2 + n5, n + n3 - n5 - 1, n2 + n5);
        graphics.drawLine(n + n5, n2 + n5, n + n5, n + n4 - n5 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n + n3 - n5 - 1, n2 + n5, n + n3 - n5 - 1, n2 + n4 - n5 - 1);
        graphics.drawLine(n + n5, n2 + n4 - n5 - 1, n + n3 - n5 - 1, n2 + n4 - n5 - 1);
    }

    public static Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        double d2 = d / 100.0;
        int n4 = n + (int)((double)(255 - n) * d2);
        int n5 = n2 + (int)((double)(255 - n2) * d2);
        int n6 = n3 + (int)((double)(255 - n3) * d2);
        return new Color(n4, n5, n6);
    }

    public static Color darker(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        double d2 = d / 100.0;
        int n4 = Math.max((int)((double)n * (1.0 - d2)), 0);
        int n5 = Math.max((int)((double)n2 * (1.0 - d2)), 0);
        int n6 = Math.max((int)((double)n3 * (1.0 - d2)), 0);
        return new Color(n4, n5, n6);
    }
}

