/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jhexedit;

import com.javapro.jhexedit.HexData;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HexFile
extends RandomAccessFile
implements HexData {
    public static final int ROW_SIZE = 16;
    protected int size = (int)this.length();

    public HexFile(String string) throws IOException {
        this(new File(string));
    }

    public HexFile(File file) throws IOException {
        super(file, "rw");
    }

    public int getRowCount() {
        int n = this.size / 16;
        if (n * 16 < this.size) {
            ++n;
        }
        return n;
    }

    public int getColumnCount() {
        return 16;
    }

    public int getLastRowSize() {
        int n = (this.getRowCount() - 1) * 16;
        if (this.size - n == 0) {
            return 16;
        }
        return this.size - n;
    }

    public byte getByte(int n, int n2) {
        try {
            this.seek(n * 16 + n2);
            return (byte)this.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    public void setByte(int n, int n2, byte by) {
        try {
            this.seek(n * 16 + n2);
            this.write(by);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] getRow(int n) {
        int n2 = 16;
        if (n == this.getRowCount() - 1) {
            n2 = this.getLastRowSize();
        }
        byte[] byArray = new byte[n2];
        try {
            this.seek(n * 16);
            this.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return byArray;
        }
    }
}

