/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jhexedit;

import com.javapro.jhexedit.HexData;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class HexTableModel
implements TableModel {
    protected static final String HEX = "0123456789ABCDEF";
    protected ArrayList listeners = new ArrayList();
    protected String[] names = new String[]{"Address", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "Text"};
    protected HexData data;
    static /* synthetic */ Class class$java$lang$String;

    public HexTableModel(HexData hexData) {
        this.data = hexData;
    }

    protected String byteToHex(int n) {
        int n2 = (n & 0xF0) >> 4;
        int n3 = n & 0xF;
        return "" + HEX.charAt(n2) + HEX.charAt(n3);
    }

    protected String intToHex(int n) {
        int n2 = (n & 0xFF00) >> 8;
        int n3 = n & 0xFF;
        return this.byteToHex(n2) + this.byteToHex(n3);
    }

    public Class getColumnClass(int n) {
        return class$java$lang$String == null ? (class$java$lang$String = HexTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public String getColumnName(int n) {
        return this.names[n];
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public boolean isCellEditable(int n, int n2) {
        if (n == this.getRowCount() - 1 && n2 >= this.data.getLastRowSize()) {
            return false;
        }
        int n3 = this.getColumnCount() - 1;
        return n2 != 0 && n2 != n3;
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.getColumnCount() - 1;
        if (n2 == 0) {
            return this.intToHex(n * 16) + ":";
        }
        if (n2 == n3) {
            return new String(this.data.getRow(n));
        }
        if (n == this.data.getRowCount() - 1 && n2 >= this.data.getLastRowSize()) {
            return "";
        }
        return this.byteToHex(this.data.getByte(n, n2 - 1));
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = object.toString();
        this.data.setByte(n, n2 - 1, (byte)Integer.parseInt(string, 16));
        int n3 = this.getColumnCount() - 1;
        this.fireModelChangeEvent(n, n2 - 1);
        this.fireModelChangeEvent(n, n3);
    }

    protected void fireModelChangeEvent(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            TableModelListener tableModelListener = (TableModelListener)arrayList.get(i);
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

