/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jsequence;

import com.javapro.jsequence.SequenceEvent;
import com.javapro.jsequence.SequenceItem;
import com.javapro.jsequence.SequenceListener;
import java.util.ArrayList;

public abstract class AbstractSequenceItem
implements SequenceItem {
    protected String text;
    protected ArrayList listeners = new ArrayList();

    public AbstractSequenceItem(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void addSequenceListener(SequenceListener sequenceListener) {
        this.listeners.add(sequenceListener);
    }

    public void removeSequenceListener(SequenceListener sequenceListener) {
        this.listeners.remove(sequenceListener);
    }

    public void fireProgressReady(int n) {
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        SequenceEvent sequenceEvent = new SequenceEvent(this, 1, n);
        for (int i = 0; i < arrayList.size(); ++i) {
            SequenceListener sequenceListener = (SequenceListener)arrayList.get(i);
            sequenceListener.progressReady(sequenceEvent);
        }
    }

    public void fireProgressUpdate(int n) {
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        SequenceEvent sequenceEvent = new SequenceEvent(this, 2, n);
        for (int i = 0; i < arrayList.size(); ++i) {
            SequenceListener sequenceListener = (SequenceListener)arrayList.get(i);
            sequenceListener.progressUpdate(sequenceEvent);
        }
    }

    public void fireProgressDone(int n) {
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        SequenceEvent sequenceEvent = new SequenceEvent(this, 3, n);
        for (int i = 0; i < arrayList.size(); ++i) {
            SequenceListener sequenceListener = (SequenceListener)arrayList.get(i);
            sequenceListener.progressDone(sequenceEvent);
        }
    }
}

