/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jsequence;

import com.javapro.jsequence.SequenceEvent;
import com.javapro.jsequence.SequenceItem;
import com.javapro.jsequence.SequenceItemView;
import com.javapro.jsequence.SequenceList;
import com.javapro.jsequence.SequenceListener;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JSequence
extends JPanel
implements SequenceListener {
    protected SequenceList list;
    protected int current = 0;

    public JSequence(SequenceList sequenceList) {
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.list = sequenceList;
        this.setLayout(new BoxLayout(this, 1));
        int n = sequenceList.getSequenceItemCount();
        for (int i = 0; i < n; ++i) {
            SequenceItemView sequenceItemView = new SequenceItemView();
            SequenceItem sequenceItem = sequenceList.getSequenceItem(i);
            sequenceItem.addSequenceListener(this);
            sequenceItem.addSequenceListener(sequenceItemView);
            this.add(sequenceItemView);
        }
    }

    public void execute() {
        int n = this.list.getSequenceItemCount();
        if (n > 0) {
            this.current = 0;
            this.list.getSequenceItem(0).execute();
        }
    }

    public void progressReady(SequenceEvent sequenceEvent) {
    }

    public void progressUpdate(SequenceEvent sequenceEvent) {
    }

    public void progressDone(SequenceEvent sequenceEvent) {
        int n = this.list.getSequenceItemCount();
        ++this.current;
        if (this.current < n) {
            this.list.getSequenceItem(this.current).execute();
        }
    }

    public JScrollPane getScrollPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(this.getBackground());
        jPanel.add("North", this);
        return new JScrollPane(jPanel);
    }
}

