/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jsequence;

import com.javapro.jsequence.JSequence;
import com.javapro.jsequence.SequenceList;
import com.javapro.jsequence.TestSequenceItem;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JSequenceTest
extends JPanel {
    protected JSequence sequence;
    protected JComponent image;

    public JSequenceTest() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(10, 10));
        SequenceList sequenceList = new SequenceList();
        sequenceList.addSequenceItem(new TestSequenceItem("Connecting to server"));
        sequenceList.addSequenceItem(new TestSequenceItem("Transmitting user profile"));
        sequenceList.addSequenceItem(new TestSequenceItem("Receiving product list"));
        sequenceList.addSequenceItem(new TestSequenceItem("Downloading product update"));
        sequenceList.addSequenceItem(new TestSequenceItem("Unpackaging product"));
        sequenceList.addSequenceItem(new TestSequenceItem("Installing software upgrade"));
        sequenceList.addSequenceItem(new TestSequenceItem("Configuring software upgrade"));
        sequenceList.addSequenceItem(new TestSequenceItem("Removing temporary files"));
        this.sequence = new JSequence(sequenceList);
        this.image = this.getImage();
        this.add("West", this.image);
        JScrollPane jScrollPane = this.sequence.getScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add("Center", jScrollPane);
        this.setPreferredSize(new Dimension(450, this.image.getPreferredSize().height + 10));
    }

    public void execute() {
        this.sequence.execute();
    }

    public JComponent getImage() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/cylinders.gif"));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jLabel;
    }

    public static void main(String[] stringArray) {
        JSequenceTest jSequenceTest = new JSequenceTest();
        JFrame jFrame = new JFrame("JSequence Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new GridLayout());
        jFrame.getContentPane().add(jSequenceTest);
        jFrame.pack();
        jFrame.show();
        jSequenceTest.execute();
    }
}

