/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jslide;

import com.javapro.jslide.BoundedRangeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GradientSlide
extends JPanel
implements BoundedRangeView,
ChangeListener,
MouseListener,
MouseMotionListener {
    protected Paint gradient;
    protected BoundedRangeModel model;

    public GradientSlide(Color color, Color color2) {
        this.gradient = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        this.setModel(new DefaultBoundedRangeModel(0, 1, 0, 255));
        this.setBorder(UIManager.getBorder("Slider.border"));
        this.addMouseListener(this);
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (this.model != null) {
            this.model.removeChangeListener(this);
        }
        this.model = boundedRangeModel;
        boundedRangeModel.addChangeListener(this);
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        Insets insets = this.getInsets();
        int n = insets.left + insets.right + 256;
        int n2 = insets.top + insets.bottom + 14;
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.gradient);
        graphics2D.fillRect(n, n2, n3 -= insets.left + insets.right, n4 -= insets.top + insets.bottom);
        int n5 = n + this.model.getValue();
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(n5, n2, n5, n4);
        graphics2D.setColor(Color.white);
        graphics2D.drawLine(n5 - 1, n2, n5 - 1, n4);
        graphics2D.drawLine(n5 + 1, n2, n5 + 1, n4);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.addMouseMotionListener(this);
        this.model.setValue(mouseEvent.getX());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.removeMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.model.setValue(mouseEvent.getX());
    }

    public JComponent getComponent() {
        return this;
    }
}

