/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jslide;

import com.javapro.jslide.BoundedRangeEditor;
import com.javapro.jslide.BoundedRangeView;
import com.javapro.jslide.DefaultSlide;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class JSlide
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected BoundedRangeView field;
    protected BoundedRangeView slider;
    protected JButton button = new BasicArrowButton(5);
    protected JPopupMenu popup = new JPopupMenu();
    protected Point anchor;
    protected int offset;

    public JSlide() {
        this(new BoundedRangeEditor(), new DefaultSlide());
    }

    public JSlide(BoundedRangeView boundedRangeView) {
        this(new BoundedRangeEditor(), boundedRangeView);
    }

    public JSlide(BoundedRangeView boundedRangeView, BoundedRangeView boundedRangeView2) {
        this.field = boundedRangeView;
        this.slider = boundedRangeView2;
        this.setLayout(new BorderLayout());
        this.add("Center", boundedRangeView.getComponent());
        this.add("East", this.button);
        this.button.setPreferredSize(new Dimension(16, 16));
        this.button.addMouseListener(this);
        this.popup.add(boundedRangeView2.getComponent());
        boundedRangeView.setModel(boundedRangeView2.getModel());
    }

    protected void popup() {
        BoundedRangeModel boundedRangeModel = this.slider.getModel();
        double d = boundedRangeModel.getMinimum();
        double d2 = boundedRangeModel.getMaximum();
        double d3 = boundedRangeModel.getValue();
        double d4 = (d3 - d) / (d2 - d);
        double d5 = this.slider.getComponent().getPreferredSize().width;
        this.offset = (int)(d4 * d5) - this.button.getSize().width / 2;
        this.popup.show(this.button, -this.offset, this.button.getSize().height);
    }

    protected void adjust(int n) {
        BoundedRangeModel boundedRangeModel = this.slider.getModel();
        double d = boundedRangeModel.getMinimum();
        double d2 = boundedRangeModel.getMaximum();
        double d3 = boundedRangeModel.getValue();
        double d4 = this.slider.getComponent().getPreferredSize().width;
        double d5 = d + (double)n / d4 * (d2 - d);
        boundedRangeModel.setValue((int)d5);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.button.getSize().width / 2;
        int n2 = this.button.getSize().height / 2;
        this.anchor = new Point(n, n2);
        this.button.addMouseMotionListener(this);
        this.popup();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.button.removeMouseMotionListener(this);
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.offset + mouseEvent.getPoint().x - this.anchor.x;
        this.adjust(n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

