/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jsplitview;

import com.javapro.jsplitview.SplitBar;
import com.javapro.jsplitview.SplitViewLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class SplitPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected Rectangle apex;
    protected SplitViewLayout layout;
    protected SplitBar vert;
    protected SplitBar horz;
    protected int xAnchor = -1;
    protected int yAnchor = -1;
    protected Cursor normalCursor = Cursor.getPredefinedCursor(0);
    protected Cursor verticalCursor = Cursor.getPredefinedCursor(8);
    protected Cursor horizontalCursor = Cursor.getPredefinedCursor(10);
    protected Cursor resizeCursor = Cursor.getPredefinedCursor(13);

    public SplitPanel() {
        this.setOpaque(false);
        this.apex = new Rectangle(0, 0, 4, 4);
        this.layout = new SplitViewLayout();
        this.setLayout(this.layout);
        this.vert = new SplitBar();
        this.add((Component)this.vert, "VERT");
        this.horz = new SplitBar();
        this.add((Component)this.horz, "HORZ");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    protected boolean containsX(Rectangle rectangle, int n) {
        return n >= rectangle.x && n <= rectangle.x + rectangle.width;
    }

    protected boolean containsY(Rectangle rectangle, int n) {
        return n >= rectangle.y && n <= rectangle.y + rectangle.height;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(this.normalCursor);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(this.normalCursor);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.containsX(this.apex, n)) {
            this.vert.setTransparency(false);
            this.vert.repaint();
            this.xAnchor = n;
        }
        if (this.containsY(this.apex, n2)) {
            this.horz.setTransparency(false);
            this.horz.repaint();
            this.yAnchor = n2;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.xAnchor = -1;
        this.yAnchor = -1;
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.horz.setTransparency(true);
        this.horz.setBounds(0, this.apex.y, n, this.apex.height);
        this.vert.setTransparency(true);
        this.vert.setBounds(this.apex.x, 0, this.apex.width, n2);
        this.layout.setApex(this.apex);
        this.doLayout();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = this.containsX(this.apex, n);
        boolean bl2 = this.containsY(this.apex, n2);
        if (bl2 && bl) {
            this.setCursor(this.resizeCursor);
        } else if (bl) {
            this.setCursor(this.horizontalCursor);
        } else if (bl2) {
            this.setCursor(this.verticalCursor);
        } else {
            this.setCursor(this.normalCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if (this.xAnchor == -1) {
            n3 = this.apex.x;
        }
        if (this.yAnchor == -1) {
            n4 = this.apex.y;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n5 = n - this.apex.width;
        int n6 = n2 - this.apex.height;
        if (n3 > n5) {
            n3 = n5;
        }
        if (n4 > n6) {
            n4 = n6;
        }
        this.apex = new Rectangle(n3, n4, 4, 4);
        this.horz.setBounds(0, this.apex.y, n, this.apex.height);
        this.vert.setBounds(this.apex.x, 0, this.apex.width, n2);
        this.repaint();
    }
}

