/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.jsplitview;

import com.javapro.jbinder.AbstractLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class SplitViewLayout
extends AbstractLayout {
    public static final String NW = "NW";
    public static final String NE = "NE";
    public static final String SW = "SW";
    public static final String SE = "SE";
    public static final String VERT = "VERT";
    public static final String HORZ = "HORZ";
    protected Rectangle apex = new Rectangle(0, 0, 4, 4);
    protected JComponent nw;
    protected JComponent ne;
    protected JComponent sw;
    protected JComponent se;
    protected Component vert;
    protected Component horz;

    public void setApex(Rectangle rectangle) {
        this.apex = rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        JComponent jComponent = (JComponent)component;
        Object object2 = jComponent.getTreeLock();
        synchronized (object2) {
            if (object.equals(NW)) {
                this.nw = jComponent;
            } else if (object.equals(NE)) {
                this.ne = jComponent;
            } else if (object.equals(SW)) {
                this.sw = jComponent;
            } else if (object.equals(SE)) {
                this.se = jComponent;
            } else if (object.equals(VERT)) {
                this.vert = jComponent;
            } else if (object.equals(HORZ)) {
                this.horz = jComponent;
            } else {
                throw new IllegalArgumentException("Unrecognized constrain value: " + object.toString());
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.nw != null ? this.nw.getMinimumSize() : new Dimension(0, 0);
        Dimension dimension2 = this.ne != null ? this.ne.getMinimumSize() : new Dimension(0, 0);
        Dimension dimension3 = this.sw != null ? this.sw.getMinimumSize() : new Dimension(0, 0);
        Dimension dimension4 = this.se != null ? this.se.getMinimumSize() : new Dimension(0, 0);
        Dimension dimension5 = this.vert != null ? this.vert.getMinimumSize() : new Dimension(0, 0);
        Dimension dimension6 = this.horz != null ? this.horz.getMinimumSize() : new Dimension(0, 0);
        int n = dimension6.width + Math.max(dimension.width, dimension3.width) + Math.max(dimension2.width, dimension4.width);
        int n2 = dimension5.height + Math.max(dimension.height, dimension2.height) + Math.max(dimension3.height, dimension4.height);
        return new Dimension(n, n2);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.nw != null ? this.nw.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.ne != null ? this.ne.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension3 = this.sw != null ? this.sw.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension4 = this.se != null ? this.se.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension5 = this.vert != null ? this.vert.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension6 = this.horz != null ? this.horz.getPreferredSize() : new Dimension(0, 0);
        int n = dimension6.width + Math.max(dimension.width, dimension3.width) + Math.max(dimension2.width, dimension4.width);
        int n2 = dimension5.height + Math.max(dimension.height, dimension2.height) + Math.max(dimension3.height, dimension4.height);
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        int n = container.getSize().width;
        int n2 = container.getSize().height;
        int n3 = this.apex.x + this.apex.width;
        int n4 = this.apex.y + this.apex.height;
        if (this.nw != null) {
            this.nw.setBounds(0, 0, this.apex.x, this.apex.y);
            if (this.nw.isValidateRoot()) {
                this.nw.doLayout();
                this.nw.revalidate();
            }
        }
        if (this.ne != null) {
            this.ne.setBounds(n3, 0, n - n3, this.apex.y);
            if (this.ne.isValidateRoot()) {
                this.ne.doLayout();
                this.ne.revalidate();
            }
        }
        if (this.sw != null) {
            this.sw.setBounds(0, n4, this.apex.x, n2 - n4);
            if (this.sw.isValidateRoot()) {
                this.sw.doLayout();
                this.sw.revalidate();
            }
        }
        if (this.se != null) {
            this.se.setBounds(n3, n4, n - n3, n2 - n4);
            if (this.se.isValidateRoot()) {
                this.se.doLayout();
                this.se.revalidate();
            }
        }
    }
}

