/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.task;

import com.javapro.task.Task;
import com.javapro.task.TaskPersistStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FilePersistStrategy
implements TaskPersistStrategy {
    protected String TASK_FILE_EXT = ".task";
    private File persistStorage;
    private TaskFileFilter taskFileFilter;

    protected FilePersistStrategy() {
    }

    public FilePersistStrategy(File file) throws IOException {
        this.init(file);
    }

    protected void init(File file) throws IOException {
        this.persistStorage = file;
        if (!this.persistStorage.isDirectory()) {
            throw new IOException("Expected a directory: " + file.getPath());
        }
        this.taskFileFilter = new TaskFileFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] readAll() throws IOException, ClassNotFoundException {
        FilePersistStrategy filePersistStrategy = this;
        synchronized (filePersistStrategy) {
            File[] fileArray = this.persistStorage.listFiles(this.taskFileFilter);
            Task[] taskArray = new Task[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                taskArray[i] = (Task)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            return taskArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Task task) throws IOException {
        FilePersistStrategy filePersistStrategy = this;
        synchronized (filePersistStrategy) {
            String string = new String(this.persistStorage.getPath() + File.separator + task.getID() + this.TASK_FILE_EXT);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(task);
            objectOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Task task) {
        FilePersistStrategy filePersistStrategy = this;
        synchronized (filePersistStrategy) {
            String string = new String(this.persistStorage.getPath() + File.separator + task.getID() + this.TASK_FILE_EXT);
            File file = new File(string);
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        FilePersistStrategy filePersistStrategy = this;
        synchronized (filePersistStrategy) {
            File[] fileArray = this.persistStorage.listFiles(this.taskFileFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
    }

    private class TaskFileFilter
    implements FilenameFilter {
        private TaskFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(FilePersistStrategy.this.TASK_FILE_EXT);
        }
    }
}

