/*
 * Decompiled with CFR 0.152.
 */
package com.javapro.task;

import com.javapro.task.TaskScheduler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class Task
implements Runnable,
Externalizable {
    protected boolean isCancelled = false;
    protected String name = null;
    private transient long ID;
    private boolean hasBeenScheduled = false;
    private long scheduledInitialTime = 0L;
    private long scheduledInterval = 0L;
    private long lastRunTime = 0L;
    TaskScheduler scheduler = null;
    private static Boolean mutex = new Boolean(true);
    private static long nextID = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task() {
        Boolean bl = mutex;
        synchronized (bl) {
            this.ID = nextID++;
            if (nextID == Long.MAX_VALUE) {
                nextID = 0L;
            }
        }
    }

    public final synchronized void setSchedule(long l, long l2) throws IllegalStateException {
        if (this.hasBeenScheduled) {
            throw new IllegalStateException("Cannot set schedule for the task more than once.");
        }
        this.hasBeenScheduled = true;
        this.scheduledInitialTime = l;
        this.scheduledInterval = l2;
    }

    public long getID() {
        return this.ID;
    }

    public long getScheduledFirstTime() {
        return this.scheduledInitialTime;
    }

    public long getScheduledInterval() {
        return this.scheduledInterval;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public String getName() {
        if (this.name == null) {
            return this.getClass().toString();
        }
        return this.name;
    }

    public void persist() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.persist(this);
        }
    }

    public void cancel() {
        this.isCancelled = true;
        if (this.scheduler != null) {
            this.scheduler.cleanup(this);
        }
    }

    public long lastExecutionTime() {
        return this.lastRunTime;
    }

    void setLastRunTime(long l) {
        this.lastRunTime = l;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.scheduledInitialTime);
        objectOutput.writeLong(this.scheduledInterval);
        objectOutput.writeLong(this.lastRunTime);
        objectOutput.writeObject(this.name);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.scheduledInitialTime = objectInput.readLong();
        this.scheduledInterval = objectInput.readLong();
        this.lastRunTime = objectInput.readLong();
        this.name = (String)objectInput.readObject();
        if (this.scheduledInitialTime < System.currentTimeMillis()) {
            long l = System.currentTimeMillis() - this.scheduledInitialTime;
            this.scheduledInitialTime = System.currentTimeMillis() + (l %= this.scheduledInterval);
        }
        this.hasBeenScheduled = true;
    }

    public abstract void run();

    public abstract String getStatus();
}

