/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import com.jhlabs.awt.BasicGridLayout;
import com.jhlabs.awt.ClockLayout;
import com.jhlabs.awt.GridLayoutPlus;
import com.jhlabs.awt.PackerLayout;
import com.jhlabs.awt.ParagraphLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LayoutTest {
    public static void main(String[] stringArray) {
        LayoutTest.paragraphLayout();
        LayoutTest.packerLayout();
        LayoutTest.gridLayoutPlus();
        LayoutTest.basicGridLayout();
        LayoutTest.clockLayout();
    }

    public static void paragraphLayout() {
        JFrame jFrame = new JFrame("ParagraphLayout");
        Container container = jFrame.getContentPane();
        container.setLayout(new ParagraphLayout());
        JButton jButton = new JButton("One");
        JButton jButton2 = new JButton("Two");
        JButton jButton3 = new JButton("Three");
        JButton jButton4 = new JButton("Four");
        JButton jButton5 = new JButton("Five");
        JButton jButton6 = new JButton("Six");
        JButton jButton7 = new JButton("Seven");
        JButton jButton8 = new JButton("Eight");
        JTextField jTextField = new JTextField(4);
        JTextField jTextField2 = new JTextField(20);
        JTextArea jTextArea = new JTextArea(5, 30);
        jButton2.setFont(new Font("serif", 0, 24));
        container.add((Component)new JLabel("Some buttons:"), ParagraphLayout.NEW_PARAGRAPH);
        container.add(jButton);
        container.add((Component)new JLabel("A long label:"), ParagraphLayout.NEW_PARAGRAPH);
        container.add(jButton2);
        container.add(jButton3);
        container.add((Component)new JLabel("Short label:"), ParagraphLayout.NEW_PARAGRAPH);
        container.add(jButton4);
        container.add((Component)jButton5, ParagraphLayout.NEW_LINE);
        container.add(jButton6);
        container.add(jButton7);
        container.add((Component)jButton8, ParagraphLayout.NEW_LINE);
        container.add((Component)new JLabel("Text:"), ParagraphLayout.NEW_PARAGRAPH);
        container.add(jTextField);
        container.add((Component)new JLabel("More text:"), ParagraphLayout.NEW_PARAGRAPH);
        container.add(jTextField2);
        container.add(new JLabel("miles"));
        container.add((Component)new JLabel("A text area:"), ParagraphLayout.NEW_PARAGRAPH_TOP);
        container.add(jTextArea);
        jFrame.pack();
        jFrame.show();
    }

    public static void packerLayout() {
        JFrame jFrame = new JFrame("PackerLayout");
        Container container = jFrame.getContentPane();
        container.setLayout(new PackerLayout());
        JButton jButton = new JButton("One");
        JButton jButton2 = new JButton("Two");
        JButton jButton3 = new JButton("Three");
        JButton jButton4 = new JButton("Four");
        JButton jButton5 = new JButton("Five");
        JButton jButton6 = new JButton("Six");
        jButton2.setFont(new Font("serif", 0, 24));
        container.add(jButton);
        container.add((Component)jButton2, PackerLayout.LEFT_CENTER);
        container.add((Component)jButton3, PackerLayout.BOTTOM_CENTER_FILL);
        container.add((Component)jButton4, PackerLayout.TOP_CENTER_FILL);
        container.add((Component)jButton5, PackerLayout.TOP_LEFT);
        container.add((Component)jButton6, PackerLayout.RIGHT_CENTER);
        jFrame.pack();
        jFrame.show();
    }

    public static void gridLayoutPlus() {
        JFrame jFrame = new JFrame("GridLayoutPlus");
        Container container = jFrame.getContentPane();
        GridLayoutPlus gridLayoutPlus = new GridLayoutPlus(0, 3, 10, 10);
        gridLayoutPlus.setColWeight(1, 2);
        gridLayoutPlus.setColWeight(2, 1);
        gridLayoutPlus.setRowWeight(2, 1);
        container.setLayout(gridLayoutPlus);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                container.add(new JButton(i + "," + j));
            }
        }
        jFrame.pack();
        jFrame.show();
    }

    public static void basicGridLayout() {
        JFrame jFrame = new JFrame("BasicGridLayout");
        Container container = jFrame.getContentPane();
        BasicGridLayout basicGridLayout = new BasicGridLayout(0, 3, 10, 10);
        basicGridLayout.setColWeight(1);
        basicGridLayout.setRowWeight(1);
        basicGridLayout.setIncludeInvisible(false);
        container.setLayout(basicGridLayout);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                JButton jButton = new JButton(i + "," + j);
                container.add(jButton);
                jButton.setVisible((i + j) % 4 != 0);
            }
        }
        jFrame.pack();
        jFrame.show();
    }

    public static void clockLayout() {
        JFrame jFrame = new JFrame("ClockLayout");
        Container container = jFrame.getContentPane();
        container.setLayout(new ClockLayout());
        for (int i = 0; i < 12; ++i) {
            container.add(new JButton(i + ""));
        }
        jFrame.pack();
        jFrame.show();
    }
}

